/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.extensions;

import com.liferay.ant.bnd.bower.BowerAnalyzerPlugin;
import com.liferay.ant.bnd.jsp.JspAnalyzerPlugin;
import com.liferay.ant.bnd.sass.SassAnalyzerPlugin;
import com.liferay.ant.bnd.spring.SpringDependencyAnalyzerPlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.Validator;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;

public class LiferayOSGiExtension
extends LiferayExtension {
    private static final String[] _BND_PLUGIN_CLASS_NAMES = new String[]{BowerAnalyzerPlugin.class.getName(), JspAnalyzerPlugin.class.getName(), SassAnalyzerPlugin.class.getName(), SpringDependencyAnalyzerPlugin.class.getName()};
    private boolean _autoUpdateXml = true;

    public LiferayOSGiExtension(Project project) {
        super(project);
    }

    public Map<String, String> getBundleDefaultInstructions() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Bundle-SymbolicName", this.project.getName());
        map.put("Bundle-Vendor", "Liferay, Inc.");
        map.put("-donotcopy", "(.touch)");
        map.put("-dsannotations", "*");
        map.put("-metatype", "*");
        map.put("-plugin", StringUtil.merge((String[])_BND_PLUGIN_CLASS_NAMES, (String)","));
        map.put("-sources", "false");
        map.put("Git-Descriptor", "${system-allow-fail;git describe --dirty --always}");
        map.put("Git-SHA", "${system-allow-fail;git rev-list -1 HEAD}");
        JavaCompile javaCompile = (JavaCompile)GradleUtil.getTask((Project)this.project, (String)"compileJava");
        CompileOptions compileOptions = javaCompile.getOptions();
        map.put("Javac-Debug", this._getOnOffValue(compileOptions.isDebug()));
        map.put("Javac-Deprecation", this._getOnOffValue(compileOptions.isDeprecation()));
        String encoding = compileOptions.getEncoding();
        if (Validator.isNull((String)encoding)) {
            encoding = System.getProperty("file.encoding");
        }
        map.put("Javac-Encoding", encoding);
        map.put("-jsp", "*.jsp,*.jspf");
        map.put("-sass", "*");
        return map;
    }

    public boolean isAutoUpdateXml() {
        return this._autoUpdateXml;
    }

    public void setAutoUpdateXml(boolean autoUpdateXml) {
        this._autoUpdateXml = autoUpdateXml;
    }

    private String _getOnOffValue(boolean b) {
        if (b) {
            return "on";
        }
        return "off";
    }
}

