/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.extensions;

import com.liferay.gradle.plugins.extensions.AppServer;
import com.liferay.gradle.plugins.extensions.AppServerFactory;
import com.liferay.gradle.util.GradleUtil;
import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;

public class LiferayExtension {
    protected final Project project;
    private Object _appServerParentDir;
    private final NamedDomainObjectContainer<AppServer> _appServers;
    private String _appServerType;
    private Object _deployDir;
    private Object _jmxRemotePort;
    private Object _liferayHome;
    private String _portalVersion;

    public LiferayExtension(Project project) {
        this.project = project;
        this._appServers = project.container(AppServer.class, (NamedDomainObjectFactory)new AppServerFactory(project));
    }

    public void appServers(Closure<?> closure) {
        this._appServers.configure(closure);
    }

    public AppServer getAppServer() {
        return this.getAppServer(this.getAppServerType());
    }

    public AppServer getAppServer(String type) {
        return (AppServer)this._appServers.getAt(type);
    }

    public File getAppServerDeployDir() {
        AppServer appServer = this.getAppServer();
        return appServer.getDeployDir();
    }

    public File getAppServerDir() {
        AppServer appServer = this.getAppServer();
        return appServer.getDir();
    }

    public File getAppServerLibGlobalDir() {
        AppServer appServer = this.getAppServer();
        return appServer.getLibGlobalDir();
    }

    public File getAppServerParentDir() {
        return this.project.file(this._appServerParentDir);
    }

    public File getAppServerPortalDir() {
        AppServer appServer = this.getAppServer();
        return appServer.getPortalDir();
    }

    public NamedDomainObjectContainer<AppServer> getAppServers() {
        return this._appServers;
    }

    public String getAppServerType() {
        return this._appServerType;
    }

    public File getDeployDir() {
        return this.project.file(this._deployDir);
    }

    public int getJmxRemotePort() {
        Integer jmxRemotePort = GradleUtil.toInteger((Object)this._jmxRemotePort);
        if (jmxRemotePort != null) {
            return jmxRemotePort;
        }
        return 0;
    }

    public File getLiferayHome() {
        return this.project.file(this._liferayHome);
    }

    public String getPortalVersion() {
        return this._portalVersion;
    }

    public String getVersionPrefix() {
        String version = this.getPortalVersion();
        int index = version.indexOf("-");
        if (index != -1) {
            version = version.substring(0, index);
        }
        return version;
    }

    public void setAppServerParentDir(Object appServerParentDir) {
        this._appServerParentDir = appServerParentDir;
    }

    public void setAppServerType(String appServerType) {
        this._appServerType = appServerType;
    }

    public void setDeployDir(Object deployDir) {
        this._deployDir = deployDir;
    }

    public void setJmxRemotePort(Object jmxRemotePort) {
        this._jmxRemotePort = jmxRemotePort;
    }

    public void setLiferayHome(Object liferayHome) {
        this._liferayHome = liferayHome;
    }

    public void setPortalVersion(String portalVersion) {
        this._portalVersion = portalVersion;
    }
}

