/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.LiferayJavaPlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.service.builder.BuildServiceTask;
import com.liferay.gradle.plugins.tasks.DirectDeployTask;
import com.liferay.gradle.plugins.xsd.builder.BuildXSDTask;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.Validator;
import com.liferay.gradle.util.copy.RenameDependencyClosure;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.CopySpecResolver;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.War;
import org.gradle.api.tasks.compile.JavaCompile;

public class LiferayWebAppPlugin
extends LiferayJavaPlugin {
    public static final String DIRECT_DEPLOY_TASK_NAME = "directDeploy";

    protected Task addTaskBuildServiceCompile(BuildServiceTask buildServiceTask) {
        Project project = buildServiceTask.getProject();
        JavaCompile javaCompile = (JavaCompile)GradleUtil.addTask((Project)project, (String)(buildServiceTask.getName() + "Compile"), JavaCompile.class);
        javaCompile.dependsOn(new Object[]{buildServiceTask});
        javaCompile.dependsOn(new Object[]{"clean" + StringUtil.capitalize((String)javaCompile.getName())});
        FileCollection fileCollection = buildServiceTask.getClasspath();
        final File serviceJarFile = this.getServiceJarFile(project);
        fileCollection = fileCollection.filter((Spec)new Spec<File>(){

            public boolean isSatisfiedBy(File file) {
                return !file.equals(serviceJarFile);
            }
        });
        javaCompile.setClasspath(fileCollection);
        File destinationDir = new File(project.getBuildDir(), javaCompile.getName());
        javaCompile.setDestinationDir(destinationDir);
        javaCompile.setSource((Object)buildServiceTask.getApiDir());
        return javaCompile;
    }

    protected Task addTaskBuildServiceJar(BuildServiceTask buildServiceTask, Task buildServiceCompileTask) {
        Project project = buildServiceTask.getProject();
        Jar jar = (Jar)GradleUtil.addTask((Project)project, (String)(buildServiceTask.getName() + "Jar"), Jar.class);
        jar.from(new Object[]{buildServiceCompileTask.getOutputs()});
        jar.setDescription("Assembles the service JAR file.");
        File serviceJarFile = this.getServiceJarFile(project);
        jar.setArchiveName(serviceJarFile.getName());
        jar.setDestinationDir(serviceJarFile.getParentFile());
        return jar;
    }

    protected void addTaskBuildServiceTasks(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildServiceTask.class, (Action)new Action<BuildServiceTask>(){

            public void execute(BuildServiceTask buildServiceTask) {
                Task buildServiceCompileTask = LiferayWebAppPlugin.this.addTaskBuildServiceCompile(buildServiceTask);
                Task buildServiceJarTask = LiferayWebAppPlugin.this.addTaskBuildServiceJar(buildServiceTask, buildServiceCompileTask);
                buildServiceTask.finalizedBy(new Object[]{buildServiceJarTask});
            }
        });
    }

    @Override
    protected Copy addTaskDeploy(Project project) {
        Copy copy = super.addTaskDeploy(project);
        copy.setGroup("web application");
        return copy;
    }

    protected DirectDeployTask addTaskDirectDeploy(Project project) {
        final DirectDeployTask directDeployTask = (DirectDeployTask)GradleUtil.addTask((Project)project, (String)DIRECT_DEPLOY_TASK_NAME, DirectDeployTask.class);
        directDeployTask.dependsOn(new Object[]{"war"});
        directDeployTask.setDescription("Assembles the project into a WAR file and directly deploys it to Liferay, skipping the auto deploy directory.");
        directDeployTask.setGroup("web application");
        TaskInputs taskInputs = directDeployTask.getInputs();
        taskInputs.dir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return directDeployTask.getWebAppFile();
            }
        });
        return directDeployTask;
    }

    @Override
    protected void addTasks(Project project) {
        super.addTasks(project);
        this.addTaskDirectDeploy(project);
    }

    @Override
    protected void applyPlugins(Project project) {
        super.applyPlugins(project);
        GradleUtil.applyPlugin((Project)project, WarPlugin.class);
    }

    @Override
    protected void configureDependencies(Project project) {
        super.configureDependencies(project);
        this.configureDependenciesCompile(project);
    }

    protected void configureDependenciesCompile(Project project) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                File serviceJarFile = LiferayWebAppPlugin.this.getServiceJarFile(project);
                if (serviceJarFile.exists()) {
                    GradleUtil.addDependency((Project)project, (String)"compile", (File)serviceJarFile);
                }
            }
        });
    }

    @Override
    protected void configureProperties(Project project) {
        super.configureProperties(project);
        this.configureWebAppDirName(project);
    }

    @Override
    protected void configureSourceSetMain(Project project) {
        File classesDir = project.file((Object)"docroot/WEB-INF/classes");
        File srcDir = project.file((Object)"docroot/WEB-INF/src");
        this.configureSourceSet(project, "main", classesDir, srcDir);
    }

    @Override
    protected void configureTaskBuildXSDInputDir(BuildXSDTask buildXSDTask) {
        File inputDir = new File(this.getWebAppDir(buildXSDTask.getProject()), "WEB-INF/xsd");
        buildXSDTask.setInputDir((Object)inputDir);
    }

    @Override
    protected void configureTaskDeployFrom(Copy copy) {
        Project project = copy.getProject();
        War war = (War)GradleUtil.getTask((Project)project, (String)"war");
        copy.from(new Object[]{war});
        this.addCleanDeployedFile(project, war.getArchivePath());
    }

    protected void configureTaskDirectDeploy(Project project, LiferayExtension liferayExtension) {
        DirectDeployTask directDeployTask = (DirectDeployTask)GradleUtil.getTask((Project)project, (String)DIRECT_DEPLOY_TASK_NAME);
        this.configureTaskDirectDeployAppServerDeployDir(directDeployTask, liferayExtension);
        this.configureTaskDirectDeployWebAppFile(directDeployTask);
        this.configureTaskDirectDeployWebAppType(directDeployTask);
    }

    protected void configureTaskDirectDeployAppServerDeployDir(DirectDeployTask directDeployTask, LiferayExtension liferayExtension) {
        if (directDeployTask.getAppServerDeployDir() == null) {
            directDeployTask.setAppServerDeployDir(liferayExtension.getAppServerDeployDir());
        }
    }

    protected void configureTaskDirectDeployWebAppFile(DirectDeployTask directDeployTask) {
        if (directDeployTask.getWebAppFile() != null) {
            return;
        }
        War war = (War)GradleUtil.getTask((Project)directDeployTask.getProject(), (String)"war");
        directDeployTask.setWebAppFile(war.getArchivePath());
    }

    protected void configureTaskDirectDeployWebAppType(DirectDeployTask directDeployTask) {
        if (Validator.isNull((String)directDeployTask.getWebAppType())) {
            directDeployTask.setWebAppType(this.getWebAppType(directDeployTask.getProject()));
        }
    }

    @Override
    protected void configureTasks(Project project, LiferayExtension liferayExtension) {
        super.configureTasks(project, liferayExtension);
        this.configureTaskDirectDeploy(project, liferayExtension);
        this.configureTaskWar(project, liferayExtension);
        this.addTaskBuildServiceTasks(project);
    }

    protected void configureTaskWar(Project project, LiferayExtension liferayExtension) {
        War war = (War)GradleUtil.getTask((Project)project, (String)"war");
        this.configureTaskWarAlloyPortlet(war);
        this.configureTaskWarDuplicatesStrategy(war);
        this.configureTaskWarExcludeManifest(war);
        this.configureTaskWarFilesMatching(war);
        this.configureTaskWarOutputs(war);
        this.configureTaskWarRenameDependencies(war);
    }

    protected void configureTaskWarAlloyPortlet(final War war) {
        Project project = war.getProject();
        String projectName = project.getName();
        if (!projectName.endsWith("-portlet")) {
            return;
        }
        File webAppDir = this.getWebAppDir(project);
        String portletXml = "";
        try {
            File portletXmlFile = new File(webAppDir, "WEB-INF/portlet.xml");
            if (portletXmlFile.exists()) {
                portletXml = new String(Files.readAllBytes(portletXmlFile.toPath()), StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            throw new GradleException("Unable to read portlet.xml", (Throwable)e);
        }
        if (!portletXml.contains("com.liferay.alloy.mvc.AlloyPortlet")) {
            return;
        }
        war.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                ClassLoader classLoader = LiferayWebAppPlugin.class.getClassLoader();
                try (InputStream inputStream = classLoader.getResourceAsStream("com/liferay/gradle/plugins/dependencies/touch.jsp");){
                    File touchJspFile = new File(task.getTemporaryDir(), "touch.jsp");
                    Files.copy(inputStream, touchJspFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    throw new GradleException("Unable to copy touch.jsp", (Throwable)e);
                }
            }
        });
        war.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                File touchJspFile = new File(task.getTemporaryDir(), "touch.jsp");
                project.delete(new Object[]{touchJspFile});
            }
        });
        File jspDir = new File(webAppDir, "WEB-INF/jsp");
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path path) throws IOException {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    return false;
                }
                Path viewsDirPath = path.resolve("views");
                return Files.exists(viewsDirPath, new LinkOption[0]);
            }
        };
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(jspDir.toPath(), (DirectoryStream.Filter<? super Path>)filter);){
            Closure<Void> closure = new Closure<Void>(null){

                public void doCall(CopySpec copySpec) {
                    File touchJspFile = new File(war.getTemporaryDir(), "touch.jsp");
                    copySpec.from(new Object[]{touchJspFile});
                }
            };
            for (Path path : directoryStream) {
                war.into((Object)FileUtil.relativize((File)path.toFile(), (File)webAppDir), (Closure)closure);
            }
        }
        catch (Exception e) {
            throw new GradleException(e.getMessage(), (Throwable)e);
        }
    }

    protected void configureTaskWarDuplicatesStrategy(War war) {
        war.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
    }

    protected void configureTaskWarExcludeManifest(War war) {
        CopySpecInternal copySpecInternal = war.getRootSpec();
        for (CopySpecInternal childCopySpecInternal : copySpecInternal.getChildren()) {
            CopySpecResolver copySpecResolver = childCopySpecInternal.buildRootResolver();
            RelativePath destRelativePath = copySpecResolver.getDestPath();
            String destRelativePathString = destRelativePath.getPathString();
            if (!destRelativePathString.equals("META-INF")) continue;
            childCopySpecInternal.exclude(new String[]{"**"});
            return;
        }
    }

    protected void configureTaskWarFilesMatching(War war) {
        final Project project = war.getProject();
        Closure<String> closure = new Closure<String>(null){

            public String doCall(String line) {
                if (!line.contains("content/Language*.properties")) {
                    return line;
                }
                StringBuilder sb = new StringBuilder();
                SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
                FileTree fileTree = GradleUtil.getFilteredFileTree((FileTree)sourceSet.getResources(), null, (String[])new String[]{"content/Language*.properties"});
                for (File file : fileTree) {
                    sb.append("\t<language-properties>content/");
                    sb.append(file.getName());
                    sb.append("</language-properties>");
                    sb.append("\n");
                }
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - 1);
                }
                return sb.toString();
            }
        };
        war.filesMatching("WEB-INF/liferay-hook.xml", (Action)new Action<FileCopyDetails>((Closure)closure){
            final /* synthetic */ Closure val$closure;
            {
                this.val$closure = closure;
            }

            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetails.filter(this.val$closure);
            }
        });
    }

    protected void configureTaskWarOutputs(War war) {
        TaskOutputsInternal taskOutputs = war.getOutputs();
        taskOutputs.file((Object)war.getArchivePath());
    }

    protected void configureTaskWarRenameDependencies(War war) {
        RenameDependencyClosure closure = new RenameDependencyClosure(war.getProject(), new String[]{"runtime"});
        CopySpecInternal copySpecInternal = war.getRootSpec();
        for (CopySpecInternal childCopySpecInternal : copySpecInternal.getChildren()) {
            childCopySpecInternal.rename((Closure)closure);
        }
    }

    @Override
    protected void configureVersion(Project project, LiferayExtension liferayExtension) {
        Object versionObj = project.getVersion();
        if (!versionObj.equals("unspecified")) {
            super.configureVersion(project, liferayExtension);
            return;
        }
        File pluginPackagePropertiesFile = new File(this.getWebAppDir(project), "WEB-INF/liferay-plugin-package.properties");
        Properties pluginPackageProperties = null;
        try {
            pluginPackageProperties = FileUtil.readProperties((File)pluginPackagePropertiesFile);
        }
        catch (Exception e) {
            throw new GradleException("Unable to read " + pluginPackagePropertiesFile, (Throwable)e);
        }
        String version = pluginPackageProperties.getProperty("module-full-version");
        if (Validator.isNull((String)version)) {
            version = pluginPackageProperties.getProperty("module-incremental-version");
            version = liferayExtension.getVersionPrefix() + "." + version;
        }
        project.setVersion((Object)version);
    }

    protected void configureWebAppDirName(Project project) {
        WarPluginConvention warPluginConvention = (WarPluginConvention)GradleUtil.getConvention((Project)project, WarPluginConvention.class);
        warPluginConvention.setWebAppDirName("docroot");
    }

    @Override
    protected File getLibDir(Project project) {
        return new File(this.getWebAppDir(project), "WEB-INF/lib");
    }

    protected File getServiceJarFile(Project project) {
        return new File(this.getLibDir(project), project.getName() + "-service.jar");
    }

    protected File getWebAppDir(Project project) {
        WarPluginConvention warPluginConvention = (WarPluginConvention)GradleUtil.getConvention((Project)project, WarPluginConvention.class);
        return warPluginConvention.getWebAppDir();
    }

    protected String getWebAppType(Project project) {
        String projectName = project.getName();
        int index = projectName.lastIndexOf("-");
        return projectName.substring(index + 1);
    }
}

