/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.LiferayWebAppPlugin;
import com.liferay.gradle.plugins.css.builder.BuildCSSTask;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.extensions.LiferayThemeExtension;
import com.liferay.gradle.plugins.tasks.BuildThumbnailsTask;
import com.liferay.gradle.plugins.tasks.CompileThemeTask;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.HashMap;
import java.util.Set;
import nebula.plugin.extraconfigurations.ProvidedBasePlugin;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.War;

public class LiferayThemePlugin
extends LiferayWebAppPlugin {
    public static final String BUILD_THUMBNAILS_TASK_NAME = "buildThumbnails";
    public static final String COMPILE_THEME_TASK_NAME = "compileTheme";
    public static final String FRONTEND_THEMES_CONFIGURATION_NAME = "frontendThemesWeb";
    private static final String[] _FRONTEND_THEME_DEPENDENCY_NAMES = new String[]{"com.liferay.frontend.theme.admin.web", "com.liferay.frontend.theme.classic.web", "com.liferay.frontend.theme.styled", "com.liferay.frontend.theme.unstyled"};
    private static final String[] _THEME_RUNTIME_DEPENDENCY_NOTATION_PREFIXES = new String[]{"com.liferay.portal:util-bridges", "com.liferay.portal:util-java", "com.liferay.portal:util-taglib", "commons-logging:commons-logging", "log4j:log4j"};

    @Override
    public void apply(Project project) {
        super.apply(project);
        this.configureTaskBuildCSS(project);
    }

    protected Configuration addConfigurationFrontendThemes(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)FRONTEND_THEMES_CONFIGURATION_NAME);
        configuration.setDescription("Configures com.liferay.frontend.theme.* for compiling themes.");
        configuration.setVisible(false);
        GradleUtil.executeIfEmpty((Configuration)configuration, (Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                LiferayThemePlugin.this.addDependenciesFrontendThemes(project);
            }
        });
        return configuration;
    }

    @Override
    protected void addConfigurations(Project project) {
        super.addConfigurations(project);
        this.addConfigurationFrontendThemes(project);
    }

    protected void addDependenciesFrontendThemes(Project project) {
        for (String dependencyName : _FRONTEND_THEME_DEPENDENCY_NAMES) {
            GradleUtil.addDependency((Project)project, (String)FRONTEND_THEMES_CONFIGURATION_NAME, (String)"com.liferay", (String)dependencyName, (String)"latest.release", (boolean)false);
        }
    }

    @Override
    protected LiferayExtension addLiferayExtension(Project project) {
        return (LiferayExtension)GradleUtil.addExtension((ExtensionAware)project, (String)"liferay", LiferayThemeExtension.class);
    }

    protected BuildThumbnailsTask addTaskBuildThumbnails(Project project) {
        BuildThumbnailsTask buildThumbnailsTask = (BuildThumbnailsTask)GradleUtil.addTask((Project)project, (String)BUILD_THUMBNAILS_TASK_NAME, BuildThumbnailsTask.class);
        buildThumbnailsTask.setDescription("Generates thumbnails.");
        buildThumbnailsTask.setGroup("build");
        return buildThumbnailsTask;
    }

    protected CompileThemeTask addTaskCompileTheme(Project project) {
        CompileThemeTask compileThemeTask = (CompileThemeTask)GradleUtil.addTask((Project)project, (String)COMPILE_THEME_TASK_NAME, CompileThemeTask.class);
        compileThemeTask.dependsOn(new Object[]{BUILD_THUMBNAILS_TASK_NAME});
        compileThemeTask.setDescription("Compiles the theme by merging the \"diffs\" directory with the parent theme.");
        compileThemeTask.setGroup("build");
        return compileThemeTask;
    }

    @Override
    protected void addTasks(Project project) {
        super.addTasks(project);
        this.addTaskBuildThumbnails(project);
        this.addTaskCompileTheme(project);
    }

    @Override
    protected void configureDependencies(Project project) {
        super.configureDependencies(project);
        this.configureDependenciesProvided(project);
        this.configureDependenciesRuntime(project);
    }

    @Override
    protected void configureDependenciesProvided(Project project) {
        super.configureDependenciesProvided(project);
        if (!this.isAddDefaultDependencies(project) || !this.hasSources(project)) {
            return;
        }
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)ProvidedBasePlugin.getPROVIDED_CONFIGURATION_NAME());
        for (String dependencyNotationPrefix : _THEME_RUNTIME_DEPENDENCY_NOTATION_PREFIXES) {
            int pos = dependencyNotationPrefix.indexOf(58);
            String group = dependencyNotationPrefix.substring(0, pos);
            String module = dependencyNotationPrefix.substring(pos + 1);
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("group", group);
            args.put("module", module);
            configuration.exclude(args);
        }
    }

    protected void configureDependenciesRuntime(Project project) {
        super.configureDependenciesCompile(project);
        if (!this.isAddDefaultDependencies(project) || !this.hasSources(project)) {
            return;
        }
        for (String dependencyNotationPrefix : _THEME_RUNTIME_DEPENDENCY_NOTATION_PREFIXES) {
            for (String dependencyNotation : DEFAULT_DEPENDENCY_NOTATIONS) {
                if (!dependencyNotation.startsWith(dependencyNotationPrefix)) continue;
                GradleUtil.addDependency((Project)project, (String)"runtime", (String)dependencyNotation);
            }
        }
    }

    protected void configureTaskBuildCSS(Project project) {
        Task task = GradleUtil.getTask((Project)project, (String)"buildCSS");
        if (task instanceof BuildCSSTask) {
            this.configureTaskBuildCSSDependsOn((BuildCSSTask)task);
        }
    }

    protected void configureTaskBuildCSSDependsOn(BuildCSSTask buildCSSTask) {
        buildCSSTask.dependsOn(new Object[]{COMPILE_THEME_TASK_NAME});
    }

    protected void configureTaskBuildThumbnails(Project project, LiferayThemeExtension liferayThemeExtension) {
        BuildThumbnailsTask buildThumbnailsTask = (BuildThumbnailsTask)GradleUtil.getTask((Project)project, (String)BUILD_THUMBNAILS_TASK_NAME);
        this.configureTaskBuildThumbnailsImagesDir(buildThumbnailsTask, liferayThemeExtension);
    }

    protected void configureTaskBuildThumbnailsImagesDir(BuildThumbnailsTask buildThumbnailsTask, LiferayThemeExtension liferayThemeExtension) {
        FileCollection imageDirs = buildThumbnailsTask.getImageDirs();
        if (!imageDirs.isEmpty()) {
            return;
        }
        File diffsDir = this.getDiffsDir(buildThumbnailsTask.getProject(), liferayThemeExtension);
        if (diffsDir != null) {
            File imagesDir = new File(liferayThemeExtension.getDiffsDir(), "images");
            buildThumbnailsTask.imageDirs(imagesDir);
        }
    }

    @Override
    protected void configureTaskClassesDependsOn(Task classesTask) {
        super.configureTaskClassesDependsOn(classesTask);
        classesTask.dependsOn(new Object[]{COMPILE_THEME_TASK_NAME});
    }

    protected void configureTaskCompileTheme(Project project, LiferayThemeExtension liferayThemeExtension) {
        CompileThemeTask compileThemeTask = (CompileThemeTask)GradleUtil.getTask((Project)project, (String)COMPILE_THEME_TASK_NAME);
        this.configureTaskCompileThemeDiffsDir(compileThemeTask, liferayThemeExtension);
        this.configureTaskCompileThemeFrontendThemeFiles(compileThemeTask);
        this.configureTaskCompileThemeParent(compileThemeTask, liferayThemeExtension);
        this.configureTaskCompileThemeRootDir(compileThemeTask);
        this.configureTaskCompileThemeType(compileThemeTask, liferayThemeExtension);
        this.configureTaskCompileThemeDependsOn(compileThemeTask);
    }

    protected void configureTaskCompileThemeDependsOn(CompileThemeTask compileThemeTask) {
        compileThemeTask.dependsOn(new Object[]{BUILD_THUMBNAILS_TASK_NAME});
        Project themeParentProject = compileThemeTask.getThemeParentProject();
        if (themeParentProject != null) {
            String taskName = themeParentProject.getPath() + ":" + COMPILE_THEME_TASK_NAME;
            compileThemeTask.dependsOn(new Object[]{taskName});
        }
    }

    protected void configureTaskCompileThemeDiffsDir(CompileThemeTask compileThemeTask, LiferayThemeExtension liferayThemeExtension) {
        if (compileThemeTask.getDiffsDir() == null) {
            compileThemeTask.setDiffsDir(liferayThemeExtension.getDiffsDir());
        }
    }

    protected void configureTaskCompileThemeFrontendThemeFiles(CompileThemeTask compileThemeTask) {
        FileCollection fileCollection = compileThemeTask.getFrontendThemeFiles();
        if (fileCollection != null && !fileCollection.isEmpty()) {
            return;
        }
        Configuration configuration = GradleUtil.getConfiguration((Project)compileThemeTask.getProject(), (String)FRONTEND_THEMES_CONFIGURATION_NAME);
        compileThemeTask.setFrontendThemeFiles((FileCollection)configuration);
    }

    protected void configureTaskCompileThemeParent(CompileThemeTask compileThemeTask, LiferayThemeExtension liferayThemeExtension) {
        if (Validator.isNull((String)compileThemeTask.getThemeParent())) {
            compileThemeTask.setThemeParent(liferayThemeExtension.getThemeParent());
        }
    }

    protected void configureTaskCompileThemeRootDir(CompileThemeTask compileThemeTask) {
        if (compileThemeTask.getThemeRootDir() != null) {
            return;
        }
        WarPluginConvention warPluginConvention = (WarPluginConvention)GradleUtil.getConvention((Project)compileThemeTask.getProject(), WarPluginConvention.class);
        compileThemeTask.setThemeRootDir(warPluginConvention.getWebAppDir());
    }

    protected void configureTaskCompileThemeType(CompileThemeTask compileThemeTask, LiferayThemeExtension liferayThemeExtension) {
        Set<String> themeTypes = compileThemeTask.getThemeTypes();
        if (themeTypes.isEmpty()) {
            compileThemeTask.themeTypes(liferayThemeExtension.getThemeType());
        }
    }

    @Override
    protected void configureTasks(Project project, LiferayExtension liferayExtension) {
        super.configureTasks(project, liferayExtension);
        LiferayThemeExtension liferayThemeExtension = (LiferayThemeExtension)liferayExtension;
        this.configureTaskBuildThumbnails(project, liferayThemeExtension);
        this.configureTaskCompileTheme(project, liferayThemeExtension);
    }

    @Override
    protected void configureTaskWar(Project project, LiferayExtension liferayExtension) {
        super.configureTaskWar(project, liferayExtension);
        LiferayThemeExtension liferayThemeExtension = (LiferayThemeExtension)liferayExtension;
        War war = (War)GradleUtil.getTask((Project)project, (String)"war");
        this.configureTaskWarExclude(war, liferayThemeExtension);
    }

    protected void configureTaskWarExclude(War war, LiferayThemeExtension liferayThemeExtension) {
        Project project = war.getProject();
        File diffsDir = this.getDiffsDir(project, liferayThemeExtension);
        if (diffsDir != null) {
            String relativeDiffsDir = FileUtil.relativize((File)diffsDir, (File)this.getWebAppDir(project));
            war.exclude(new String[]{relativeDiffsDir + "/**"});
        }
    }

    protected File getDiffsDir(Project project, LiferayThemeExtension liferayThemeExtension) {
        CompileThemeTask compileThemeTask = (CompileThemeTask)GradleUtil.getTask((Project)project, (String)COMPILE_THEME_TASK_NAME);
        File diffsDir = compileThemeTask.getDiffsDir();
        if (diffsDir == null) {
            diffsDir = liferayThemeExtension.getDiffsDir();
        }
        return diffsDir;
    }

    protected boolean hasSources(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        SourceDirectorySet sourceDirectorySet = sourceSet.getAllSource();
        return !sourceDirectorySet.isEmpty();
    }
}

