/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.LiferayJavaPlugin;
import com.liferay.gradle.plugins.css.builder.BuildCSSTask;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.extensions.LiferayOSGiExtension;
import com.liferay.gradle.plugins.jasper.jspc.JspCExtension;
import com.liferay.gradle.plugins.node.tasks.PublishNodeModuleTask;
import com.liferay.gradle.plugins.service.builder.BuildServiceTask;
import com.liferay.gradle.plugins.tasks.DirectDeployTask;
import com.liferay.gradle.plugins.wsdd.builder.BuildWSDDTask;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import com.liferay.gradle.util.copy.ExcludeExistingFileAction;
import com.liferay.gradle.util.copy.RenameDependencyClosure;
import groovy.lang.Closure;
import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.dm.gradle.plugins.bundle.BundleExtension;
import org.dm.gradle.plugins.bundle.BundlePlugin;
import org.dm.gradle.plugins.bundle.BundleUtils;
import org.dm.gradle.plugins.bundle.JarBuilder;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.internal.Factory;

public class LiferayOSGiPlugin
extends LiferayJavaPlugin {
    public static final String AUTO_UPDATE_XML_TASK_NAME = "autoUpdateXml";
    public static final String COPY_LIBS_TASK_NAME = "copyLibs";
    public static final String UNZIP_JAR_TASK_NAME = "unzipJar";
    private static final Logger _logger = Logging.getLogger(LiferayOSGiPlugin.class);

    @Override
    public void apply(Project project) {
        super.apply(project);
        this.configureJspCExtension(project);
        this.configureArchivesBaseName(project);
        this.configureTaskBuildCSS(project);
        this.configureTasksBuildService(project);
        this.configureVersion(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                LiferayOSGiExtension liferayOSGiExtension = (LiferayOSGiExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayOSGiExtension.class);
                LiferayOSGiPlugin.this.configureBundleExtensionDefaults(project, liferayOSGiExtension);
                LiferayOSGiPlugin.this.configureTaskUnzipJar(project);
            }
        });
    }

    protected void addCleanDeployedFile(Project project, final Callable<String> callable) {
        Delete delete = (Delete)GradleUtil.getTask((Project)project, (String)"clean");
        if (!this.isCleanDeployed(delete)) {
            return;
        }
        final Copy copy = (Copy)GradleUtil.getTask((Project)project, (String)"deploy");
        Closure<File> closure = new Closure<File>(null){

            public File doCall() throws Exception {
                return new File(copy.getDestinationDir(), LiferayOSGiPlugin.this.getDeployedFileName(copy.getProject(), (String)callable.call()));
            }
        };
        delete.delete(new Object[]{closure});
    }

    @Override
    protected void addDependenciesJspC(Project project, LiferayExtension liferayExtension) {
        super.addDependenciesJspC(project, liferayExtension);
        FileTree fileTree = this.getJarsFileTree(project, liferayExtension.getAppServerLibGlobalDir());
        GradleUtil.addDependency((Project)project, (String)"jspC", (FileCollection)fileTree);
        fileTree = this.getJarsFileTree(project, new File(liferayExtension.getAppServerPortalDir(), "WEB-INF/lib"));
        GradleUtil.addDependency((Project)project, (String)"jspC", (FileCollection)fileTree);
        fileTree = this.getJarsFileTree(project, new File(liferayExtension.getLiferayHome(), "osgi/modules"));
        GradleUtil.addDependency((Project)project, (String)"jspC", (FileCollection)fileTree);
        ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{this.getUnzippedJarDir(project)});
        configurableFileCollection.builtBy(new Object[]{UNZIP_JAR_TASK_NAME});
        GradleUtil.addDependency((Project)project, (String)"jspC", (FileCollection)configurableFileCollection);
    }

    @Override
    protected LiferayExtension addLiferayExtension(Project project) {
        return (LiferayExtension)GradleUtil.addExtension((ExtensionAware)project, (String)"liferay", LiferayOSGiExtension.class);
    }

    protected DirectDeployTask addTaskAutoUpdateXml(final Project project) {
        DirectDeployTask directDeployTask = (DirectDeployTask)GradleUtil.addTask((Project)project, (String)AUTO_UPDATE_XML_TASK_NAME, DirectDeployTask.class);
        directDeployTask.setAppServerDeployDir(directDeployTask.getTemporaryDir());
        directDeployTask.setArgAppServerType("tomcat");
        directDeployTask.setWebAppType("portlet");
        directDeployTask.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                DirectDeployTask directDeployTask = (DirectDeployTask)task;
                Jar jar = (Jar)GradleUtil.getTask((Project)directDeployTask.getProject(), (String)"jar");
                File jarFile = jar.getArchivePath();
                jarFile.renameTo(directDeployTask.getWebAppFile());
            }
        });
        directDeployTask.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                DirectDeployTask directDeployTask = (DirectDeployTask)task;
                Project project = directDeployTask.getProject();
                File warFile = directDeployTask.getWebAppFile();
                Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
                String deployedPluginDirName = jar.getArchiveName();
                deployedPluginDirName = deployedPluginDirName.substring(0, deployedPluginDirName.lastIndexOf(46));
                File deployedPluginDir = new File(directDeployTask.getAppServerDeployDir(), deployedPluginDirName);
                if (!deployedPluginDir.exists()) {
                    deployedPluginDir = new File(directDeployTask.getAppServerDeployDir(), project.getName());
                }
                if (!deployedPluginDir.exists()) {
                    _logger.warn("Unable to automatically update web.xml in " + jar.getArchivePath());
                    return;
                }
                LiferayOSGiPlugin.this.touchFiles(project, deployedPluginDir, 0L, "WEB-INF/liferay-web.xml", "WEB-INF/web.xml", "WEB-INF/tld/*");
                deployedPluginDirName = project.relativePath((Object)deployedPluginDir);
                LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
                String[][] filesets = new String[][]{{project.relativePath((Object)liferayExtension.getAppServerPortalDir()), "WEB-INF/tld/c.tld"}, {deployedPluginDirName, "WEB-INF/liferay-web.xml,WEB-INF/web.xml"}, {deployedPluginDirName, "WEB-INF/tld/*"}};
                FileUtil.jar((Project)project, (File)warFile, (String)"preserve", (boolean)true, (String[][])filesets);
                warFile.renameTo(jar.getArchivePath());
            }
        });
        directDeployTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                Project project = task.getProject();
                LiferayOSGiExtension liferayOSGiExtension = (LiferayOSGiExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayOSGiExtension.class);
                return liferayOSGiExtension.isAutoUpdateXml() && FileUtil.exists((Project)project, (String)"docroot/WEB-INF/portlet.xml");
            }
        });
        TaskInputs taskInputs = directDeployTask.getInputs();
        taskInputs.file((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
                return jar.getArchivePath();
            }
        });
        Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
        jar.finalizedBy(new Object[]{directDeployTask});
        return directDeployTask;
    }

    protected Jar addTaskBuildWSDDJar(final BuildWSDDTask buildWSDDTask) {
        Project project = buildWSDDTask.getProject();
        final Jar jar = (Jar)GradleUtil.addTask((Project)project, (String)(buildWSDDTask.getName() + "Jar"), Jar.class);
        jar.dependsOn(new Object[]{buildWSDDTask});
        String taskName = buildWSDDTask.getName();
        if (taskName.equals("buildWSDD")) {
            jar.setAppendix("wsdd");
        } else {
            jar.setAppendix("wsdd-" + taskName);
        }
        jar.deleteAllActions();
        jar.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                BundleExtension bundleExtension = (BundleExtension)GradleUtil.getExtension((ExtensionAware)project, BundleExtension.class);
                Factory jarBuilderFactory = bundleExtension.getJarBuilderFactory();
                JarBuilder jarBuilder = (JarBuilder)jarBuilderFactory.create();
                jarBuilder.withBase((Object)BundleUtils.getBase((Project)project));
                LiferayOSGiExtension liferayOSGiExtension = (LiferayOSGiExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayOSGiExtension.class);
                Map<String, String> properties = liferayOSGiExtension.getBundleDefaultInstructions();
                String bundleName = LiferayOSGiPlugin.this.getBundleInstruction(project, "Bundle-Name");
                properties.put("Bundle-Name", bundleName + " WSDD descriptors");
                String bundleSymbolicName = LiferayOSGiPlugin.this.getBundleInstruction(project, "Bundle-SymbolicName");
                properties.put("Bundle-SymbolicName", bundleSymbolicName + ".wsdd");
                properties.put("Fragment-Host", bundleSymbolicName);
                properties.put("Import-Package", "javax.servlet,javax.servlet.http");
                StringBuilder sb = new StringBuilder();
                sb.append("WEB-INF/=");
                sb.append(LiferayOSGiPlugin.this._getRelativePath(project, buildWSDDTask.getServerConfigFile()));
                sb.append(',');
                sb.append(LiferayOSGiPlugin.this._getRelativePath(project, buildWSDDTask.getOutputDir()));
                sb.append(";filter:=*.wsdd");
                properties.put("Include-Resource", sb.toString());
                jarBuilder.withProperties(properties);
                jarBuilder.withSourcepath((Object)BundleUtils.getSources((Project)project));
                jarBuilder.withTrace((Object)bundleExtension.isTrace());
                jarBuilder.withVersion(BundleUtils.getVersion((Project)project));
                TaskOutputs taskOutputs = task.getOutputs();
                FileCollection fileCollection = taskOutputs.getFiles();
                jarBuilder.writeJarTo(fileCollection.getSingleFile());
            }
        });
        buildWSDDTask.finalizedBy(new Object[]{jar});
        this.addCleanDeployedFile(project, new Callable<String>(){

            @Override
            public String call() throws Exception {
                return jar.getArchiveName();
            }
        });
        Task task = GradleUtil.getTask((Project)project, (String)"deploy");
        if (task instanceof Copy) {
            Copy copy = (Copy)task;
            copy.from(new Object[]{new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return jar.getArchivePath();
                }
            }});
        }
        return jar;
    }

    protected Copy addTaskCopyLibs(Project project) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)COPY_LIBS_TASK_NAME, Copy.class);
        File libDir = this.getLibDir(project);
        copy.eachFile((Action)new ExcludeExistingFileAction(libDir));
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"runtime");
        copy.from(new Object[]{configuration});
        copy.into((Object)libDir);
        RenameDependencyClosure closure = new RenameDependencyClosure(project, new String[]{configuration.getName()});
        copy.rename((Closure)closure);
        return copy;
    }

    @Override
    protected void addTasks(Project project) {
        super.addTasks(project);
        this.addTaskAutoUpdateXml(project);
        this.addTaskCopyLibs(project);
        this.addTaskUnzipJar(project);
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildWSDDTask.class, (Action)new Action<BuildWSDDTask>(){

            public void execute(BuildWSDDTask buildWSDDTask) {
                LiferayOSGiPlugin.this.addTaskBuildWSDDJar(buildWSDDTask);
            }
        });
    }

    @Override
    protected Task addTaskSetupArquillian(Project project) {
        Task task = super.addTaskSetupArquillian(project);
        task.setEnabled(false);
        return task;
    }

    protected Copy addTaskUnzipJar(Project project) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)UNZIP_JAR_TASK_NAME, Copy.class);
        copy.dependsOn(new Object[]{"jar"});
        copy.into((Object)this.getUnzippedJarDir(project));
        return copy;
    }

    @Override
    protected void applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, BundlePlugin.class);
        this.configureBundleExtension(project);
        super.applyPlugins(project);
    }

    protected void configureArchivesBaseName(Project project) {
        BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
        String bundleSymbolicName = this.getBundleInstruction(project, "Bundle-SymbolicName");
        basePluginConvention.setArchivesBaseName(bundleSymbolicName);
    }

    protected void configureBundleExtension(Project project) {
        this.replaceJarBuilderFactory(project);
        Map<String, String> bundleInstructions = this.getBundleInstructions(project);
        Properties bundleProperties = null;
        try {
            bundleProperties = FileUtil.readProperties((Project)project, (String)"bnd.bnd");
        }
        catch (Exception e) {
            throw new GradleException("Unable to read bundle properties", (Throwable)e);
        }
        Enumeration<Object> keys = bundleProperties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = bundleProperties.getProperty(key);
            bundleInstructions.put(key, value);
        }
    }

    protected void configureBundleExtensionDefaults(Project project, LiferayOSGiExtension liferayOSGiExtension) {
        Map<String, String> bundleInstructions = this.getBundleInstructions(project);
        Map<String, String> bundleDefaultInstructions = liferayOSGiExtension.getBundleDefaultInstructions();
        for (Map.Entry<String, String> entry : bundleDefaultInstructions.entrySet()) {
            String key = entry.getKey();
            if (bundleInstructions.containsKey(key)) continue;
            bundleInstructions.put(key, entry.getValue());
        }
    }

    protected void configureJspCExtension(final Project project) {
        JspCExtension jspCExtension = (JspCExtension)GradleUtil.getExtension((ExtensionAware)project, JspCExtension.class);
        jspCExtension.setModuleWeb(true);
        jspCExtension.setPortalDir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
                return liferayExtension.getAppServerPortalDir();
            }
        });
        jspCExtension.setWebAppDir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                File unzippedJarDir = LiferayOSGiPlugin.this.getUnzippedJarDir(project);
                File resourcesDir = new File(unzippedJarDir, "META-INF/resources");
                if (resourcesDir.exists()) {
                    return resourcesDir;
                }
                return unzippedJarDir;
            }
        });
    }

    @Override
    protected void configureSourceSetMain(Project project) {
        File docrootDir = project.file((Object)"docroot");
        if (!docrootDir.exists()) {
            super.configureSourceSetMain(project);
            return;
        }
        File classesDir = new File(docrootDir, "WEB-INF/classes");
        File srcDir = new File(docrootDir, "WEB-INF/src");
        this.configureSourceSet(project, "main", classesDir, srcDir);
    }

    protected void configureTaskAutoUpdateXml(Project project) {
        DirectDeployTask directDeployTask = (DirectDeployTask)GradleUtil.getTask((Project)project, (String)AUTO_UPDATE_XML_TASK_NAME);
        this.configureTaskAutoUpdateXmlWebAppFile(directDeployTask);
    }

    protected void configureTaskAutoUpdateXmlWebAppFile(DirectDeployTask directDeployTask) {
        Jar jar = (Jar)GradleUtil.getTask((Project)directDeployTask.getProject(), (String)"jar");
        File warFile = FileUtil.replaceExtension((File)jar.getArchivePath(), (String)"war");
        directDeployTask.setWebAppFile(warFile);
    }

    protected void configureTaskBuildCSS(Project project) {
        Task task = GradleUtil.getTask((Project)project, (String)"buildCSS");
        if (task instanceof BuildCSSTask) {
            this.configureTaskBuildCSSDocrootDir((BuildCSSTask)task);
        }
    }

    protected void configureTaskBuildCSSDocrootDir(BuildCSSTask buildCSSTask) {
        Project project = buildCSSTask.getProject();
        File docrootDir = project.file((Object)"docroot");
        if (docrootDir.exists()) {
            buildCSSTask.setDocrootDir((Object)docrootDir);
        }
    }

    protected void configureTaskBuildServiceOsgiModule(BuildServiceTask buildServiceTask) {
        buildServiceTask.setOsgiModule(true);
    }

    @Override
    protected void configureTaskBuildXSD(Project project) {
        Zip zip = (Zip)GradleUtil.getTask((Project)project, (String)"buildXSD");
        this.configureTaskBuildXSDArchiveName(zip);
    }

    protected void configureTaskBuildXSDArchiveName(Zip zip) {
        String bundleSymbolicName = this.getBundleInstruction(zip.getProject(), "Bundle-SymbolicName");
        zip.setArchiveName(bundleSymbolicName + "-xbean." + "jar");
    }

    @Override
    protected void configureTaskClassesDependsOn(Task classesTask) {
        super.configureTaskClassesDependsOn(classesTask);
        classesTask.dependsOn(new Object[]{COPY_LIBS_TASK_NAME});
    }

    @Override
    protected void configureTaskDeploy(Project project, LiferayExtension liferayExtension) {
        super.configureTaskDeploy(project, liferayExtension);
        Task task = GradleUtil.getTask((Project)project, (String)"deploy");
        if (!(task instanceof Copy)) {
            return;
        }
        this.configureTaskDeployRename((Copy)task);
    }

    protected void configureTaskDeployRename(Copy copy) {
        final Project project = copy.getProject();
        Closure<String> closure = new Closure<String>(null){

            public String doCall(String fileName) {
                return LiferayOSGiPlugin.this.getDeployedFileName(project, fileName);
            }
        };
        copy.rename((Closure)closure);
    }

    @Override
    protected void configureTaskPublishNodeModule(PublishNodeModuleTask publishNodeModuleTask) {
        super.configureTaskPublishNodeModule(publishNodeModuleTask);
        this.configureTaskPublishNodeModuleDescription(publishNodeModuleTask);
        this.configureTaskPublishNodeModuleName(publishNodeModuleTask);
    }

    protected void configureTaskPublishNodeModuleDescription(PublishNodeModuleTask publishNodeModuleTask) {
        if (Validator.isNotNull((String)publishNodeModuleTask.getModuleDescription())) {
            return;
        }
        String bundleName = this.getBundleInstruction(publishNodeModuleTask.getProject(), "Bundle-Name");
        publishNodeModuleTask.setModuleDescription((Object)bundleName);
    }

    protected void configureTaskPublishNodeModuleName(PublishNodeModuleTask publishNodeModuleTask) {
        String bundleSymbolicName = this.getBundleInstruction(publishNodeModuleTask.getProject(), "Bundle-SymbolicName");
        int pos = bundleSymbolicName.indexOf(46);
        String moduleName = bundleSymbolicName.substring(pos + 1);
        moduleName = moduleName.replace('.', '-');
        publishNodeModuleTask.setModuleName((Object)moduleName);
    }

    @Override
    protected void configureTasks(Project project, LiferayExtension liferayExtension) {
        super.configureTasks(project, liferayExtension);
        this.configureTaskBuildXSD(project);
        this.configureTaskAutoUpdateXml(project);
    }

    protected void configureTasksBuildService(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildServiceTask.class, (Action)new Action<BuildServiceTask>(){

            public void execute(BuildServiceTask buildServiceTask) {
                LiferayOSGiPlugin.this.configureTaskBuildServiceOsgiModule(buildServiceTask);
            }
        });
    }

    protected void configureTaskUnzipJar(Project project) {
        Copy copy = (Copy)GradleUtil.getTask((Project)project, (String)UNZIP_JAR_TASK_NAME);
        Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
        copy.from(new Object[]{project.zipTree((Object)jar.getArchivePath())});
    }

    protected void configureVersion(Project project) {
        String bundleVersion = this.getBundleInstruction(project, "Bundle-Version");
        project.setVersion((Object)bundleVersion);
    }

    @Override
    protected void configureVersion(Project project, LiferayExtension liferayExtension) {
    }

    protected String getBundleInstruction(Project project, String key) {
        Map<String, String> bundleInstructions = this.getBundleInstructions(project);
        return bundleInstructions.get(key);
    }

    protected Map<String, String> getBundleInstructions(Project project) {
        BundleExtension bundleExtension = (BundleExtension)GradleUtil.getExtension((ExtensionAware)project, BundleExtension.class);
        return (Map)bundleExtension.getInstructions();
    }

    @Override
    protected String getDeployedFileName(Project project, File sourceFile) {
        return this.getDeployedFileName(project, sourceFile.getName());
    }

    protected String getDeployedFileName(Project project, String sourceFileName) {
        return sourceFileName.replace("-" + project.getVersion() + "." + "jar", ".jar");
    }

    protected FileTree getJarsFileTree(Project project, File dir) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", dir);
        args.put("include", "*.jar");
        return project.fileTree(args);
    }

    @Override
    protected File getLibDir(Project project) {
        File docrootDir = project.file((Object)"docroot");
        if (!docrootDir.exists()) {
            return super.getLibDir(project);
        }
        return new File(docrootDir, "WEB-INF/lib");
    }

    protected File getUnzippedJarDir(Project project) {
        return new File(project.getBuildDir(), "unzipped-jar");
    }

    protected void replaceJarBuilderFactory(Project project) {
        BundleExtension bundleExtension = (BundleExtension)GradleUtil.getExtension((ExtensionAware)project, BundleExtension.class);
        bundleExtension.setJarBuilderFactory((Factory)new LiferayJarBuilderFactory(project));
    }

    protected void touchFile(File file, long time) {
        boolean success = file.setLastModified(time);
        if (!success) {
            _logger.error("Unable to touch " + file);
        }
    }

    protected void touchFiles(Project project, File dir, long time, String ... includes) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", dir);
        args.put("includes", Arrays.asList(includes));
        ConfigurableFileTree fileTree = project.fileTree(args);
        for (File file : fileTree) {
            this.touchFile(file, time);
        }
    }

    private String _getRelativePath(Project project, File file) {
        String relativePath = project.relativePath((Object)file);
        return relativePath.replace('\\', '/');
    }

    private static class LiferayJarBuilderFactory
    implements Factory<JarBuilder> {
        private final Project _project;

        public LiferayJarBuilderFactory(Project project) {
            this._project = project;
        }

        public JarBuilder create() {
            LiferayJarBuilder liferayJarBuilder = new LiferayJarBuilder();
            SourceSet sourceSet = GradleUtil.getSourceSet((Project)this._project, (String)"main");
            SourceSetOutput sourceSetOutput = sourceSet.getOutput();
            liferayJarBuilder.addClasspath(sourceSetOutput.getClassesDir());
            return liferayJarBuilder;
        }
    }

    private static class LiferayJarBuilder
    extends JarBuilder {
        private LiferayJarBuilder() {
        }

        public void addClasspath(File file) {
            try {
                this.builder.addClasspath(file);
            }
            catch (Exception e) {
                throw new GradleException(e.getMessage(), (Throwable)e);
            }
        }

        public JarBuilder withClasspath(Object files) {
            return this;
        }

        public JarBuilder withResources(Object files) {
            return this;
        }
    }
}

