/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.css.builder.BuildCSSTask;
import com.liferay.gradle.plugins.css.builder.CSSBuilderPlugin;
import com.liferay.gradle.plugins.extensions.AppServer;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.extensions.TomcatAppServer;
import com.liferay.gradle.plugins.jasper.jspc.JspCPlugin;
import com.liferay.gradle.plugins.javadoc.formatter.JavadocFormatterPlugin;
import com.liferay.gradle.plugins.js.module.config.generator.ConfigJSModulesTask;
import com.liferay.gradle.plugins.js.module.config.generator.JSModuleConfigGeneratorPlugin;
import com.liferay.gradle.plugins.js.transpiler.JSTranspilerPlugin;
import com.liferay.gradle.plugins.js.transpiler.TranspileJSTask;
import com.liferay.gradle.plugins.lang.builder.BuildLangTask;
import com.liferay.gradle.plugins.lang.builder.LangBuilderPlugin;
import com.liferay.gradle.plugins.node.tasks.PublishNodeModuleTask;
import com.liferay.gradle.plugins.patcher.PatchTask;
import com.liferay.gradle.plugins.source.formatter.SourceFormatterPlugin;
import com.liferay.gradle.plugins.soy.SoyPlugin;
import com.liferay.gradle.plugins.tasks.AppServerTask;
import com.liferay.gradle.plugins.tasks.DirectDeployTask;
import com.liferay.gradle.plugins.tasks.InitGradleTask;
import com.liferay.gradle.plugins.tasks.SetupTestableTomcatTask;
import com.liferay.gradle.plugins.tasks.StartAppServerTask;
import com.liferay.gradle.plugins.tasks.StopAppServerTask;
import com.liferay.gradle.plugins.tld.formatter.TLDFormatterPlugin;
import com.liferay.gradle.plugins.upgrade.table.builder.BuildUpgradeTableTask;
import com.liferay.gradle.plugins.whip.WhipPlugin;
import com.liferay.gradle.plugins.whip.WhipTaskExtension;
import com.liferay.gradle.plugins.wsdl.builder.BuildWSDLTask;
import com.liferay.gradle.plugins.xml.formatter.FormatXMLTask;
import com.liferay.gradle.plugins.xml.formatter.XMLFormatterPlugin;
import com.liferay.gradle.plugins.xsd.builder.BuildXSDTask;
import com.liferay.gradle.plugins.xsd.builder.XSDBuilderPlugin;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;
import nebula.plugin.extraconfigurations.OptionalBasePlugin;
import nebula.plugin.extraconfigurations.ProvidedBasePlugin;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.artifacts.maven.Conf2ScopeMappingContainer;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.MavenPlugin;
import org.gradle.api.plugins.MavenPluginConvention;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;

public class LiferayJavaPlugin
implements Plugin<Project> {
    public static final String AUTO_CLEAN_PROPERTY_NAME = "autoClean";
    public static final String CLEAN_DEPLOYED_PROPERTY_NAME = "cleanDeployed";
    public static final String DELETE_LIFERAY_HOME_PROPERTY_NAME = "deleteLiferayHome";
    public static final String DEPLOY_TASK_NAME = "deploy";
    public static final String FORMAT_WSDL_TASK_NAME = "formatWSDL";
    public static final String FORMAT_XSD_TASK_NAME = "formatXSD";
    public static final String INIT_GRADLE_TASK_NAME = "initGradle";
    public static final String JAR_SOURCES_TASK_NAME = "jarSources";
    public static final String SETUP_ARQUILLIAN_TASK_NAME = "setupArquillian";
    public static final String SETUP_TESTABLE_TOMCAT_TASK_NAME = "setupTestableTomcat";
    public static final String START_TESTABLE_TOMCAT_TASK_NAME = "startTestableTomcat";
    public static final String STOP_TESTABLE_TOMCAT_TASK_NAME = "stopTestableTomcat";
    public static final String TEST_INTEGRATION_SOURCE_SET_NAME = "testIntegration";
    public static final String TEST_INTEGRATION_TASK_NAME = "testIntegration";
    public static final String ZIP_JAVADOC_TASK_NAME = "zipJavadoc";
    protected static final String[] DEFAULT_DEPENDENCY_NOTATIONS = new String[]{"biz.aQute.bnd:biz.aQute.bnd:2.4.1", "com.liferay.portal:portal-service:default", "com.liferay.portal:util-bridges:default", "com.liferay.portal:util-java:default", "com.liferay.portal:util-taglib:default", "commons-logging:commons-logging:1.1.3", "javax.activation:activation:1.1", "javax.annotation:jsr250-api:1.0", "javax.mail:mail:1.4", "javax.servlet.jsp:jsp-api:2.1", "javax.servlet:javax.servlet-api:3.0.1", "log4j:log4j:1.2.17"};
    private static final String _ADD_DEFAULT_DEPENDENCIES_PROPERTY_NAME = "com.liferay.adddefaultdependencies";
    private static final String _ADD_TEST_DEFAULT_DEPENDENCIES_PROPERTY_NAME = "com.liferay.addtestdefaultdependencies";
    private static final String[] _DEFAULT_EXT_DEPENDENCY_NOTATIONS = new String[]{"hsqldb:hsqldb:1.8.0.7", "javax.ccpp:ccpp:1.0", "javax.jms:jms:1.1", "javax.portlet:portlet-api:2.0", "mysql:mysql-connector-java:5.1.23", "net.sourceforge.jtds:jtds:1.2.6", "org.eclipse.persistence:javax.persistence:2.0.0", "postgresql:postgresql:9.2-1002.jdbc4"};
    private static final String[] _DEFAULT_TEST_DEPENDENCY_NOTATIONS = new String[]{"junit:junit:4.12", "org.mockito:mockito-all:1.9.5", "org.powermock:powermock-api-mockito:1.6.1", "org.powermock:powermock-api-support:1.6.1", "org.powermock:powermock-core:1.6.1", "org.powermock:powermock-module-junit4:1.6.1", "org.powermock:powermock-module-junit4-common:1.6.1", "org.powermock:powermock-reflect:1.6.1", "org.springframework:spring-test:3.2.10.RELEASE"};
    private static final String _SKIP_MANAGED_APP_SERVER_FILE_NAME = "skip.managed.app.server";
    private static final Logger _logger = Logging.getLogger(LiferayJavaPlugin.class);
    private static final Set<File> _startedAppServerBinDirs = new HashSet<File>();
    private static final ReentrantLock _startedAppServersReentrantLock = new ReentrantLock();
    private static final Map<File, Integer> _startedAppServerStopCounters = new HashMap<File, Integer>();

    public void apply(Project project) {
        this.addLiferayExtension(project);
        this.configureTasksBuildCSS(project);
        this.applyPlugins(project);
        this.configureConf2ScopeMappings(project);
        this.configureConfigurations(project);
        this.configureDependencies(project);
        this.configureProperties(project);
        this.configureSourceSets(project);
        this.addConfigurations(project);
        this.addTasks(project);
        this.applyConfigScripts(project);
        this.configureArtifacts(project);
        this.configureTaskBuildXSD(project);
        this.configureTaskConfigJSModules(project);
        this.configureTaskTranspileJS(project);
        this.configureTasksBuildUpgradeTable(project);
        this.configureTasksTest(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
                LiferayJavaPlugin.this.addDependenciesJspC(project, liferayExtension);
                LiferayJavaPlugin.this.configureVersion(project, liferayExtension);
                LiferayJavaPlugin.this.configureTasks(project, liferayExtension);
            }
        });
    }

    protected void addCleanDeployedFile(Project project, File sourceFile) {
        Delete delete = (Delete)GradleUtil.getTask((Project)project, (String)"clean");
        if (!this.isCleanDeployed(delete)) {
            return;
        }
        Copy copy = (Copy)GradleUtil.getTask((Project)project, (String)DEPLOY_TASK_NAME);
        File deployedFile = new File(copy.getDestinationDir(), this.getDeployedFileName(project, sourceFile));
        delete.delete(new Object[]{deployedFile});
    }

    protected void addConfigurations(Project project) {
    }

    protected void addDependenciesJspC(Project project, LiferayExtension liferayExtension) {
        GradleUtil.addDependency((Project)project, (String)"jspC", (File)liferayExtension.getAppServerLibGlobalDir());
    }

    protected LiferayExtension addLiferayExtension(Project project) {
        return (LiferayExtension)GradleUtil.addExtension((ExtensionAware)project, (String)"liferay", LiferayExtension.class);
    }

    protected SourceSet addSourceSetTestIntegration(Project project) {
        SourceSet testIntegrationSourceSet = GradleUtil.addSourceSet((Project)project, (String)"testIntegration");
        Configuration testIntegrationCompileConfiguration = GradleUtil.getConfiguration((Project)project, (String)testIntegrationSourceSet.getCompileConfigurationName());
        Configuration testCompileConfiguration = GradleUtil.getConfiguration((Project)project, (String)"testCompile");
        testIntegrationCompileConfiguration.extendsFrom(new Configuration[]{testCompileConfiguration});
        Configuration testIntegrationRuntimeConfiguration = GradleUtil.getConfiguration((Project)project, (String)testIntegrationSourceSet.getRuntimeConfigurationName());
        Configuration testRuntimeConfiguration = GradleUtil.getConfiguration((Project)project, (String)"testRuntime");
        testIntegrationRuntimeConfiguration.extendsFrom(new Configuration[]{testRuntimeConfiguration, testIntegrationCompileConfiguration});
        SourceSet mainSourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        FileCollection compileClasspath = testIntegrationSourceSet.getCompileClasspath();
        testIntegrationSourceSet.setCompileClasspath(compileClasspath.plus((FileCollection)mainSourceSet.getOutput()));
        FileCollection runtimeClasspath = testIntegrationSourceSet.getRuntimeClasspath();
        testIntegrationSourceSet.setRuntimeClasspath(runtimeClasspath.plus((FileCollection)mainSourceSet.getOutput()));
        return testIntegrationSourceSet;
    }

    protected Copy addTaskDeploy(Project project) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)DEPLOY_TASK_NAME, Copy.class);
        copy.setDescription("Assembles the project and deploys it to Liferay.");
        Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
        copy.from(new Object[]{jar});
        GradleUtil.setProperty((ExtensionAware)copy, (String)AUTO_CLEAN_PROPERTY_NAME, (Object)false);
        return copy;
    }

    protected FormatXMLTask addTaskFormatWSDL(final BuildWSDLTask buildWSDLTask) {
        Project project = buildWSDLTask.getProject();
        TaskContainer taskContainer = project.getTasks();
        FormatXMLTask formatXMLTask = (FormatXMLTask)taskContainer.maybeCreate(FORMAT_WSDL_TASK_NAME, FormatXMLTask.class);
        formatXMLTask.setDescription("Runs Liferay XML Formatter to format WSDL files.");
        formatXMLTask.setIncludes(Collections.singleton("**/*.wsdl"));
        formatXMLTask.source(new Object[]{new Callable<File>(){

            @Override
            public File call() throws Exception {
                return buildWSDLTask.getInputDir();
            }
        }});
        return formatXMLTask;
    }

    protected FormatXMLTask addTaskFormatXSD(Project project) {
        FormatXMLTask formatXMLTask = (FormatXMLTask)GradleUtil.addTask((Project)project, (String)FORMAT_XSD_TASK_NAME, FormatXMLTask.class);
        formatXMLTask.setDescription("Runs Liferay XML Formatter to format XSD files.");
        return formatXMLTask;
    }

    protected InitGradleTask addTaskInitGradle(Project project) {
        InitGradleTask initGradleTask = (InitGradleTask)GradleUtil.addTask((Project)project, (String)INIT_GRADLE_TASK_NAME, InitGradleTask.class);
        initGradleTask.setDescription("Initializes build.gradle by migrating information from legacy files.");
        initGradleTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                block5: {
                    try {
                        Project project = task.getProject();
                        File buildGradleFile = project.file((Object)"build.gradle");
                        if (!buildGradleFile.exists() || buildGradleFile.length() == 0L) {
                            return true;
                        }
                        long buildGradleLastModified = this._getLastModified(buildGradleFile);
                        for (String sourceFileName : InitGradleTask.SOURCE_FILE_NAMES) {
                            File sourceFile = project.file((Object)sourceFileName);
                            if (!sourceFile.exists() || buildGradleLastModified >= this._getLastModified(sourceFile)) continue;
                            return true;
                        }
                        return false;
                    }
                    catch (IOException ioe) {
                    }
                    catch (Exception e) {
                        if (!_logger.isWarnEnabled()) break block5;
                        _logger.warn(e.getMessage(), (Throwable)e);
                    }
                }
                return true;
            }

            private long _getLastModified(File file) throws Exception {
                ProcessExecutor processExecutor = new ProcessExecutor(new String[]{"git", "log", "--format=%at", "--max-count=1", file.getName()});
                processExecutor.directory(file.getParentFile());
                processExecutor.exitValueNormal();
                processExecutor.readOutput(true);
                ProcessResult processResult = processExecutor.executeNoTimeout();
                String output = processResult.outputUTF8();
                return Long.parseLong(output.trim());
            }
        });
        return initGradleTask;
    }

    protected Jar addTaskJarSources(Project project) {
        final Jar jar = (Jar)GradleUtil.addTask((Project)project, (String)JAR_SOURCES_TASK_NAME, Jar.class);
        jar.setClassifier("sources");
        jar.setGroup("build");
        jar.setDescription("Assembles a jar archive containing the main source files.");
        jar.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        File docrootDir = project.file((Object)"docroot");
        if (docrootDir.exists()) {
            jar.from(new Object[]{docrootDir});
        } else {
            SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
            jar.from(new Object[]{sourceSet.getAllSource()});
        }
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PatchTask.class, (Action)new Action<PatchTask>(){

            public void execute(final PatchTask patchTask) {
                jar.from((Object)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return patchTask.getPatchesDir();
                    }
                }, (Closure)new Closure<Void>(null){

                    public void doCall(CopySpec copySpec) {
                        copySpec.into((Object)"META-INF/patches");
                    }
                });
            }
        });
        return jar;
    }

    protected void addTasks(Project project) {
        this.addTaskDeploy(project);
        this.addTaskFormatXSD(project);
        this.addTaskInitGradle(project);
        this.addTaskJarSources(project);
        this.addTaskSetupArquillian(project);
        this.addTaskSetupTestableTomcat(project);
        this.addTaskStartTestableTomcat(project);
        this.addTaskStopTestableTomcat(project);
        this.addTaskTestIntegration(project);
        this.addTaskZipJavadoc(project);
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildWSDLTask.class, (Action)new Action<BuildWSDLTask>(){

            public void execute(BuildWSDLTask buildWSDLTask) {
                LiferayJavaPlugin.this.addTaskFormatWSDL(buildWSDLTask);
            }
        });
    }

    protected Task addTaskSetupArquillian(Project project) {
        Task task = project.task(SETUP_ARQUILLIAN_TASK_NAME);
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                try {
                    String xml = FileUtil.read((String)"com/liferay/gradle/plugins/dependencies/arquillian.xml");
                    LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
                    TomcatAppServer tomcatAppServer = (TomcatAppServer)liferayExtension.getAppServer("tomcat");
                    xml = xml.replace("${app.server.tomcat.manager.password}", tomcatAppServer.getManagerPassword());
                    xml = xml.replace("${app.server.tomcat.manager.user}", tomcatAppServer.getManagerUserName());
                    xml = xml.replace("${jmx.remote.port}", String.valueOf(liferayExtension.getJmxRemotePort()));
                    SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"testIntegration");
                    File testIntegrationDir = LiferayJavaPlugin.this.getSrcDir(sourceSet.getResources());
                    File arquillianXmlFile = new File(testIntegrationDir, "arquillian.xml");
                    Files.write(arquillianXmlFile.toPath(), xml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (Exception e) {
                    throw new GradleException(e.getMessage(), (Throwable)e);
                }
            }
        });
        task.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                SourceSet sourceSet = GradleUtil.getSourceSet((Project)task.getProject(), (String)"testIntegration");
                File testIntegrationDir = LiferayJavaPlugin.this.getSrcDir(sourceSet.getResources());
                File arquillianXmlFile = new File(testIntegrationDir, "arquillian.xml");
                if (arquillianXmlFile.exists()) {
                    return false;
                }
                SourceDirectorySet sourceDirectorySet = sourceSet.getAllJava();
                return !sourceDirectorySet.isEmpty();
            }
        });
        return task;
    }

    protected SetupTestableTomcatTask addTaskSetupTestableTomcat(Project project) {
        final SetupTestableTomcatTask setupTestableTomcatTask = (SetupTestableTomcatTask)GradleUtil.addTask((Project)project, (String)SETUP_TESTABLE_TOMCAT_TASK_NAME, SetupTestableTomcatTask.class);
        setupTestableTomcatTask.onlyIf((Spec)new Spec<Task>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isSatisfiedBy(Task task) {
                _startedAppServersReentrantLock.lock();
                try {
                    if (_startedAppServerBinDirs.contains(setupTestableTomcatTask.getTomcatBinDir())) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    _startedAppServersReentrantLock.unlock();
                }
            }
        });
        return setupTestableTomcatTask;
    }

    protected StartAppServerTask addTaskStartTestableTomcat(Project project) {
        StartAppServerTask startTestableTomcatTask = (StartAppServerTask)GradleUtil.addTask((Project)project, (String)START_TESTABLE_TOMCAT_TASK_NAME, StartAppServerTask.class);
        startTestableTomcatTask.dependsOn(new Object[]{SETUP_TESTABLE_TOMCAT_TASK_NAME});
        startTestableTomcatTask.finalizedBy(new Object[]{STOP_TESTABLE_TOMCAT_TASK_NAME});
        startTestableTomcatTask.setAppServerType("tomcat");
        startTestableTomcatTask.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                boolean deleteLiferayHome = GradleUtil.getProperty((ExtensionAware)task, (String)LiferayJavaPlugin.DELETE_LIFERAY_HOME_PROPERTY_NAME, (boolean)true);
                if (!deleteLiferayHome) {
                    return;
                }
                Project project = task.getProject();
                LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
                File liferayHome = liferayExtension.getLiferayHome();
                project.delete(new Object[]{new File(liferayHome, "data"), new File(liferayHome, "logs"), new File(liferayHome, "osgi/state"), new File(liferayHome, "portal-setup-wizard.properties")});
            }
        });
        Action<Task> action = new Action<Task>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Task task) {
                StartAppServerTask startAppServerTask = (StartAppServerTask)task;
                File appServerBinDir = startAppServerTask.getAppServerBinDir();
                boolean started = false;
                _startedAppServersReentrantLock.lock();
                try {
                    if (_startedAppServerBinDirs.contains(appServerBinDir)) {
                        started = true;
                    } else {
                        _startedAppServerBinDirs.add(appServerBinDir);
                    }
                }
                finally {
                    _startedAppServersReentrantLock.unlock();
                }
                if (started) {
                    Project project;
                    Gradle gradle;
                    StartParameter startParameter;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Application server " + appServerBinDir + " is already started");
                    }
                    if ((startParameter = (gradle = (project = startAppServerTask.getProject()).getGradle()).getStartParameter()).isParallelProjectExecutionEnabled()) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Waiting for application server " + appServerBinDir + " to be reachable");
                        }
                        startAppServerTask.waitForAppServer();
                    }
                    throw new StopExecutionException();
                }
            }
        };
        startTestableTomcatTask.doFirst((Action)action);
        startTestableTomcatTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                StartAppServerTask startAppServerTask = (StartAppServerTask)task;
                return !startAppServerTask.isAppServerReachable();
            }
        });
        return startTestableTomcatTask;
    }

    protected StopAppServerTask addTaskStopTestableTomcat(Project project) {
        final StopAppServerTask stopTestableTomcatTask = (StopAppServerTask)GradleUtil.addTask((Project)project, (String)STOP_TESTABLE_TOMCAT_TASK_NAME, StopAppServerTask.class);
        stopTestableTomcatTask.setAppServerType("tomcat");
        Action<Task> action = new Action<Task>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Task task) {
                StopAppServerTask stopAppServerTask = (StopAppServerTask)task;
                File appServerBinDir = stopAppServerTask.getAppServerBinDir();
                _startedAppServersReentrantLock.lock();
                try {
                    if (!_startedAppServerBinDirs.contains(appServerBinDir)) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Application server " + appServerBinDir + " is already stopped");
                        }
                        throw new StopExecutionException();
                    }
                    int originalCounter = LiferayJavaPlugin.this._updateStartedAppServerStopCounters(appServerBinDir, false);
                    if (originalCounter > 1) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Application server " + appServerBinDir + " cannot be stopped now, still " + (originalCounter - 1) + " to execute");
                        }
                        throw new StopExecutionException();
                    }
                }
                finally {
                    _startedAppServersReentrantLock.unlock();
                }
            }
        };
        stopTestableTomcatTask.doFirst((Action)action);
        Gradle gradle = project.getGradle();
        TaskExecutionGraph taskExecutionGraph = gradle.getTaskGraph();
        Closure<Void> closure = new Closure<Void>(null){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doCall(TaskExecutionGraph taskExecutionGraph) {
                if (taskExecutionGraph.hasTask((Task)stopTestableTomcatTask)) {
                    _startedAppServersReentrantLock.lock();
                    try {
                        LiferayJavaPlugin.this._updateStartedAppServerStopCounters(stopTestableTomcatTask.getAppServerBinDir(), true);
                    }
                    finally {
                        _startedAppServersReentrantLock.unlock();
                    }
                }
            }
        };
        taskExecutionGraph.whenReady((Closure)closure);
        return stopTestableTomcatTask;
    }

    protected Test addTaskTestIntegration(Project project) {
        Test test = (Test)GradleUtil.addTask((Project)project, (String)"testIntegration", Test.class);
        test.dependsOn(new Object[]{SETUP_ARQUILLIAN_TASK_NAME});
        test.mustRunAfter(new Object[]{"test"});
        test.setDescription("Runs the integration tests.");
        test.setGroup("verification");
        ConventionMapping conventionMapping = test.getConventionMapping();
        final SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"testIntegration");
        conventionMapping.map("classpath", (Callable)new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                return sourceSet.getRuntimeClasspath();
            }
        });
        conventionMapping.map("testClassesDir", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                SourceSetOutput sourceSetOutput = sourceSet.getOutput();
                return sourceSetOutput.getClassesDir();
            }
        });
        conventionMapping.map("testSrcDirs", (Callable)new Callable<List<File>>(){

            @Override
            public List<File> call() throws Exception {
                SourceDirectorySet sourceDirectorySet = sourceSet.getJava();
                return new ArrayList<File>(sourceDirectorySet.getSrcDirs());
            }
        });
        Task checkTask = GradleUtil.getTask((Project)project, (String)"check");
        checkTask.dependsOn(new Object[]{test});
        return test;
    }

    protected Zip addTaskZipJavadoc(Project project) {
        Zip zip = (Zip)GradleUtil.addTask((Project)project, (String)ZIP_JAVADOC_TASK_NAME, Zip.class);
        zip.setClassifier("javadoc");
        zip.setDescription("Assembles a zip archive containing the Javadoc files for this project.");
        zip.setGroup("build");
        Javadoc javadoc = (Javadoc)GradleUtil.getTask((Project)project, (String)"javadoc");
        zip.dependsOn(new Object[]{javadoc});
        zip.from(new Object[]{javadoc.getDestinationDir()});
        return zip;
    }

    protected void applyConfigScripts(Project project) {
        GradleUtil.applyScript((Project)project, (String)"com/liferay/gradle/plugins/dependencies/config-liferay.gradle", (Object)project);
        GradleUtil.applyScript((Project)project, (String)"com/liferay/gradle/plugins/dependencies/config-maven.gradle", (Object)project);
    }

    protected void applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        GradleUtil.applyPlugin((Project)project, MavenPlugin.class);
        GradleUtil.applyPlugin((Project)project, OptionalBasePlugin.class);
        GradleUtil.applyPlugin((Project)project, ProvidedBasePlugin.class);
        GradleUtil.applyPlugin((Project)project, CSSBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, JavadocFormatterPlugin.class);
        GradleUtil.applyPlugin((Project)project, JSModuleConfigGeneratorPlugin.class);
        GradleUtil.applyPlugin((Project)project, JspCPlugin.class);
        GradleUtil.applyPlugin((Project)project, JSTranspilerPlugin.class);
        GradleUtil.applyPlugin((Project)project, LangBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, SourceFormatterPlugin.class);
        GradleUtil.applyPlugin((Project)project, SoyPlugin.class);
        GradleUtil.applyPlugin((Project)project, TLDFormatterPlugin.class);
        GradleUtil.applyPlugin((Project)project, WhipPlugin.class);
        GradleUtil.applyPlugin((Project)project, XMLFormatterPlugin.class);
        GradleUtil.applyPlugin((Project)project, XSDBuilderPlugin.class);
    }

    protected void configureArtifacts(Project project) {
        ArtifactHandler artifactHandler = project.getArtifacts();
        Task jarSourcesTask = GradleUtil.getTask((Project)project, (String)JAR_SOURCES_TASK_NAME);
        artifactHandler.add("archives", (Object)jarSourcesTask);
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", project.getProjectDir());
        args.put("include", "**/*.java");
        ConfigurableFileTree javaFileTree = project.fileTree(args);
        if (!javaFileTree.isEmpty()) {
            Task zipJavadocTask = GradleUtil.getTask((Project)project, (String)ZIP_JAVADOC_TASK_NAME);
            artifactHandler.add("archives", (Object)zipJavadocTask);
        }
    }

    protected void configureConf2ScopeMappings(Project project) {
        MavenPluginConvention mavenPluginConvention = (MavenPluginConvention)GradleUtil.getConvention((Project)project, MavenPluginConvention.class);
        Conf2ScopeMappingContainer conf2ScopeMappingContainer = mavenPluginConvention.getConf2ScopeMappings();
        Map mappings = conf2ScopeMappingContainer.getMappings();
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"testCompile");
        mappings.remove(configuration);
        configuration = GradleUtil.getConfiguration((Project)project, (String)"testRuntime");
        mappings.remove(configuration);
    }

    protected void configureConfigurations(final Project project) {
        Action<Configuration> action = new Action<Configuration>(){

            public void execute(Configuration configuration) {
                ResolutionStrategy resolutionStrategy = configuration.getResolutionStrategy();
                resolutionStrategy.eachDependency((Action)new Action<DependencyResolveDetails>(){

                    public void execute(DependencyResolveDetails dependencyResolveDetails) {
                        ModuleVersionSelector moduleVersionSelector = dependencyResolveDetails.getRequested();
                        String group = moduleVersionSelector.getGroup();
                        String version = moduleVersionSelector.getVersion();
                        if (group.equals("com.liferay.portal") && version.equals("default")) {
                            LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
                            dependencyResolveDetails.useVersion(liferayExtension.getPortalVersion());
                        }
                    }
                });
            }
        };
        ConfigurationContainer configurationContainer = project.getConfigurations();
        configurationContainer.all((Action)action);
    }

    protected void configureDependencies(Project project) {
        this.configureDependenciesProvided(project);
        this.configureDependenciesTestCompile(project);
    }

    protected void configureDependenciesProvided(Project project) {
        if (!this.isAddDefaultDependencies(project)) {
            return;
        }
        for (String dependencyNotation : DEFAULT_DEPENDENCY_NOTATIONS) {
            GradleUtil.addDependency((Project)project, (String)ProvidedBasePlugin.getPROVIDED_CONFIGURATION_NAME(), (String)dependencyNotation);
        }
        for (String dependencyNotation : _DEFAULT_EXT_DEPENDENCY_NOTATIONS) {
            GradleUtil.addDependency((Project)project, (String)ProvidedBasePlugin.getPROVIDED_CONFIGURATION_NAME(), (String)dependencyNotation);
        }
    }

    protected void configureDependenciesTestCompile(Project project) {
        if (!this.isAddTestDefaultDependencies(project)) {
            return;
        }
        for (String dependencyNotation : _DEFAULT_TEST_DEPENDENCY_NOTATIONS) {
            GradleUtil.addDependency((Project)project, (String)"testCompile", (String)dependencyNotation);
        }
    }

    protected void configureProperties(Project project) {
        this.configureTestResultsDir(project);
    }

    protected void configureSourceSet(Project project, String name, File classesDir, File srcDir) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)name);
        if (classesDir != null) {
            SourceSetOutput sourceSetOutput = sourceSet.getOutput();
            sourceSetOutput.setClassesDir((Object)classesDir);
            sourceSetOutput.setResourcesDir((Object)classesDir);
        }
        if (srcDir != null) {
            SourceDirectorySet javaSourceDirectorySet = sourceSet.getJava();
            Set<File> srcDirs = Collections.singleton(srcDir);
            javaSourceDirectorySet.setSrcDirs(srcDirs);
            SourceDirectorySet resourcesSourceDirectorySet = sourceSet.getResources();
            resourcesSourceDirectorySet.setSrcDirs(srcDirs);
        }
    }

    protected void configureSourceSetMain(Project project) {
        File classesDir = project.file((Object)"classes");
        this.configureSourceSet(project, "main", classesDir, null);
    }

    protected void configureSourceSets(Project project) {
        this.addSourceSetTestIntegration(project);
        this.configureSourceSetMain(project);
        this.configureSourceSetTest(project);
        this.configureSourceSetTestIntegration(project);
    }

    protected void configureSourceSetTest(Project project) {
        File classesDir = project.file((Object)"test-classes/unit");
        this.configureSourceSet(project, "test", classesDir, null);
    }

    protected void configureSourceSetTestIntegration(Project project) {
        File classesDir = project.file((Object)"test-classes/integration");
        this.configureSourceSet(project, "testIntegration", classesDir, null);
    }

    protected void configureTaskBuildCSSGenerateSourceMap(BuildCSSTask buildCSSTask) {
        String generateSourceMap = GradleUtil.getProperty((ExtensionAware)buildCSSTask.getProject(), (String)"sass.generate.source.map", (String)null);
        if (Validator.isNotNull((String)generateSourceMap)) {
            buildCSSTask.setGenerateSourceMap(Boolean.parseBoolean(generateSourceMap));
        }
    }

    protected void configureTaskBuildCSSSassCompilerClassName(BuildCSSTask buildCSSTask) {
        String sassCompilerClassName = GradleUtil.getProperty((ExtensionAware)buildCSSTask.getProject(), (String)"sass.compiler.class.name", (String)null);
        buildCSSTask.setSassCompilerClassName((Object)sassCompilerClassName);
    }

    protected void configureTaskBuildLang(Project project) {
        BuildLangTask buildLangTask = (BuildLangTask)GradleUtil.getTask((Project)project, (String)"buildLang");
        this.configureTaskBuildLangLangDirName(buildLangTask);
        this.configureTaskBuildLangTranslateClientId(buildLangTask);
        this.configureTaskBuildLangTranslateClientSecret(buildLangTask);
    }

    protected void configureTaskBuildLangLangDirName(BuildLangTask buildLangTask) {
        Project project = buildLangTask.getProject();
        File langDir = new File(this.getResourcesDir(project), "content");
        buildLangTask.setLangDirName(project.relativePath((Object)langDir));
    }

    protected void configureTaskBuildLangTranslateClientId(BuildLangTask buildLangTask) {
        if (Validator.isNotNull((String)buildLangTask.getTranslateClientId())) {
            return;
        }
        String translateClientId = GradleUtil.getProperty((ExtensionAware)buildLangTask.getProject(), (String)"microsoft.translator.client.id", (String)null);
        buildLangTask.setTranslateClientId(translateClientId);
    }

    protected void configureTaskBuildLangTranslateClientSecret(BuildLangTask buildLangTask) {
        if (Validator.isNotNull((String)buildLangTask.getTranslateClientSecret())) {
            return;
        }
        String translateClientSecret = GradleUtil.getProperty((ExtensionAware)buildLangTask.getProject(), (String)"microsoft.translator.client.secret", (String)null);
        buildLangTask.setTranslateClientSecret(translateClientSecret);
    }

    protected void configureTaskBuildUpgradeTableDir(BuildUpgradeTableTask buildUpgradeTableTask) {
        File file = GradleUtil.getProperty((Project)buildUpgradeTableTask.getProject(), (String)"upgrade.table.dir", (File)null);
        buildUpgradeTableTask.setUpgradeTableDir((Object)file);
    }

    protected void configureTaskBuildXSD(Project project) {
        BuildXSDTask buildXSDTask = (BuildXSDTask)GradleUtil.getTask((Project)project, (String)"buildXSD");
        this.configureTaskBuildXSDDestinationDir(buildXSDTask);
        this.configureTaskBuildXSDInputDir(buildXSDTask);
    }

    protected void configureTaskBuildXSDDestinationDir(BuildXSDTask buildXSDTask) {
        buildXSDTask.setDestinationDir(this.getLibDir(buildXSDTask.getProject()));
    }

    protected void configureTaskBuildXSDInputDir(BuildXSDTask buildXSDTask) {
        Project project = buildXSDTask.getProject();
        File inputDir = project.file((Object)"xsd");
        buildXSDTask.setInputDir((Object)inputDir);
    }

    protected void configureTaskClasses(Project project) {
        Task classesTask = GradleUtil.getTask((Project)project, (String)"classes");
        this.configureTaskClassesDependsOn(classesTask);
    }

    protected void configureTaskClassesDependsOn(Task classesTask) {
        classesTask.dependsOn(new Object[]{"buildCSS"});
    }

    protected void configureTaskClean(Project project) {
        Task cleanTask = GradleUtil.getTask((Project)project, (String)"clean");
        this.configureTaskCleanDependsOn(cleanTask);
    }

    protected void configureTaskCleanDependsOn(Task cleanTask) {
        Project project = cleanTask.getProject();
        for (Task task : project.getTasks()) {
            TaskOutputs taskOutputs;
            boolean autoClean = GradleUtil.getProperty((ExtensionAware)task, (String)AUTO_CLEAN_PROPERTY_NAME, (boolean)true);
            if (!autoClean || !(taskOutputs = task.getOutputs()).getHasOutput()) continue;
            String taskName = "clean" + StringUtil.capitalize((String)task.getName());
            cleanTask.dependsOn(new Object[]{taskName});
        }
    }

    protected void configureTaskConfigJSModules(Project project) {
        ConfigJSModulesTask configJSModulesTask = (ConfigJSModulesTask)GradleUtil.getTask((Project)project, (String)"configJSModules");
        this.configureTaskConfigJSModulesConfigVariable(configJSModulesTask);
        this.configureTaskConfigJSModulesDependsOn(configJSModulesTask);
        this.configureTaskConfigJSModulesIgnorePath(configJSModulesTask);
        this.configureTaskConfigJSModulesIncludes(configJSModulesTask);
        this.configureTaskConfigJSModulesModuleExtension(configJSModulesTask);
        this.configureTaskConfigJSModulesModuleFormat(configJSModulesTask);
        this.configureTaskConfigJSModulesMustRunAfter(configJSModulesTask);
        this.configureTaskConfigJSModulesSourceDir(configJSModulesTask);
    }

    protected void configureTaskConfigJSModulesConfigVariable(ConfigJSModulesTask configJSModulesTask) {
        configJSModulesTask.setConfigVariable((Object)"");
    }

    protected void configureTaskConfigJSModulesDependsOn(ConfigJSModulesTask configJSModulesTask) {
        configJSModulesTask.dependsOn(new Object[]{"processResources"});
    }

    protected void configureTaskConfigJSModulesIgnorePath(ConfigJSModulesTask configJSModulesTask) {
        configJSModulesTask.setIgnorePath(true);
    }

    protected void configureTaskConfigJSModulesIncludes(ConfigJSModulesTask configJSModulesTask) {
        configJSModulesTask.setIncludes(Collections.singleton("**/*.es.js"));
    }

    protected void configureTaskConfigJSModulesModuleExtension(ConfigJSModulesTask configJSModulesTask) {
        configJSModulesTask.setModuleExtension((Object)"");
    }

    protected void configureTaskConfigJSModulesModuleFormat(ConfigJSModulesTask configJSModulesTask) {
        configJSModulesTask.setModuleFormat((Object)"/_/g,-");
    }

    protected void configureTaskConfigJSModulesMustRunAfter(ConfigJSModulesTask configJSModulesTask) {
        configJSModulesTask.mustRunAfter(new Object[]{"transpileJS"});
    }

    protected void configureTaskConfigJSModulesSourceDir(final ConfigJSModulesTask configJSModulesTask) {
        configJSModulesTask.setSourceDir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                TranspileJSTask transpileJSTask = (TranspileJSTask)GradleUtil.getTask((Project)configJSModulesTask.getProject(), (String)"transpileJS");
                return new File(transpileJSTask.getOutputDir(), "META-INF/resources");
            }
        });
    }

    protected void configureTaskDeploy(Project project, LiferayExtension liferayExtension) {
        Task task = GradleUtil.getTask((Project)project, (String)DEPLOY_TASK_NAME);
        if (!(task instanceof Copy)) {
            return;
        }
        Copy copy = (Copy)task;
        this.configureTaskDeployInto(copy, liferayExtension);
        this.configureTaskDeployFrom(copy);
    }

    protected void configureTaskDeployFrom(Copy copy) {
        Project project = copy.getProject();
        Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
        this.addCleanDeployedFile(project, jar.getArchivePath());
    }

    protected void configureTaskDeployInto(Copy copy, LiferayExtension liferayExtension) {
        copy.into((Object)liferayExtension.getDeployDir());
    }

    protected void configureTaskDirectDeployAppServerDir(DirectDeployTask directDeployTask, LiferayExtension liferayExtension) {
        if (directDeployTask.getAppServerDir() == null) {
            directDeployTask.setAppServerDir(liferayExtension.getAppServerDir());
        }
    }

    protected void configureTaskDirectDeployAppServerLibGlobalDir(DirectDeployTask directDeployTask, LiferayExtension liferayExtension) {
        if (directDeployTask.getAppServerLibGlobalDir() == null) {
            directDeployTask.setAppServerLibGlobalDir(liferayExtension.getAppServerLibGlobalDir());
        }
    }

    protected void configureTaskDirectDeployAppServerPortalDir(DirectDeployTask directDeployTask, LiferayExtension liferayExtension) {
        if (directDeployTask.getAppServerPortalDir() == null) {
            directDeployTask.setAppServerPortalDir(liferayExtension.getAppServerPortalDir());
        }
    }

    protected void configureTaskDirectDeployAppServerType(DirectDeployTask directDeployTask, LiferayExtension liferayExtension) {
        if (Validator.isNull((String)directDeployTask.getAppServerType())) {
            directDeployTask.setAppServerType(liferayExtension.getAppServerType());
        }
    }

    protected boolean configureTaskEnabledWithAppServer(Task task, String appServerType) {
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)task.getProject(), LiferayExtension.class);
        String curAppServerType = liferayExtension.getAppServerType();
        if (!appServerType.equals(curAppServerType)) {
            task.setEnabled(false);
        }
        return task.getEnabled();
    }

    protected void configureTaskFormatXSD(Project project) {
        FormatXMLTask formatXMLTask = (FormatXMLTask)GradleUtil.getTask((Project)project, (String)FORMAT_XSD_TASK_NAME);
        this.configureTaskFormatXSDSource(formatXMLTask);
    }

    protected void configureTaskFormatXSDSource(FormatXMLTask formatXMLTask) {
        FileTree fileTree = formatXMLTask.getSource();
        if (!fileTree.isEmpty()) {
            return;
        }
        BuildXSDTask buildXSDTask = (BuildXSDTask)GradleUtil.getTask((Project)formatXMLTask.getProject(), (String)"buildXSD");
        formatXMLTask.setSource((Object)buildXSDTask.getInputDir());
        formatXMLTask.include(new String[]{"**/*.xsd"});
    }

    protected void configureTaskInitGradle(Project project) {
        InitGradleTask initGradleTask = (InitGradleTask)GradleUtil.getTask((Project)project, (String)INIT_GRADLE_TASK_NAME);
        this.configureTaskInitGradleIgnoreMissingDependencies(initGradleTask);
        this.configureTaskInitGradleOverwrite(initGradleTask);
    }

    protected void configureTaskInitGradleIgnoreMissingDependencies(InitGradleTask initGradleTask) {
        String value = GradleUtil.getTaskPrefixedProperty((Task)initGradleTask, (String)"ignoreMissingDependencies");
        if (Validator.isNotNull((String)value)) {
            initGradleTask.setIgnoreMissingDependencies(Boolean.parseBoolean(value));
        }
    }

    protected void configureTaskInitGradleOverwrite(InitGradleTask initGradleTask) {
        String value = GradleUtil.getTaskPrefixedProperty((Task)initGradleTask, (String)"overwrite");
        if (Validator.isNotNull((String)value)) {
            initGradleTask.setOverwrite(Boolean.parseBoolean(value));
        }
    }

    protected void configureTaskJar(Project project) {
        Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
        this.configureTaskJarDependsOn(jar);
        this.configureTaskJarDuplicatesStrategy(jar);
    }

    protected void configureTaskJarDependsOn(Jar jar) {
        Project project = jar.getProject();
        if (this.isTestProject(project)) {
            jar.dependsOn(new Object[]{"testClasses"});
            SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"testIntegration");
            jar.dependsOn(new Object[]{sourceSet.getClassesTaskName()});
        }
    }

    protected void configureTaskJarDuplicatesStrategy(Jar jar) {
        jar.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
    }

    protected void configureTaskPublishNodeModule(PublishNodeModuleTask publishNodeModuleTask) {
        this.configureTaskPublishNodeModuleAuthor(publishNodeModuleTask);
        this.configureTaskPublishNodeModuleBugsUrl(publishNodeModuleTask);
        this.configureTaskPublishNodeModuleLicense(publishNodeModuleTask);
        this.configureTaskPublishNodeModuleNpmEmailAddress(publishNodeModuleTask);
        this.configureTaskPublishNodeModuleNpmPassword(publishNodeModuleTask);
        this.configureTaskPublishNodeModuleNpmUserName(publishNodeModuleTask);
        this.configureTaskPublishNodeModuleRepository(publishNodeModuleTask);
    }

    protected void configureTaskPublishNodeModuleAuthor(PublishNodeModuleTask publishNodeModuleTask) {
        if (Validator.isNotNull((String)publishNodeModuleTask.getModuleAuthor())) {
            return;
        }
        String author = GradleUtil.getProperty((ExtensionAware)publishNodeModuleTask.getProject(), (String)"nodejs.npm.module.author", (String)null);
        if (Validator.isNotNull((String)author)) {
            publishNodeModuleTask.setModuleAuthor((Object)author);
        }
    }

    protected void configureTaskPublishNodeModuleBugsUrl(PublishNodeModuleTask publishNodeModuleTask) {
        if (Validator.isNotNull((String)publishNodeModuleTask.getModuleBugsUrl())) {
            return;
        }
        String bugsUrl = GradleUtil.getProperty((ExtensionAware)publishNodeModuleTask.getProject(), (String)"nodejs.npm.module.bugs.url", (String)null);
        if (Validator.isNotNull((String)bugsUrl)) {
            publishNodeModuleTask.setModuleBugsUrl((Object)bugsUrl);
        }
    }

    protected void configureTaskPublishNodeModuleLicense(PublishNodeModuleTask publishNodeModuleTask) {
        if (Validator.isNotNull((String)publishNodeModuleTask.getModuleLicense())) {
            return;
        }
        String license = GradleUtil.getProperty((ExtensionAware)publishNodeModuleTask.getProject(), (String)"nodejs.npm.module.license", (String)null);
        if (Validator.isNotNull((String)license)) {
            publishNodeModuleTask.setModuleLicense((Object)license);
        }
    }

    protected void configureTaskPublishNodeModuleNpmEmailAddress(PublishNodeModuleTask publishNodeModuleTask) {
        if (Validator.isNotNull((String)publishNodeModuleTask.getNpmEmailAddress())) {
            return;
        }
        String emailAddress = GradleUtil.getProperty((ExtensionAware)publishNodeModuleTask.getProject(), (String)"nodejs.npm.email", (String)null);
        if (Validator.isNotNull((String)emailAddress)) {
            publishNodeModuleTask.setNpmEmailAddress((Object)emailAddress);
        }
    }

    protected void configureTaskPublishNodeModuleNpmPassword(PublishNodeModuleTask publishNodeModuleTask) {
        if (Validator.isNotNull((String)publishNodeModuleTask.getNpmPassword())) {
            return;
        }
        String password = GradleUtil.getProperty((ExtensionAware)publishNodeModuleTask.getProject(), (String)"nodejs.npm.password", (String)null);
        if (Validator.isNotNull((String)password)) {
            publishNodeModuleTask.setNpmPassword((Object)password);
        }
    }

    protected void configureTaskPublishNodeModuleNpmUserName(PublishNodeModuleTask publishNodeModuleTask) {
        if (Validator.isNotNull((String)publishNodeModuleTask.getNpmUserName())) {
            return;
        }
        String userName = GradleUtil.getProperty((ExtensionAware)publishNodeModuleTask.getProject(), (String)"nodejs.npm.user", (String)null);
        if (Validator.isNotNull((String)userName)) {
            publishNodeModuleTask.setNpmUserName((Object)userName);
        }
    }

    protected void configureTaskPublishNodeModuleRepository(PublishNodeModuleTask publishNodeModuleTask) {
        if (Validator.isNotNull((String)publishNodeModuleTask.getModuleRepository())) {
            return;
        }
        String repository = GradleUtil.getProperty((ExtensionAware)publishNodeModuleTask.getProject(), (String)"nodejs.npm.module.repository", (String)null);
        if (Validator.isNotNull((String)repository)) {
            publishNodeModuleTask.setModuleRepository((Object)repository);
        }
    }

    protected void configureTasks(Project project, LiferayExtension liferayExtension) {
        this.configureTaskBuildLang(project);
        this.configureTaskClasses(project);
        this.configureTaskClean(project);
        this.configureTaskDeploy(project, liferayExtension);
        this.configureTaskFormatXSD(project);
        this.configureTaskInitGradle(project);
        this.configureTaskJar(project);
        this.configureTaskSetupTestableTomcat(project, liferayExtension);
        this.configureTaskStartTestableTomcat(project, liferayExtension);
        this.configureTaskTestIntegration(project, liferayExtension);
        this.configureTasksAppServer(project, liferayExtension);
        this.configureTasksDirectDeploy(project);
        this.configureTasksPublishNodeModule(project);
    }

    protected void configureTasksAppServer(Project project, final LiferayExtension liferayExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(AppServerTask.class, (Action)new Action<AppServerTask>(){

            public void execute(AppServerTask appServerTask) {
                String appServerType = appServerTask.getAppServerType();
                if (Validator.isNull((String)appServerType)) {
                    return;
                }
                AppServer appServer = liferayExtension.getAppServer(appServerType);
                appServerTask.merge(appServer);
            }
        });
    }

    protected void configureTasksBuildCSS(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildCSSTask.class, (Action)new Action<BuildCSSTask>(){

            public void execute(BuildCSSTask buildCSSTask) {
                LiferayJavaPlugin.this.configureTaskBuildCSSGenerateSourceMap(buildCSSTask);
                LiferayJavaPlugin.this.configureTaskBuildCSSSassCompilerClassName(buildCSSTask);
            }
        });
    }

    protected void configureTasksBuildUpgradeTable(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildUpgradeTableTask.class, (Action)new Action<BuildUpgradeTableTask>(){

            public void execute(BuildUpgradeTableTask buildUpgradeTableTask) {
                LiferayJavaPlugin.this.configureTaskBuildUpgradeTableDir(buildUpgradeTableTask);
            }
        });
    }

    protected void configureTasksDirectDeploy(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(DirectDeployTask.class, (Action)new Action<DirectDeployTask>(){

            public void execute(DirectDeployTask directDeployTask) {
                LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)directDeployTask.getProject(), LiferayExtension.class);
                LiferayJavaPlugin.this.configureTaskDirectDeployAppServerDir(directDeployTask, liferayExtension);
                LiferayJavaPlugin.this.configureTaskDirectDeployAppServerLibGlobalDir(directDeployTask, liferayExtension);
                LiferayJavaPlugin.this.configureTaskDirectDeployAppServerPortalDir(directDeployTask, liferayExtension);
                LiferayJavaPlugin.this.configureTaskDirectDeployAppServerType(directDeployTask, liferayExtension);
            }
        });
    }

    protected void configureTaskSetupTestableTomcat(Project project, LiferayExtension liferayExtension) {
        SetupTestableTomcatTask setupTestableTomcatTask = (SetupTestableTomcatTask)GradleUtil.getTask((Project)project, (String)SETUP_TESTABLE_TOMCAT_TASK_NAME);
        if (!this.configureTaskEnabledWithAppServer(setupTestableTomcatTask, "tomcat")) {
            return;
        }
        this.configureTaskSetupTestableTomcatJmx(setupTestableTomcatTask, liferayExtension);
        this.configureTaskSetupTestableTomcatModuleFrameworkBaseDir(setupTestableTomcatTask, liferayExtension);
    }

    protected void configureTaskSetupTestableTomcatJmx(SetupTestableTomcatTask setupTestableTomcatTask, LiferayExtension liferayExtension) {
        if (setupTestableTomcatTask.getJmxRemotePort() > 0) {
            return;
        }
        setupTestableTomcatTask.setJmxRemotePort(liferayExtension.getJmxRemotePort());
    }

    protected void configureTaskSetupTestableTomcatModuleFrameworkBaseDir(SetupTestableTomcatTask setupTestableTomcatTask, LiferayExtension liferayExtension) {
        if (setupTestableTomcatTask.getModuleFrameworkBaseDir() != null) {
            return;
        }
        File moduleFrameworkBaseDir = new File(liferayExtension.getLiferayHome(), "osgi");
        setupTestableTomcatTask.setModuleFrameworkBaseDir(moduleFrameworkBaseDir);
    }

    protected void configureTasksPublishNodeModule(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PublishNodeModuleTask.class, (Action)new Action<PublishNodeModuleTask>(){

            public void execute(PublishNodeModuleTask publishNodeModuleTask) {
                LiferayJavaPlugin.this.configureTaskPublishNodeModule(publishNodeModuleTask);
            }
        });
    }

    protected void configureTaskStartTestableTomcat(Project project, LiferayExtension liferayExtension) {
        StartAppServerTask startTestableTomcatTask = (StartAppServerTask)GradleUtil.getTask((Project)project, (String)START_TESTABLE_TOMCAT_TASK_NAME);
        this.configureTaskEnabledWithAppServer(startTestableTomcatTask, "tomcat");
    }

    protected void configureTasksTest(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(Test.class, (Action)new Action<Test>(){

            public void execute(Test test) {
                LiferayJavaPlugin.this.configureTaskTestDefaultCharacterEncoding(test);
                LiferayJavaPlugin.this.configureTaskTestForkEvery(test);
                LiferayJavaPlugin.this.configureTaskTestIgnoreFailures(test);
                LiferayJavaPlugin.this.configureTaskTestJvmArgs(test);
                LiferayJavaPlugin.this.configureTaskTestWhip(test);
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                TaskContainer taskContainer = project.getTasks();
                final LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
                taskContainer.withType(Test.class, (Action)new Action<Test>(){

                    public void execute(Test test) {
                        LiferayJavaPlugin.this.configureTaskTestIncludes(test);
                        LiferayJavaPlugin.this.configureTaskTestSystemProperties(test, liferayExtension);
                    }
                });
            }
        });
    }

    protected void configureTaskTestDefaultCharacterEncoding(Test test) {
        test.setDefaultCharacterEncoding(StandardCharsets.UTF_8.name());
    }

    protected boolean configureTaskTestEnabledWithCandidateClassFiles(Test test) {
        FileTree fileTree = test.getCandidateClassFiles();
        if (fileTree.isEmpty()) {
            test.setEnabled(false);
        }
        return test.getEnabled();
    }

    protected void configureTaskTestForkEvery(Test test) {
        String name = test.getName();
        if (name.equals("test")) {
            test.setForkEvery(Long.valueOf(1L));
        } else if (name.equals("testIntegration")) {
            test.setForkEvery(null);
        }
    }

    protected void configureTaskTestIgnoreFailures(Test test) {
        test.setIgnoreFailures(true);
    }

    protected void configureTaskTestIncludes(Test test) {
        Set includes = test.getIncludes();
        if (includes.isEmpty()) {
            test.setIncludes(Collections.singleton("**/*Test.class"));
        }
    }

    protected void configureTaskTestIntegration(Project project, LiferayExtension liferayExtension) {
        Test test = (Test)GradleUtil.getTask((Project)project, (String)"testIntegration");
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"testIntegration");
        File srcDir = this.getSrcDir(sourceSet.getResources());
        File skipManagedAppServerFile = new File(srcDir, _SKIP_MANAGED_APP_SERVER_FILE_NAME);
        if (!skipManagedAppServerFile.exists() && this.configureTaskEnabledWithAppServer((Task)test, "tomcat") && this.configureTaskTestEnabledWithCandidateClassFiles(test)) {
            test.dependsOn(new Object[]{START_TESTABLE_TOMCAT_TASK_NAME});
            Task stopTestableTomcatTask = GradleUtil.getTask((Project)project, (String)STOP_TESTABLE_TOMCAT_TASK_NAME);
            stopTestableTomcatTask.mustRunAfter(new Object[]{test});
        }
    }

    protected void configureTaskTestJvmArgs(Test test) {
        test.jvmArgs(new Object[]{"-Djava.net.preferIPv4Stack=true"});
        test.jvmArgs(new Object[]{"-Dliferay.mode=test"});
        test.jvmArgs(new Object[]{"-Duser.timezone=GMT"});
        String name = test.getName();
        if (name.equals("test")) {
            name = "junit.java.unit.gc";
        } else if (name.equals("testIntegration")) {
            name = "junit.java.integration.gc";
        }
        String value = GradleUtil.getProperty((ExtensionAware)test.getProject(), (String)name, (String)null);
        if (Validator.isNotNull((String)value)) {
            test.jvmArgs((Object[])value.split("\\s+"));
        }
    }

    protected void configureTaskTestSystemProperties(Test test, LiferayExtension liferayExtension) {
        Map systemProperties = test.getSystemProperties();
        if (systemProperties.containsKey("app.server.tomcat.dir")) {
            return;
        }
        AppServer appServer = liferayExtension.getAppServer("tomcat");
        test.systemProperty("app.server.tomcat.dir", (Object)FileUtil.getAbsolutePath((File)appServer.getDir()));
    }

    protected void configureTaskTestWhip(Test test) {
        WhipTaskExtension whipTaskExtension = (WhipTaskExtension)GradleUtil.getExtension((ExtensionAware)test, WhipTaskExtension.class);
        whipTaskExtension.excludes(new Object[]{".*Test", ".*Test\\$.*", ".*\\$Proxy.*", "com/liferay/whip/.*"});
        whipTaskExtension.includes(new Object[]{"com/liferay/.*"});
    }

    protected void configureTaskTranspileJS(Project project) {
        TranspileJSTask transpileJSTask = (TranspileJSTask)GradleUtil.getTask((Project)project, (String)"transpileJS");
        this.configureTaskTranspileJSDependsOn(transpileJSTask);
        this.configureTaskTranspileJSSourceDir(transpileJSTask);
        this.configureTaskTranspileJSIncludes(transpileJSTask);
    }

    protected void configureTaskTranspileJSDependsOn(TranspileJSTask transpileJSTask) {
        transpileJSTask.dependsOn(new Object[]{"processResources"});
    }

    protected void configureTaskTranspileJSIncludes(TranspileJSTask transpileJSTask) {
        transpileJSTask.setIncludes(Collections.singleton("**/*.es.js"));
    }

    protected void configureTaskTranspileJSSourceDir(TranspileJSTask transpileJSTask) {
        transpileJSTask.setSourceDir((Object)this.getResourcesDir(transpileJSTask.getProject()));
    }

    protected void configureTestResultsDir(Project project) {
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)GradleUtil.getConvention((Project)project, JavaPluginConvention.class);
        File testResultsDir = project.file((Object)"test-results/unit");
        javaPluginConvention.setTestResultsDirName(FileUtil.relativize((File)testResultsDir, (File)project.getBuildDir()));
    }

    protected void configureVersion(Project project, LiferayExtension liferayExtension) {
        project.setVersion((Object)(liferayExtension.getVersionPrefix() + "." + project.getVersion()));
    }

    protected String getDeployedFileName(Project project, File sourceFile) {
        return sourceFile.getName();
    }

    protected File getJavaDir(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        return this.getSrcDir(sourceSet.getJava());
    }

    protected File getLibDir(Project project) {
        return project.file((Object)"lib");
    }

    protected File getResourcesDir(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        return this.getSrcDir(sourceSet.getResources());
    }

    protected File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }

    protected boolean isAddDefaultDependencies(Project project) {
        return GradleUtil.getProperty((ExtensionAware)project, (String)_ADD_DEFAULT_DEPENDENCIES_PROPERTY_NAME, (boolean)true);
    }

    protected boolean isAddTestDefaultDependencies(Project project) {
        return GradleUtil.getProperty((ExtensionAware)project, (String)_ADD_TEST_DEFAULT_DEPENDENCIES_PROPERTY_NAME, (boolean)true);
    }

    protected boolean isCleanDeployed(Delete delete) {
        return GradleUtil.getProperty((ExtensionAware)delete, (String)CLEAN_DEPLOYED_PROPERTY_NAME, (boolean)true);
    }

    protected boolean isTestProject(Project project) {
        String projectName = project.getName();
        return projectName.endsWith("-test");
    }

    private int _updateStartedAppServerStopCounters(File appServerBinDir, boolean increment) {
        int originalCounter = 0;
        if (_startedAppServerStopCounters.containsKey(appServerBinDir)) {
            originalCounter = _startedAppServerStopCounters.get(appServerBinDir);
        }
        int counter = originalCounter;
        counter = increment ? ++counter : --counter;
        _startedAppServerStopCounters.put(appServerBinDir, counter);
        return originalCounter;
    }
}

