/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tasks;

import com.liferay.gradle.plugins.tasks.BasePortalToolsTask;
import com.liferay.gradle.plugins.util.FileUtil;
import com.liferay.gradle.plugins.util.GradleUtil;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.process.internal.streams.SafeStreams;
import org.gradle.util.GUtil;

public class BuildThumbnailsTask
extends BasePortalToolsTask {
    private int _height = 120;
    private final List<Object> _imageDirs = new ArrayList<Object>();
    private boolean _overwrite;
    private int _width = 160;

    public BuildThumbnailsTask() {
        GradleUtil.setProperty((ExtensionAware)this, (String)"autoClean", (Object)false);
    }

    @Override
    public void exec() {
        FileCollection files = this.getScreenshotFiles();
        for (File file : files) {
            super.setErrorOutput(SafeStreams.systemErr());
            super.setStandardOutput(SafeStreams.systemOut());
            this.doExec(this.getArgs(file));
        }
    }

    @Override
    public List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("thumbnail.height=" + this.getHeight());
        args.add("thumbnail.width=" + this.getWidth());
        args.add("thumbnail.overwrite=" + this.isOverwrite());
        return args;
    }

    @Input
    public int getHeight() {
        return this._height;
    }

    public FileCollection getImageDirs() {
        return this.project.files(new Object[]{this._imageDirs});
    }

    @Override
    public String getMain() {
        return "com.liferay.portal.tools.ThumbnailBuilder";
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getScreenshotFiles() {
        ArrayList<ConfigurableFileTree> fileTrees = new ArrayList<ConfigurableFileTree>();
        for (File imagesDir : this.getImageDirs()) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("dir", imagesDir);
            args.put("include", "**/screenshot.png");
            ConfigurableFileTree fileTree = this.project.fileTree(args);
            fileTrees.add(fileTree);
        }
        return this.project.files(fileTrees.toArray());
    }

    @OutputFiles
    public FileCollection getThumbnailFiles() {
        ArrayList<File> thumbnailFiles = new ArrayList<File>();
        for (File screenshotFile : this.getScreenshotFiles()) {
            File thumbnailFile = new File(screenshotFile.getParentFile(), "thumbnail.png");
            thumbnailFiles.add(thumbnailFile);
        }
        return this.project.files(new Object[]{thumbnailFiles});
    }

    @Input
    public int getWidth() {
        return this._width;
    }

    public BuildThumbnailsTask imageDirs(Iterable<Object> imageDirs) {
        GUtil.addToCollection(this._imageDirs, (Iterable[])new Iterable[]{imageDirs});
        return this;
    }

    public BuildThumbnailsTask imageDirs(Object ... imageDirs) {
        return this.imageDirs(Arrays.asList(imageDirs));
    }

    @Input
    public boolean isOverwrite() {
        return this._overwrite;
    }

    public JavaExec setErrorOutput(OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }

    public void setHeight(int height) {
        this._height = height;
    }

    public void setImageDirs(Iterable<Object> imageDirs) {
        this._imageDirs.clear();
        this.imageDirs(imageDirs);
    }

    public void setOverwrite(boolean overwrite) {
        this._overwrite = overwrite;
    }

    public JavaExec setStandardOutput(OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }

    public void setWidth(int width) {
        this._width = width;
    }

    @Override
    protected void addDependencies() {
        super.addDependencies();
        this.addDependency("com.liferay", "org.monte", "0.7.7");
    }

    protected List<String> getArgs(File screenshotFile) {
        List<String> args = this.getArgs();
        args.add("thumbnail.original.file=" + FileUtil.getAbsolutePath((File)screenshotFile));
        File thumbnailFile = new File(screenshotFile.getParentFile(), "thumbnail.png");
        args.add("thumbnail.thumbnail.file=" + FileUtil.getAbsolutePath((File)thumbnailFile));
        return args;
    }

    @Override
    protected String getToolName() {
        return "ThumbnailBuilder";
    }
}

