/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.BasePortalToolDefaultsPlugin;
import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.service.builder.BuildServiceTask;
import com.liferay.gradle.plugins.service.builder.ServiceBuilderPlugin;
import com.liferay.gradle.plugins.tasks.BuildDBTask;
import com.liferay.gradle.plugins.util.GradleUtil;
import java.io.File;
import java.util.concurrent.Callable;
import org.dm.gradle.plugins.bundle.BundlePlugin;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskContainer;

public class ServiceBuilderDefaultsPlugin
extends BasePortalToolDefaultsPlugin<ServiceBuilderPlugin> {
    public static final String BUILD_DB_TASK_NAME = "buildDB";
    public static final String PORTAL_TOOL_NAME = "com.liferay.portal.tools.service.builder";

    protected BuildDBTask addTaskBuildDB(final Project project) {
        BuildDBTask buildDBTask = (BuildDBTask)GradleUtil.addTask((Project)project, (String)BUILD_DB_TASK_NAME, BuildDBTask.class);
        buildDBTask.setDatabaseName("lportal");
        buildDBTask.setDatabaseTypes("hypersonic", "mysql", "postgresql");
        buildDBTask.setDescription("Builds database SQL scripts from the generic SQL scripts.");
        buildDBTask.setGroup("build");
        buildDBTask.setSqlDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                BuildServiceTask buildServiceTask = (BuildServiceTask)GradleUtil.getTask((Project)project, (String)"buildService");
                return buildServiceTask.getSqlDir();
            }
        });
        return buildDBTask;
    }

    @Override
    protected void configureDefaults(final Project project, ServiceBuilderPlugin serviceBuilderPlugin) {
        super.configureDefaults(project, serviceBuilderPlugin);
        this.addTaskBuildDB(project);
        GradleUtil.withPlugin(project, LiferayBasePlugin.class, new Action<LiferayBasePlugin>(){

            public void execute(LiferayBasePlugin liferayBasePlugin) {
                Configuration portalConfiguration = GradleUtil.getConfiguration((Project)project, (String)"portal");
                ServiceBuilderDefaultsPlugin.this.configureTasksBuildDB(project, (FileCollection)portalConfiguration);
            }
        });
        GradleUtil.withPlugin(project, BundlePlugin.class, new Action<BundlePlugin>(){

            public void execute(BundlePlugin bundlePlugin) {
                ServiceBuilderDefaultsPlugin.this.configureTasksBuildServiceForBundlePlugin(project);
            }
        });
    }

    protected void configureTaskBuildDBClasspath(BuildDBTask buildDBTask, FileCollection fileCollection) {
        buildDBTask.setClasspath(fileCollection);
    }

    protected void configureTaskBuildServiceForBundlePlugin(BuildServiceTask buildServiceTask) {
        buildServiceTask.setOsgiModule(true);
    }

    protected void configureTasksBuildDB(Project project, final FileCollection classpath) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildDBTask.class, (Action)new Action<BuildDBTask>(){

            public void execute(BuildDBTask buildDBTask) {
                ServiceBuilderDefaultsPlugin.this.configureTaskBuildDBClasspath(buildDBTask, classpath);
            }
        });
    }

    protected void configureTasksBuildServiceForBundlePlugin(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildServiceTask.class, (Action)new Action<BuildServiceTask>(){

            public void execute(BuildServiceTask buildServiceTask) {
                ServiceBuilderDefaultsPlugin.this.configureTaskBuildServiceForBundlePlugin(buildServiceTask);
            }
        });
    }

    @Override
    protected Class<ServiceBuilderPlugin> getPluginClass() {
        return ServiceBuilderPlugin.class;
    }

    @Override
    protected String getPortalToolConfigurationName() {
        return "serviceBuilder";
    }

    @Override
    protected String getPortalToolName() {
        return PORTAL_TOOL_NAME;
    }
}

