/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.util.GradleUtil;
import groovy.lang.Closure;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;

public class EclipseDefaultsPlugin
extends BaseDefaultsPlugin<EclipsePlugin> {
    @Override
    protected void configureDefaults(Project project, EclipsePlugin eclipsePlugin) {
        this.configureEclipseClasspathFile(project);
        this.configureTaskEclipse(project, eclipsePlugin);
    }

    protected void configureEclipseClasspathFile(Project project) {
        EclipseModel eclipseModel = (EclipseModel)GradleUtil.getExtension((ExtensionAware)project, EclipseModel.class);
        EclipseClasspath eclipseClasspath = eclipseModel.getClasspath();
        XmlFileContentMerger fileContentMerger = eclipseClasspath.getFile();
        Closure<Void> closure = new Closure<Void>(null){

            public void doCall(Classpath classpath) {
                List classpathEntries = classpath.getEntries();
                Iterator iterator = classpathEntries.iterator();
                while (iterator.hasNext()) {
                    ClasspathEntry classpathEntry = (ClasspathEntry)iterator.next();
                    if (!(classpathEntry instanceof AbstractClasspathEntry)) continue;
                    AbstractClasspathEntry abstractClasspathEntry = (AbstractClasspathEntry)classpathEntry;
                    String kind = abstractClasspathEntry.getKind();
                    String path = abstractClasspathEntry.getPath();
                    if (!kind.equals("lib") || !path.endsWith(".pom")) continue;
                    iterator.remove();
                }
            }
        };
        fileContentMerger.whenMerged((Closure)closure);
    }

    protected void configureTaskEclipse(Project project, EclipsePlugin eclipsePlugin) {
        Task task = eclipsePlugin.getLifecycleTask();
        task.dependsOn(new Object[]{eclipsePlugin.getCleanTask()});
    }

    @Override
    protected Class<EclipsePlugin> getPluginClass() {
        return EclipsePlugin.class;
    }
}

