/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;

public class FileUtil
extends com.liferay.gradle.util.FileUtil {
    public static File getJavaClassesDir(SourceSet sourceSet) {
        SourceDirectorySet sourceDirectorySet = sourceSet.getJava();
        Provider provider = sourceDirectorySet.getClassesDirectory();
        Directory directory = (Directory)provider.getOrNull();
        if (directory == null) {
            return null;
        }
        return directory.getAsFile();
    }

    public static List<String> getRelativePaths(final Path path, final String fileName, final List<String> excludes, final boolean childrenOnly) throws IOException {
        final ArrayList<String> paths = new ArrayList<String>();
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                if (childrenOnly && dirPath.equals(path)) {
                    return FileVisitResult.CONTINUE;
                }
                if (FileUtil._isExcludedDirName(dirPath.getFileName(), excludes)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (Files.exists(dirPath.resolve(fileName), new LinkOption[0])) {
                    Path relativePath = path.relativize(dirPath);
                    paths.add(relativePath.toString());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return paths;
    }

    public static void moveTree(File sourceRootDir, File destinationRootDir) {
        try {
            FileUtil._moveTree(sourceRootDir.toPath(), destinationRootDir.toPath());
        }
        catch (IOException ioException) {
            throw new UncheckedIOException((Throwable)ioException);
        }
    }

    public static String read(File file) {
        try {
            return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException ioException) {
            throw new UncheckedIOException((Throwable)ioException);
        }
    }

    private static boolean _isExcludedDirName(Path path, List<String> excludes) {
        String dirName = String.valueOf(path);
        if (dirName == null) {
            return false;
        }
        return excludes.contains(dirName);
    }

    private static void _moveTree(final Path sourceRootDirPath, final Path destinationRootDirPath) throws IOException {
        Files.walkFileTree(sourceRootDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dirPath, IOException ioException) throws IOException {
                Files.delete(dirPath);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                Path relativePath = sourceRootDirPath.relativize(dirPath);
                Path destinationDirPath = destinationRootDirPath.resolve(relativePath);
                Files.createDirectories(destinationDirPath, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

