/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.util.copy;

import com.liferay.gradle.util.hash.HashUtil;
import com.liferay.gradle.util.hash.HashValue;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.file.FileCopyDetails;

public class HashifyAction
implements Action<FileCopyDetails> {
    private final Pattern _fileNamePattern;

    public HashifyAction(String regex) {
        this._fileNamePattern = Pattern.compile(regex);
    }

    public void execute(FileCopyDetails fileCopyDetails) {
        String fileName = fileCopyDetails.getName();
        Matcher matcher = this._fileNamePattern.matcher(fileName);
        if (!matcher.matches()) {
            return;
        }
        fileCopyDetails.setName(this._getHashedFileName(fileCopyDetails));
    }

    private String _getHashedFileName(FileCopyDetails fileCopyDetails) {
        HashValue hashValue = HashUtil.sha1((File)fileCopyDetails.getFile());
        String fileName = fileCopyDetails.getName();
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return fileName + '.' + hashValue.asHexString();
        }
        String extension = fileName.substring(index + 1);
        String shortFileName = fileName.substring(0, index);
        return shortFileName + '.' + hashValue.asHexString() + '.' + extension;
    }
}

