/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.theme.builder;

import com.liferay.gradle.plugins.css.builder.BuildCSSTask;
import com.liferay.gradle.plugins.css.builder.CSSBuilderPlugin;
import com.liferay.gradle.plugins.theme.builder.BuildThemeTask;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.War;

public class ThemeBuilderPlugin
implements Plugin<Project> {
    public static final String BUILD_THEME_TASK_NAME = "buildTheme";
    public static final String PARENT_THEMES_CONFIGURATION_NAME = "parentThemes";
    public static final String THEME_BUILDER_CONFIGURATION_NAME = "themeBuilder";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, CSSBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, WarPlugin.class);
        BuildCSSTask buildCSSTask = (BuildCSSTask)GradleUtil.getTask((Project)project, (String)"buildCSS");
        War war = (War)GradleUtil.getTask((Project)project, (String)"war");
        WarPluginConvention warPluginConvention = (WarPluginConvention)GradleUtil.getConvention((Project)project, WarPluginConvention.class);
        Configuration parentThemesConfiguration = this._addConfigurationParentThemes(project);
        Configuration themeBuilderConfiguration = this._addConfigurationThemeBuilder(project);
        BuildThemeTask buildThemeTask = this._addTaskBuildTheme(project, (Iterable<File>)parentThemesConfiguration, warPluginConvention);
        this._configureTaskBuildCSS(buildCSSTask, buildThemeTask);
        this._configureTaskWar(war, buildCSSTask, buildThemeTask);
        this._configureTasksBuildTheme(project, (FileCollection)themeBuilderConfiguration);
    }

    private Configuration _addConfigurationParentThemes(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)PARENT_THEMES_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                ThemeBuilderPlugin.this._addDependenciesParentThemes(project);
            }
        });
        configuration.setDescription("Configures the parent theme JARs required to build theme files.");
        configuration.setTransitive(false);
        configuration.setVisible(false);
        return configuration;
    }

    private Configuration _addConfigurationThemeBuilder(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)THEME_BUILDER_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                ThemeBuilderPlugin.this._addDependenciesThemeBuilder(project);
            }
        });
        configuration.setDescription("Configures Liferay Portal Tools Theme Builder for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesParentThemes(Project project) {
        GradleUtil.addDependency((Project)project, (String)PARENT_THEMES_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.frontend.theme.styled", (String)"latest.release");
        GradleUtil.addDependency((Project)project, (String)PARENT_THEMES_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.frontend.theme.unstyled", (String)"latest.release");
        GradleUtil.addDependency((Project)project, (String)PARENT_THEMES_CONFIGURATION_NAME, (String)"com.liferay.plugins", (String)"classic-theme", (String)"latest.release");
    }

    private void _addDependenciesThemeBuilder(Project project) {
        GradleUtil.addDependency((Project)project, (String)THEME_BUILDER_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.portal.tools.theme.builder", (String)"latest.release");
    }

    private BuildThemeTask _addTaskBuildTheme(Project project, final Iterable<File> parentThemeFiles, final WarPluginConvention warPluginConvention) {
        final BuildThemeTask buildThemeTask = (BuildThemeTask)GradleUtil.addTask((Project)project, (String)BUILD_THEME_TASK_NAME, BuildThemeTask.class);
        buildThemeTask.setDescription("Builds the theme files.");
        buildThemeTask.setDiffsDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return warPluginConvention.getWebAppDir();
            }
        });
        buildThemeTask.setGroup("build");
        buildThemeTask.setOutputDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                Project project = buildThemeTask.getProject();
                return new File(project.getBuildDir(), buildThemeTask.getName());
            }
        });
        buildThemeTask.setParentFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                String parentName = buildThemeTask.getParentName();
                if (Validator.isNull((String)parentName)) {
                    return null;
                }
                return ThemeBuilderPlugin.this._getThemeFile(parentThemeFiles, parentName);
            }
        });
        buildThemeTask.setParentName("_styled");
        buildThemeTask.setTemplateExtension("ftl");
        buildThemeTask.setThemeName(project.getName());
        buildThemeTask.setUnstyledFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return ThemeBuilderPlugin.this._getThemeFile(parentThemeFiles, "_unstyled");
            }
        });
        return buildThemeTask;
    }

    private void _configureTaskBuildCSS(BuildCSSTask buildCSSTask, final BuildThemeTask buildThemeTask) {
        buildCSSTask.dependsOn(new Object[]{buildThemeTask});
        buildCSSTask.setDocrootDir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return buildThemeTask.getOutputDir();
            }
        });
    }

    private void _configureTasksBuildTheme(Project project, final FileCollection classpath) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildThemeTask.class, (Action)new Action<BuildThemeTask>(){

            public void execute(BuildThemeTask buildThemeTask) {
                buildThemeTask.setClasspath(classpath);
            }
        });
    }

    private void _configureTaskWar(War war, final BuildCSSTask buildCSSTask, final BuildThemeTask buildThemeTask) {
        war.dependsOn(new Object[]{buildThemeTask});
        war.eachFile((Action)new Action<FileCopyDetails>(){

            public void execute(FileCopyDetails fileCopyDetails) {
                String dirName = buildCSSTask.getOutputDirName();
                if ((dirName = dirName.replace('\\', '/')).charAt(0) != '/') {
                    dirName = '/' + dirName;
                }
                if (dirName.charAt(dirName.length() - 1) != '/') {
                    dirName = dirName + '/';
                }
                String path = fileCopyDetails.getPath();
                fileCopyDetails.setPath(path.replace(dirName, "/"));
            }
        });
        war.exclude((Spec)new Spec<FileTreeElement>(){

            public boolean isSatisfiedBy(FileTreeElement fileTreeElement) {
                File diffsDir = buildThemeTask.getDiffsDir();
                return diffsDir != null && FileUtil.isChild((File)fileTreeElement.getFile(), (File)diffsDir);
            }
        });
        war.exclude(new String[]{"**/*.scss"});
        war.from(new Object[]{new Callable<File>(){

            @Override
            public File call() throws Exception {
                return buildThemeTask.getOutputDir();
            }
        }});
        war.setIncludeEmptyDirs(false);
    }

    private File _getThemeFile(Iterable<File> files, String name) throws IOException {
        for (File file : files) {
            String fileName = file.getName();
            if (fileName.endsWith(".war")) {
                if (!fileName.startsWith(name + "-theme-")) continue;
                return file;
            }
            ZipFile zipFile = new ZipFile(file);
            Throwable throwable = null;
            try {
                ZipEntry zipEntry = zipFile.getEntry("META-INF/resources/" + name + "/");
                if (zipEntry == null) continue;
                File file2 = file;
                return file2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (zipFile == null) continue;
                if (throwable != null) {
                    try {
                        zipFile.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                zipFile.close();
            }
        }
        return null;
    }
}

