/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.gradle.plugins.testray;

import com.liferay.gradle.util.GradleUtil;

import java.io.File;

import org.gradle.api.Project;

/**
 * @author Andrea Di Giorgi
 */
public class TestrayExtension {

	public TestrayExtension(Project project) {
		_project = project;
	}

	public String getJenkinsResultsParserVersion() {
		return GradleUtil.toString(_jenkinsResultsParserVersion);
	}

	public File getTestrayPropertiesFile() {
		return GradleUtil.toFile(_project, _testrayPropertiesFile);
	}

	public void setJenkinsResultsParserVersion(
		Object jenkinsResultsParserVersion) {

		_jenkinsResultsParserVersion = jenkinsResultsParserVersion;
	}

	public void setTestrayPropertiesFile(Object testrayPropertiesFile) {
		_testrayPropertiesFile = testrayPropertiesFile;
	}

	private Object _jenkinsResultsParserVersion = "1.0.1060";
	private final Project _project;
	private Object _testrayPropertiesFile = "testray.properties";

}