/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.gradle.plugins.defaults.internal.util;

import groovy.lang.Closure;

import org.gradle.util.VersionNumber;

/**
 * @author Andrea Di Giorgi
 */
@SuppressWarnings("serial")
public class IncrementVersionClosure extends Closure<String> {

	public static final IncrementVersionClosure MICRO_INCREMENT =
		new IncrementVersionClosure(0, 0, 1);

	public IncrementVersionClosure(
		int majorIncrement, int minorIncrement, int microIncrement) {

		super(null);

		_majorIncrement = majorIncrement;
		_minorIncrement = minorIncrement;
		_microIncrement = microIncrement;
	}

	public String doCall(String version) {
		VersionNumber versionNumber = VersionNumber.parse(version);

		VersionNumber newVersionNumber = new VersionNumber(
			versionNumber.getMajor() + _majorIncrement,
			versionNumber.getMinor() + _minorIncrement,
			versionNumber.getMicro() + _microIncrement,
			versionNumber.getQualifier());

		return newVersionNumber.toString();
	}

	private final int _majorIncrement;
	private final int _microIncrement;
	private final int _minorIncrement;

}