/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.tasks;

import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.util.Set;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.CollectionUtils;
import org.osgi.jmx.framework.BundleStateMBean;

public class CheckOSGiBundleStateTask
extends DefaultTask {
    private Object _bundleState = "ACTIVE";
    private Object _bundleSymbolicName;
    private Object _jmxHostName = "localhost";
    private Object _jmxPort = 8099;

    @TaskAction
    public void checkOSGiBundleState() throws Exception {
        Logger logger = this.getLogger();
        String bundleState = this.getBundleState();
        String bundleSymbolicName = this.getBundleSymbolicName();
        boolean singleBundle = Validator.isNotNull((String)bundleSymbolicName);
        JMXServiceURL jmxServiceURL = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this.getJmxHostName() + ":" + this.getJmxPort() + "/jmxrmi");
        try (JMXConnector jmxConnector = JMXConnectorFactory.connect(jmxServiceURL);){
            MBeanServerConnection mBeanServerConnection = jmxConnector.getMBeanServerConnection();
            Set<ObjectName> objectNames = mBeanServerConnection.queryNames(ObjectName.getInstance("osgi.core:type=bundleState,version=1.7,*"), null);
            BundleStateMBean bundleStateMBean = JMX.newMBeanProxy(mBeanServerConnection, (ObjectName)CollectionUtils.first(objectNames), BundleStateMBean.class);
            TabularData tabularData = bundleStateMBean.listBundles();
            for (Object object : tabularData.values()) {
                CompositeData compositeData = (CompositeData)object;
                boolean fragment = (Boolean)compositeData.get("Fragment");
                if (fragment) continue;
                String symbolicName = (String)compositeData.get("SymbolicName");
                if (singleBundle && !bundleSymbolicName.equals(symbolicName)) continue;
                String state = (String)compositeData.get("State");
                if (!bundleState.equals(state)) {
                    throw new GradleException("Bundle \"" + symbolicName + "\" is " + state + " while it should be " + bundleState);
                }
                if (!singleBundle) continue;
                return;
            }
        }
        if (singleBundle) {
            if (logger.isWarnEnabled()) {
                logger.warn("Bundle \"{}\" is a fragment or is not deployed", (Object)bundleSymbolicName);
            }
        } else if (logger.isInfoEnabled()) {
            logger.info("All non-fragment bundles have {} state", (Object)bundleState);
        }
    }

    @Input
    public String getBundleState() {
        return GradleUtil.toString((Object)this._bundleState);
    }

    @Input
    @Optional
    public String getBundleSymbolicName() {
        return GradleUtil.toString((Object)this._bundleSymbolicName);
    }

    @Input
    public String getJmxHostName() {
        return GradleUtil.toString((Object)this._jmxHostName);
    }

    @Input
    public int getJmxPort() {
        return GradleUtil.toInteger((Object)this._jmxPort);
    }

    public void setBundleState(Object bundleState) {
        this._bundleState = bundleState;
    }

    public void setBundleSymbolicName(Object bundleSymbolicName) {
        this._bundleSymbolicName = bundleSymbolicName;
    }

    public void setJmxHostName(Object jmxHostName) {
        this._jmxHostName = jmxHostName;
    }

    public void setJmxPort(Object jmxPort) {
        this._jmxPort = jmxPort;
    }
}

