/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.baseline.BaselinePlugin;
import com.liferay.gradle.plugins.baseline.BaselineTask;
import com.liferay.gradle.plugins.extensions.BundleExtension;
import com.liferay.gradle.plugins.util.BndUtil;
import com.liferay.gradle.util.Validator;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;

public class BaselineDefaultsPlugin
extends BaseDefaultsPlugin<BaselinePlugin> {
    public static final Plugin<Project> INSTANCE = new BaselineDefaultsPlugin();

    protected void applyPluginDefaults(Project project, BaselinePlugin baselinePlugin) {
        BundleExtension bundleExtension = BndUtil.getBundleExtension((ExtensionContainer)project.getExtensions());
        this._configureTasksBaseline(project, bundleExtension);
    }

    protected Class<BaselinePlugin> getPluginClass() {
        return BaselinePlugin.class;
    }

    private BaselineDefaultsPlugin() {
    }

    private void _configureTaskBaseline(final BundleExtension bundleExtension, BaselineTask baselineTask) {
        baselineTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                String exportPackage = bundleExtension.getInstruction("Export-Package");
                return Validator.isNotNull((String)exportPackage);
            }
        });
    }

    private void _configureTasksBaseline(Project project, final BundleExtension bundleExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BaselineTask.class, (Action)new Action<BaselineTask>(){

            public void execute(BaselineTask baselineTask) {
                BaselineDefaultsPlugin.this._configureTaskBaseline(bundleExtension, baselineTask);
            }
        });
    }
}

