/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.gradle.publish.PluginBundleExtension;
import com.gradle.publish.PluginConfig;
import com.gradle.publish.PublishPlugin;
import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.GradlePluginsDefaultsUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.internal.util.StringUtil;
import com.liferay.gradle.plugins.extensions.BundleExtension;
import com.liferay.gradle.plugins.util.BndUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.specs.Spec;
import org.gradle.util.GUtil;

public class PublishPluginDefaultsPlugin
extends BaseDefaultsPlugin<PublishPlugin> {
    public static final Plugin<Project> INSTANCE = new PublishPluginDefaultsPlugin();
    private static final String _BASE_URL = "https://github.com/liferay/liferay-portal/tree/master/modules/sdk/";
    private static final String _PUBLISH_PLUGINS_TASK_NAME = "publishPlugins";
    private static final Set<String> _defaultPluginBundleTags = Collections.singleton("liferay");

    protected void applyPluginDefaults(Project project, PublishPlugin publishPlugin) {
        BundleExtension bundleExtension = BndUtil.getBundleExtension((ExtensionContainer)project.getExtensions());
        this._configurePluginBundle(project, bundleExtension);
        this._configureTaskPublishPlugins(project);
        this._configureTaskPublish(project);
    }

    protected Class<PublishPlugin> getPluginClass() {
        return PublishPlugin.class;
    }

    private PublishPluginDefaultsPlugin() {
    }

    private void _configurePluginBundle(Project project, final BundleExtension bundleExtension) {
        File[] gradlePluginFiles;
        final PluginBundleExtension pluginBundleExtension = (PluginBundleExtension)GradleUtil.getExtension((ExtensionAware)project, PluginBundleExtension.class);
        NamedDomainObjectContainer pluginConfigs = pluginBundleExtension.getPlugins();
        File gradlePluginsDir = project.file((Object)"src/main/resources/META-INF/gradle-plugins");
        for (File gradlePluginFile : gradlePluginFiles = gradlePluginsDir.listFiles()) {
            String fileName = gradlePluginFile.getName();
            Properties properties = GUtil.loadProperties((File)gradlePluginFile);
            String className = properties.getProperty("implementation-class");
            String name = StringUtil.uncapitalize(className.substring(className.lastIndexOf(46) + 1));
            PluginConfig pluginConfig = (PluginConfig)pluginConfigs.create(name);
            if (gradlePluginFiles.length == 1) {
                pluginConfig.setDisplayName(bundleExtension.getInstruction("Bundle-Name"));
            }
            pluginConfig.setId(fileName.substring(0, fileName.length() - 11));
        }
        String url = _BASE_URL + project.getName();
        pluginBundleExtension.setVcsUrl(url);
        pluginBundleExtension.setWebsite(url);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                if (Validator.isNull((String)pluginBundleExtension.getDescription())) {
                    pluginBundleExtension.setDescription(bundleExtension.getInstruction("Bundle-Description"));
                }
                TreeSet pluginBundleTags = new TreeSet(pluginBundleExtension.getTags());
                pluginBundleTags.addAll(_defaultPluginBundleTags);
                pluginBundleExtension.setTags(pluginBundleTags);
                for (PluginConfig pluginConfig : pluginBundleExtension.getPlugins()) {
                    TreeSet pluginTags = new TreeSet(pluginConfig.getTags());
                    pluginConfig.setTags(pluginTags);
                }
            }
        });
    }

    private void _configureTaskPublish(Project project) {
        Task publishTask = GradleUtil.getTask((Project)project, (String)"publish");
        publishTask.dependsOn(new Object[]{_PUBLISH_PLUGINS_TASK_NAME});
    }

    private void _configureTaskPublishPlugins(Project project) {
        Task task = GradleUtil.getTask((Project)project, (String)_PUBLISH_PLUGINS_TASK_NAME);
        task.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return !GradlePluginsDefaultsUtil.isSnapshot(task.getProject());
            }
        });
    }
}

