/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.theme.westeros.bank.site.initializer.internal;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.dynamic.data.mapping.util.DefaultDDMStructureHelper;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.model.FragmentEntryModel;
import com.liferay.fragment.service.FragmentCollectionLocalService;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.util.LayoutCopyHelper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.site.exception.InitializationException;
import com.liferay.site.initializer.SiteInitializer;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"site.initializer.key=westeros-bank-site-initializer"}, service={SiteInitializer.class})
public class WesterosBankSiteInitializer
implements SiteInitializer {
    public static final String KEY = "westeros-bank-site-initializer";
    private static final String[] _LAYOUT_NAMES_CHILDREN_ASSURANCE = new String[]{"Travel Insurance", "Home insurance", "Life insurance"};
    private static final String[] _LAYOUT_NAMES_CHILDREN_BUSINESS = new String[]{"Credit Cards for Business", "Assurance for Business"};
    private static final String[] _LAYOUT_NAMES_CHILDREN_CHECKING = new String[]{"All credit cards", "Check your eligibility", "Balance-transfer credit cards", "Purchase credit card"};
    private static final String[] _LAYOUT_NAMES_CHILDREN_LOANS = new String[]{"Mortgages", "All mortgage products", "Mortgate rates and charges"};
    private static final String[] _LAYOUT_NAMES_CHILDREN_PERSONAL = new String[]{"Checking and Credit Cards", "Savings and Investments", "Loans and Mortgages", "Assurance"};
    private static final String[] _LAYOUT_NAMES_CHILDREN_SAVINGS = new String[]{"Compare Savings accounts", "Everyday Saver", "Children's Instant Saver", "All interest rates"};
    private static final String[] _LAYOUT_NAMES_FRAGMENT_KEYS = new String[]{"features", "links", "news", "offerings", "video"};
    private static final String _PATH = "com/liferay/frontend/theme/westeros/bank/site/initializer/internal/dependencies";
    private static final String _THEME_ID = "westerosbank_WAR_westerosbanktheme";
    private static final String _THEME_NAME = "Westeros Bank";
    private static final Log _log = LogFactoryUtil.getLog(WesterosBankSiteInitializer.class);
    private Bundle _bundle;
    @Reference
    private DefaultDDMStructureHelper _defaultDDMStructureHelper;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private FragmentCollectionLocalService _fragmentCollectionLocalService;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private LayoutCopyHelper _layoutCopyHelper;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateCollectionLocalService _layoutPageTemplateCollectionLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference(target="(osgi.web.symbolicname=com.liferay.frontend.theme.westeros.bank.site.initializer)")
    private ServletContext _servletContext;
    @Reference
    private ThemeLocalService _themeLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getDescription(Locale locale) {
        return "";
    }

    public String getKey() {
        return KEY;
    }

    public String getName(Locale locale) {
        return _THEME_NAME;
    }

    public String getThumbnailSrc() {
        return this._servletContext.getContextPath() + "/images/thumbnail.png";
    }

    public void initialize(long groupId) throws InitializationException {
        try {
            ServiceContext serviceContext = this._createServiceContext(groupId);
            this._updateLogo(serviceContext);
            this._updateLookAndFeel(serviceContext);
            List<FragmentEntry> fragmentEntries = this._addFragmentEntries(serviceContext);
            Map<String, FragmentEntry> fragmentEntriesMap = this._getFragmentEntriesMap(fragmentEntries);
            LayoutPageTemplateCollection layoutPageTemplateCollection = this._addLayoutPageTemplateCollection(serviceContext);
            ArrayList<FragmentEntry> personalFragmentEntries = new ArrayList<FragmentEntry>();
            personalFragmentEntries.add(fragmentEntriesMap.get("carousel"));
            personalFragmentEntries.add(fragmentEntriesMap.get("features"));
            personalFragmentEntries.add(fragmentEntriesMap.get("news"));
            personalFragmentEntries.add(fragmentEntriesMap.get("offerings"));
            personalFragmentEntries.add(fragmentEntriesMap.get("links"));
            LayoutPageTemplateEntry personalLayoutPageTemplate = this._addLayoutPageTemplateEntry(layoutPageTemplateCollection, "For You", personalFragmentEntries, "com/liferay/frontend/theme/westeros/bank/site/initializer/internal/dependencies/page_templates", "personal.jpg", serviceContext);
            Layout personalLayout = this._addParentLayout("For You", personalLayoutPageTemplate.getLayoutPageTemplateEntryId(), serviceContext);
            FragmentEntry carouselFragmentEntry = fragmentEntriesMap.get("carousel");
            JournalArticle carouselJournalArticle = this._addCarouselJournalArticle(serviceContext);
            TransactionCommitCallbackUtil.registerCallback(() -> {
                Layout draftLayout = this._layoutLocalService.fetchLayout(this._portal.getClassNameId(Layout.class), personalLayout.getPlid());
                this._configureFragmentEntryLink(serviceContext.getCompanyId(), serviceContext.getScopeGroupId(), draftLayout.getPlid(), carouselFragmentEntry.getFragmentEntryId(), carouselJournalArticle.getArticleId());
                this._copyLayout(personalLayout);
                this._layoutLocalService.updateStatus(serviceContext.getUserId(), personalLayout.getPlid(), 0, serviceContext);
                return null;
            });
            List<Layout> personalLayoutChildren = this._addLayouts(personalLayout, _LAYOUT_NAMES_CHILDREN_PERSONAL, fragmentEntriesMap, serviceContext);
            this._addLayouts(personalLayoutChildren.get(0), _LAYOUT_NAMES_CHILDREN_CHECKING, fragmentEntriesMap, serviceContext);
            this._addLayouts(personalLayoutChildren.get(1), _LAYOUT_NAMES_CHILDREN_SAVINGS, fragmentEntriesMap, serviceContext);
            this._addLayouts(personalLayoutChildren.get(2), _LAYOUT_NAMES_CHILDREN_LOANS, fragmentEntriesMap, serviceContext);
            this._addLayouts(personalLayoutChildren.get(3), _LAYOUT_NAMES_CHILDREN_ASSURANCE, fragmentEntriesMap, serviceContext);
            ArrayList<FragmentEntry> businessFragmentEntries = new ArrayList<FragmentEntry>();
            businessFragmentEntries.add(fragmentEntriesMap.get("video"));
            businessFragmentEntries.add(fragmentEntriesMap.get("links"));
            LayoutPageTemplateEntry businessLayoutPageTemplate = this._addLayoutPageTemplateEntry(layoutPageTemplateCollection, "For Your Business", businessFragmentEntries, "com/liferay/frontend/theme/westeros/bank/site/initializer/internal/dependencies/page_templates", "business.jpg", serviceContext);
            Layout businessLayout = this._addParentLayout("For Your Business", businessLayoutPageTemplate.getLayoutPageTemplateEntryId(), serviceContext);
            TransactionCommitCallbackUtil.registerCallback(() -> {
                this._copyLayout(businessLayout);
                this._layoutLocalService.updateStatus(serviceContext.getUserId(), businessLayout.getPlid(), 0, serviceContext);
                return null;
            });
            this._addLayouts(businessLayout, _LAYOUT_NAMES_CHILDREN_BUSINESS, fragmentEntriesMap, serviceContext);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new InitializationException((Throwable)exception);
        }
    }

    public boolean isActive(long companyId) {
        return true;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundle = bundleContext.getBundle();
    }

    private Map<String, String> _addCarouselFileEntriesMap(ServiceContext serviceContext) throws Exception {
        HashMap<String, String> fileEntriesMap = new HashMap<String, String>();
        Folder folder = this._dlAppLocalService.addFolder(serviceContext.getUserId(), serviceContext.getScopeGroupId(), 0L, _THEME_NAME, "", serviceContext);
        Enumeration urls = this._bundle.findEntries("com/liferay/frontend/theme/westeros/bank/site/initializer/internal/dependencies/carousel", "*", false);
        while (urls.hasMoreElements()) {
            URL url = (URL)urls.nextElement();
            byte[] bytes = null;
            try (InputStream is = url.openStream();){
                bytes = FileUtil.getBytes((InputStream)is);
            }
            String fileName = FileUtil.getShortFileName((String)url.getPath());
            FileEntry fileEntry = this._dlAppLocalService.addFileEntry(serviceContext.getUserId(), serviceContext.getScopeGroupId(), folder.getFolderId(), fileName, null, fileName, "", "", bytes, serviceContext);
            fileEntriesMap.put(fileEntry.getFileName(), JSONFactoryUtil.looseSerialize((Object)fileEntry));
        }
        return fileEntriesMap;
    }

    private JournalArticle _addCarouselJournalArticle(ServiceContext serviceContext) throws Exception {
        Class<?> clazz = this.getClass();
        this._defaultDDMStructureHelper.addDDMStructures(serviceContext.getUserId(), serviceContext.getScopeGroupId(), this._portal.getClassNameId(JournalArticle.class), clazz.getClassLoader(), "com/liferay/frontend/theme/westeros/bank/site/initializer/internal/dependencies/ddm/carousel.xml", serviceContext);
        URL carouselContentURL = this._bundle.getEntry("com/liferay/frontend/theme/westeros/bank/site/initializer/internal/dependencies/ddm/content/carousel.xml");
        Map<String, String> fileEntriesMap = this._addCarouselFileEntriesMap(serviceContext);
        String content = StringUtil.replace((String)StringUtil.read((InputStream)carouselContentURL.openStream()), (String)"$", (String)"$", fileEntriesMap);
        return this._journalArticleLocalService.addArticle(serviceContext.getUserId(), serviceContext.getScopeGroupId(), 0L, Collections.singletonMap(LocaleUtil.US, "Carousel"), null, content, "CAROUSEL", "CAROUSEL", serviceContext);
    }

    private void _addFileEntries(long fragmentCollectionId, long folderId, ServiceContext serviceContext) throws Exception {
        Enumeration urls = this._bundle.findEntries("com/liferay/frontend/theme/westeros/bank/site/initializer/internal/dependencies/images", "*", false);
        while (urls.hasMoreElements()) {
            URL url = (URL)urls.nextElement();
            byte[] bytes = null;
            try (InputStream is = url.openStream();){
                bytes = FileUtil.getBytes((InputStream)is);
            }
            String fileName = FileUtil.getShortFileName((String)url.getPath());
            this._portletFileRepository.addPortletFileEntry(serviceContext.getScopeGroupId(), serviceContext.getUserId(), FragmentCollection.class.getName(), fragmentCollectionId, "com_liferay_fragment_web_portlet_FragmentPortlet", folderId, bytes, fileName, MimeTypesUtil.getContentType((String)fileName), false);
        }
    }

    private List<FragmentEntry> _addFragmentEntries(ServiceContext serviceContext) throws Exception {
        ArrayList<FragmentEntry> fragmentEntries = new ArrayList<FragmentEntry>();
        FragmentCollection fragmentCollection = this._fragmentCollectionLocalService.addFragmentCollection(serviceContext.getUserId(), serviceContext.getScopeGroupId(), _THEME_NAME, null, serviceContext);
        this._addFileEntries(fragmentCollection.getFragmentCollectionId(), fragmentCollection.getResourcesFolderId(), serviceContext);
        Enumeration urls = this._bundle.findEntries("com/liferay/frontend/theme/westeros/bank/site/initializer/internal/dependencies/fragments", "*.html", false);
        while (urls.hasMoreElements()) {
            URL url = (URL)urls.nextElement();
            String fileName = FileUtil.getShortFileName((String)url.getPath());
            String filePath = FileUtil.getPath((String)url.getPath());
            url = this._bundle.getEntry(filePath + "/" + fileName);
            String shortFileName = FileUtil.getShortFileName((String)url.getPath());
            String fragmentEntryId = FileUtil.stripExtension((String)shortFileName);
            String fragmentEntryName = StringUtil.upperCaseFirstLetter((String)fragmentEntryId);
            StringBundler sb = new StringBundler(4);
            sb.append(filePath);
            sb.append("/");
            sb.append(fragmentEntryId);
            sb.append(".css");
            URL cssURL = this._bundle.getEntry(sb.toString());
            FragmentEntry fragmentEntry = this._fragmentEntryLocalService.addFragmentEntry(serviceContext.getUserId(), serviceContext.getScopeGroupId(), fragmentCollection.getFragmentCollectionId(), null, fragmentEntryName, StringUtil.read((InputStream)cssURL.openStream()), StringUtil.read((InputStream)url.openStream()), "", "", 0L, 0, 0, serviceContext);
            long fragmentEntryPreviewFileEntryId = this._getPreviewFileEntryId("com_liferay_fragment_web_portlet_FragmentPortlet", FragmentEntry.class.getName(), fragmentEntry.getFragmentEntryId(), filePath, fragmentEntryId + ".jpg", serviceContext);
            fragmentEntry = this._fragmentEntryLocalService.updateFragmentEntry(fragmentEntry.getFragmentEntryId(), fragmentEntryPreviewFileEntryId);
            fragmentEntries.add(fragmentEntry);
        }
        return fragmentEntries;
    }

    private LayoutPageTemplateCollection _addLayoutPageTemplateCollection(ServiceContext serviceContext) throws PortalException {
        return this._layoutPageTemplateCollectionLocalService.addLayoutPageTemplateCollection(serviceContext.getUserId(), serviceContext.getScopeGroupId(), _THEME_NAME, _THEME_NAME, serviceContext);
    }

    private LayoutPageTemplateEntry _addLayoutPageTemplateEntry(LayoutPageTemplateCollection layoutPageTemplateCollection, String name, List<FragmentEntry> fragmentEntries, String thumbnailPath, String thumbnailFileName, ServiceContext serviceContext) throws Exception {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.addLayoutPageTemplateEntry(serviceContext.getUserId(), serviceContext.getScopeGroupId(), layoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), name, 0, 0, serviceContext);
        long previewFileEntryId = this._getPreviewFileEntryId("com_liferay_layout_admin_web_portlet_GroupPagesPortlet", LayoutPageTemplateEntry.class.getName(), layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), thumbnailPath, thumbnailFileName, serviceContext);
        layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), previewFileEntryId);
        long[] fragmentEntryIds = ListUtil.toLongArray(fragmentEntries, FragmentEntryModel::getFragmentEntryId);
        return this._layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), name, fragmentEntryIds, "", serviceContext);
    }

    private List<Layout> _addLayouts(Layout parentLayout, String[] layoutNames, Map<String, FragmentEntry> fragmentEntriesMap, ServiceContext serviceContext) throws Exception {
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        Random random = new Random();
        for (String layoutName : layoutNames) {
            HashMap nameMap = HashMapBuilder.put((Object)LocaleUtil.getSiteDefault(), (Object)layoutName).build();
            Layout layout = this._layoutLocalService.addLayout(serviceContext.getUserId(), serviceContext.getScopeGroupId(), false, parentLayout.getLayoutId(), (Map)nameMap, new HashMap(), new HashMap(), new HashMap(), new HashMap(), "content", "", false, new HashMap(), serviceContext);
            int fragmentKeyId = random.nextInt(_LAYOUT_NAMES_FRAGMENT_KEYS.length);
            FragmentEntry fragmentEntry = fragmentEntriesMap.get(_LAYOUT_NAMES_FRAGMENT_KEYS[fragmentKeyId]);
            this._fragmentEntryLinkLocalService.updateFragmentEntryLinks(serviceContext.getUserId(), serviceContext.getScopeGroupId(), this._portal.getClassNameId(Layout.class), layout.getPlid(), new long[]{fragmentEntry.getFragmentEntryId()}, "", serviceContext);
            this._layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), new Date());
            layouts.add(layout);
        }
        return layouts;
    }

    private Layout _addParentLayout(String name, long layoutPageTemplateEntryId, ServiceContext serviceContext) throws Exception {
        HashMap nameMap = HashMapBuilder.put((Object)LocaleUtil.getSiteDefault(), (Object)name).build();
        return this._layoutLocalService.addLayout(serviceContext.getUserId(), serviceContext.getScopeGroupId(), false, 0L, this._portal.getClassNameId(LayoutPageTemplateEntry.class), layoutPageTemplateEntryId, (Map)nameMap, new HashMap(), new HashMap(), new HashMap(), new HashMap(), "content", null, false, false, new HashMap(), serviceContext);
    }

    private void _configureFragmentEntryLink(long companyId, long groupId, long plid, long fragmentEntryId, String articleId) throws Exception {
        List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinks(groupId, this._portal.getClassNameId(Layout.class), plid);
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            if (fragmentEntryLink.getFragmentEntryId() != fragmentEntryId) continue;
            PortletPreferencesImpl jxPortletPreferences = new PortletPreferencesImpl();
            jxPortletPreferences.setValue("articleId", articleId);
            jxPortletPreferences.setValue("portletSetupPortletDecoratorId", "barebone");
            String portletId = PortletIdCodec.encode((String)"com_liferay_journal_content_web_portlet_JournalContentPortlet", (String)fragmentEntryLink.getNamespace());
            PortletPreferences portletPreferences = this._portletPreferencesLocalService.fetchPortletPreferences(0L, 3, plid, portletId);
            if (portletPreferences == null) {
                this._portletPreferencesLocalService.addPortletPreferences(companyId, 0L, 3, plid, portletId, null, PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)jxPortletPreferences));
                continue;
            }
            this._portletPreferencesLocalService.updatePreferences(0L, 3, plid, portletId, (javax.portlet.PortletPreferences)jxPortletPreferences);
        }
    }

    private void _copyLayout(Layout layout) throws Exception {
        Layout draftLayout = this._layoutLocalService.fetchLayout(this._portal.getClassNameId(Layout.class), layout.getPlid());
        if (draftLayout != null) {
            this._layoutCopyHelper.copyLayout(draftLayout, layout);
        }
    }

    private ServiceContext _createServiceContext(long groupId) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Group group = this._groupLocalService.getGroup(groupId);
        serviceContext.setCompanyId(group.getCompanyId());
        User user = this._userLocalService.getUser(PrincipalThreadLocal.getUserId());
        Locale locale = LocaleUtil.getSiteDefault();
        serviceContext.setLanguageId(LanguageUtil.getLanguageId((Locale)locale));
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setTimeZone(user.getTimeZone());
        serviceContext.setUserId(user.getUserId());
        return serviceContext;
    }

    private Map<String, FragmentEntry> _getFragmentEntriesMap(List<FragmentEntry> fragmentEntries) {
        HashMap<String, FragmentEntry> fragmentEntriesMap = new HashMap<String, FragmentEntry>();
        for (FragmentEntry fragmentEntry : fragmentEntries) {
            fragmentEntriesMap.put(StringUtil.toLowerCase((String)fragmentEntry.getName()), fragmentEntry);
        }
        return fragmentEntriesMap;
    }

    private long _getPreviewFileEntryId(String portletId, String className, long classPK, String path, String fileName, ServiceContext serviceContext) throws Exception {
        StringBundler sb = new StringBundler(3);
        sb.append(path);
        sb.append("/");
        sb.append(fileName);
        URL url = this._bundle.getEntry(sb.toString());
        if (url == null) {
            return 0L;
        }
        Repository repository = this._portletFileRepository.fetchPortletRepository(serviceContext.getScopeGroupId(), portletId);
        if (repository == null) {
            repository = this._portletFileRepository.addPortletRepository(serviceContext.getScopeGroupId(), portletId, serviceContext);
        }
        String imageFileName = classPK + "_preview." + FileUtil.getExtension((String)url.getPath());
        byte[] bytes = null;
        try (InputStream is = url.openStream();){
            bytes = FileUtil.getBytes((InputStream)is);
        }
        FileEntry fileEntry = this._portletFileRepository.addPortletFileEntry(serviceContext.getScopeGroupId(), serviceContext.getUserId(), className, classPK, portletId, repository.getDlFolderId(), bytes, imageFileName, MimeTypesUtil.getContentType((String)imageFileName), false);
        return fileEntry.getFileEntryId();
    }

    private void _updateLogo(ServiceContext serviceContext) throws Exception {
        URL url = this._bundle.getEntry("com/liferay/frontend/theme/westeros/bank/site/initializer/internal/dependencies/images/logo.png");
        byte[] bytes = null;
        try (InputStream is = url.openStream();){
            bytes = FileUtil.getBytes((InputStream)is);
        }
        this._layoutSetLocalService.updateLogo(serviceContext.getScopeGroupId(), false, true, bytes);
    }

    private void _updateLookAndFeel(ServiceContext serviceContext) throws PortalException {
        Theme theme = this._themeLocalService.fetchTheme(serviceContext.getCompanyId(), _THEME_ID);
        if (theme == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"No theme found for westerosbank_WAR_westerosbanktheme");
            }
            return;
        }
        this._layoutSetLocalService.updateLookAndFeel(serviceContext.getScopeGroupId(), _THEME_ID, "", "");
    }
}

