/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.theme.contributor.extender.internal.servlet.taglib;

import com.liferay.frontend.theme.contributor.extender.internal.BundleWebResources;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.servlet.taglib.DynamicInclude;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={DynamicInclude.class})
public class ThemeContributorTopHeadDynamicInclude
implements DynamicInclude {
    private BundleContext _bundleContext;
    private final Collection<ServiceReference<BundleWebResources>> _bundleWebResourcesServiceReferences = new TreeSet<ServiceReference<BundleWebResources>>();
    private String _comboContextPath;
    private volatile String[] _cssResourceURLs = StringPool.EMPTY_ARRAY;
    private volatile String[] _jsResourceURLs = StringPool.EMPTY_ARRAY;
    private volatile String _mergedCSSResourceURLs;
    private volatile String _mergedJSResourceURLs;
    private Portal _portal;

    public void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String key) throws IOException {
        long themeLastModified = PortalWebResourcesUtil.getLastModified((String)"theme_contributor");
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portalCDNURL = themeDisplay.getCDNBaseURL();
        if (!this._portal.isCDNDynamicResourcesEnabled(themeDisplay.getCompanyId())) {
            portalCDNURL = themeDisplay.getPortalURL();
        }
        if (this._cssResourceURLs.length > 0) {
            if (themeDisplay.isThemeCssFastLoad()) {
                this._renderComboCSS(themeLastModified, httpServletRequest, portalCDNURL, httpServletResponse.getWriter());
            } else {
                this._renderSimpleCSS(themeLastModified, httpServletRequest, portalCDNURL, httpServletResponse.getWriter(), this._cssResourceURLs);
            }
        }
        if (this._jsResourceURLs.length == 0) {
            return;
        }
        if (themeDisplay.isThemeJsFastLoad()) {
            this._renderComboJS(themeLastModified, httpServletRequest, portalCDNURL, httpServletResponse.getWriter());
        } else {
            this._renderSimpleJS(themeLastModified, httpServletRequest, portalCDNURL, httpServletResponse.getWriter(), this._jsResourceURLs);
        }
    }

    public void register(DynamicInclude.DynamicIncludeRegistry dynamicIncludeRegistry) {
        dynamicIncludeRegistry.register("/html/common/themes/top_head.jsp#post");
    }

    @Reference(unbind="-")
    public void setPortal(Portal portal) {
        String pathContext = portal.getPathContext();
        this._comboContextPath = pathContext.concat("/combo");
        this._portal = portal;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._rebuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addBundleWebResources(ServiceReference<BundleWebResources> bundleWebResourcesServiceReference) {
        Collection<ServiceReference<BundleWebResources>> collection = this._bundleWebResourcesServiceReferences;
        synchronized (collection) {
            this._bundleWebResourcesServiceReferences.add(bundleWebResourcesServiceReference);
            this._rebuild();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeBundleWebResources(ServiceReference<BundleWebResources> bundleWebResourcesServiceReference) {
        Collection<ServiceReference<BundleWebResources>> collection = this._bundleWebResourcesServiceReferences;
        synchronized (collection) {
            this._bundleWebResourcesServiceReferences.remove(bundleWebResourcesServiceReference);
            this._rebuild();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _rebuild() {
        if (this._bundleContext == null) {
            return;
        }
        ArrayList<String> cssResourceURLs = new ArrayList<String>();
        ArrayList<String> jsResourceURLs = new ArrayList<String>();
        for (ServiceReference<BundleWebResources> bundleWebResourcesServiceReference : this._bundleWebResourcesServiceReferences) {
            BundleWebResources bundleWebResources = (BundleWebResources)this._bundleContext.getService(bundleWebResourcesServiceReference);
            try {
                String servletContextPath = bundleWebResources.getServletContextPath();
                for (String cssResourcePath : bundleWebResources.getCssResourcePaths()) {
                    cssResourceURLs.add(servletContextPath.concat(cssResourcePath));
                }
                for (String jsResourcePath : bundleWebResources.getJsResourcePaths()) {
                    jsResourceURLs.add(servletContextPath.concat(jsResourcePath));
                }
            }
            finally {
                this._bundleContext.ungetService(bundleWebResourcesServiceReference);
            }
        }
        this._cssResourceURLs = cssResourceURLs.toArray(new String[0]);
        StringBundler sb = new StringBundler(cssResourceURLs.size() * 2 + 1);
        for (String cssResourceURL : cssResourceURLs) {
            sb.append("&");
            sb.append(cssResourceURL);
        }
        sb.append("\" rel=\"stylesheet\" type = \"text/css\" />\n");
        this._mergedCSSResourceURLs = sb.toString();
        this._jsResourceURLs = jsResourceURLs.toArray(new String[0]);
        sb = new StringBundler(jsResourceURLs.size() * 2 + 1);
        for (String jsResourceURL : jsResourceURLs) {
            sb.append("&");
            sb.append(jsResourceURL);
        }
        sb.append("\" type = \"text/javascript\"></script>\n");
        this._mergedJSResourceURLs = sb.toString();
    }

    private void _renderComboCSS(long themeLastModified, HttpServletRequest httpServletRequest, String portalURL, PrintWriter printWriter) {
        printWriter.write("<link data-senna-track=\"permanent\" href=\"");
        String staticResourceURL = this._portal.getStaticResourceURL(httpServletRequest, this._comboContextPath, "minifierType=css", themeLastModified);
        printWriter.write(portalURL + staticResourceURL);
        printWriter.write(this._mergedCSSResourceURLs);
    }

    private void _renderComboJS(long themeLastModified, HttpServletRequest httpServletRequest, String portalURL, PrintWriter printWriter) {
        printWriter.write("<script data-senna-track=\"permanent\" src=\"");
        String staticResourceURL = this._portal.getStaticResourceURL(httpServletRequest, this._comboContextPath, "minifierType=js", themeLastModified);
        printWriter.write(portalURL + staticResourceURL);
        printWriter.write(this._mergedJSResourceURLs);
    }

    private void _renderSimpleCSS(long themeLastModified, HttpServletRequest httpServletRequest, String portalURL, PrintWriter printWriter, String[] resourceURLs) {
        for (String resourceURL : resourceURLs) {
            String staticResourceURL = this._portal.getStaticResourceURL(httpServletRequest, StringBundler.concat((String[])new String[]{portalURL, this._portal.getPathProxy(), resourceURL}), themeLastModified);
            printWriter.write("<link data-senna-track=\"permanent\" href=\"");
            printWriter.write(staticResourceURL);
            printWriter.write("\" rel=\"stylesheet\" type = \"text/css\" />\n");
        }
    }

    private void _renderSimpleJS(long themeLastModified, HttpServletRequest httpServletRequest, String portalURL, PrintWriter printWriter, String[] resourceURLs) {
        for (String resourceURL : resourceURLs) {
            String staticResourceURL = this._portal.getStaticResourceURL(httpServletRequest, StringBundler.concat((String[])new String[]{portalURL, this._portal.getPathProxy(), resourceURL}), themeLastModified);
            printWriter.write("<script data-senna-track=\"permanent\" src=\"");
            printWriter.write(staticResourceURL);
            printWriter.write("\" type = \"text/javascript\"></script>\n");
        }
    }
}

