/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.top.head.extender.internal.osgi.util.tracker;

import com.liferay.frontend.js.top.head.extender.TopHeadResources;
import com.liferay.frontend.js.top.head.extender.internal.TopHeadResourcesImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={})
public class TopHeadExtender
implements ServiceTrackerCustomizer<ServletContext, ServiceRegistration<TopHeadResources>> {
    private BundleContext _bundleContext;
    private ServiceTracker<ServletContext, ServiceRegistration<TopHeadResources>> _serviceTracker;

    public ServiceRegistration<TopHeadResources> addingService(ServiceReference<ServletContext> serviceReference) {
        Bundle bundle = serviceReference.getBundle();
        Dictionary headers = bundle.getHeaders("");
        Map.Entry<List<String>, List<String>> entry = this._scanTopHeadResources(headers);
        if (entry == null) {
            return null;
        }
        ServletContext servletContext = (ServletContext)this._bundleContext.getService(serviceReference);
        return this._bundleContext.registerService(TopHeadResources.class, (Object)new TopHeadResourcesImpl(servletContext.getContextPath(), (Collection<String>)entry.getKey(), (Collection<String>)entry.getValue()), MapUtil.singletonDictionary((Object)"service.ranking", (Object)GetterUtil.getInteger((String)((String)headers.get("Liferay-Top-Head-Weight")))));
    }

    public void modifiedService(ServiceReference<ServletContext> serviceReference, ServiceRegistration<TopHeadResources> serviceRegistration) {
    }

    public void removedService(ServiceReference<ServletContext> serviceReference, ServiceRegistration<TopHeadResources> serviceRegistration) {
        serviceRegistration.unregister();
        this._bundleContext.ungetService(serviceReference);
    }

    @Activate
    protected void activate(BundleContext bundleContext) throws InvalidSyntaxException {
        this._bundleContext = bundleContext;
        this._serviceTracker = new ServiceTracker(bundleContext, bundleContext.createFilter(StringBundler.concat((String[])new String[]{"(&(objectClass=", ServletContext.class.getName(), ")(osgi.web.symbolicname=*))"})), (ServiceTrackerCustomizer)this);
        this._serviceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private Map.Entry<List<String>, List<String>> _scanTopHeadResources(Dictionary<String, String> headers) {
        String liferayJsResourcesTopHead = headers.get("Liferay-JS-Resources-Top-Head");
        String liferayJsResourcesTopHeadAuthenticated = headers.get("Liferay-JS-Resources-Top-Head-Authenticated");
        if (Validator.isBlank((String)liferayJsResourcesTopHead) && Validator.isBlank((String)liferayJsResourcesTopHeadAuthenticated)) {
            return null;
        }
        List<Object> jsResourcePaths = null;
        jsResourcePaths = Validator.isNull((String)liferayJsResourcesTopHead) ? Collections.emptyList() : Arrays.asList(liferayJsResourcesTopHead.split(","));
        List<Object> authenticatedJsResourcePaths = null;
        authenticatedJsResourcePaths = Validator.isNull((String)liferayJsResourcesTopHeadAuthenticated) ? Collections.emptyList() : Arrays.asList(liferayJsResourcesTopHeadAuthenticated.split(","));
        return new AbstractMap.SimpleImmutableEntry<List<String>, List<String>>(jsResourcePaths, authenticatedJsResourcePaths);
    }
}

