/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.portlet.extender.internal.portlet.action;

import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.values.factory.DDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletExtenderConfigurationAction
extends DefaultConfigurationAction {
    private static final String _TPL_CONFIGURATION_FORM;
    private static final Log _log;
    private final DDMForm _ddmForm;
    private final Map<String, DDMFormField> _ddmFormFieldsMap;
    private final DDMFormRenderer _ddmFormRenderer;
    private final DDMFormValuesFactory _ddmFormValuesFactory;
    private final Set<String> _fieldNames = new HashSet<String>();
    private final JSONObject _preferencesJSONObject;

    public PortletExtenderConfigurationAction(DDM ddm, DDMFormRenderer ddmFormRenderer, DDMFormValuesFactory ddmFormValuesFactory, JSONObject preferencesJSONObject) throws PortalException {
        this._ddmFormRenderer = ddmFormRenderer;
        this._ddmFormValuesFactory = ddmFormValuesFactory;
        this._preferencesJSONObject = preferencesJSONObject;
        this._ddmForm = ddm.getDDMForm(preferencesJSONObject.toJSONString());
        this._ddmFormFieldsMap = this._ddmForm.getDDMFormFieldsMap(true);
        this._populateFieldNames();
    }

    public void include(PortletConfig portletConfig, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        PrintWriter printWriter = httpServletResponse.getWriter();
        JSONArray fieldsJSONArray = this._preferencesJSONObject.getJSONArray("fields");
        printWriter.println(StringUtil.replace((String)_TPL_CONFIGURATION_FORM, (String[])new String[]{"[$ACTION_URL$]", "[$CONSTANTS_CMD$]", "[$CONSTANTS_UPDATE$]", "[$CURRENT_TIME_MILLIS$]", "[$DDM_FORM_HTML$]", "[$FIELDS_JSON_ARRAY$]", "[$PORTLET_NAMESPACE$]", "[$SAVE_LABEL$]"}, (String[])new String[]{this._getActionURL(httpServletRequest, portletDisplay), "cmd", "update", String.valueOf(System.currentTimeMillis()), this._ddmFormRenderer.render(this._ddmForm, this._createDDMFormRenderingContext(httpServletRequest, httpServletResponse)), fieldsJSONArray.toString(), portletDisplay.getNamespace(), LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"save")}));
    }

    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        DDMFormValues ddmFormValues = this._ddmFormValuesFactory.create((PortletRequest)actionRequest, this._ddmForm);
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        for (Map.Entry entry : ddmFormFieldValuesMap.entrySet()) {
            List ddmFormFieldValues = (List)entry.getValue();
            Stream stream = ddmFormFieldValues.stream();
            DDMFormField ddmFormField = this._ddmFormFieldsMap.get(entry.getKey());
            String ddmFormFieldType = ddmFormField.getType();
            String[] values = (String[])stream.map(ddmFormFieldValue -> {
                Value value = ddmFormFieldValue.getValue();
                String stringValue = value.getString(value.getDefaultLocale());
                if (ddmFormFieldType.equals("select")) {
                    stringValue = StringUtil.removeSubstring((String)stringValue, (String)"[\"");
                    stringValue = StringUtil.removeSubstring((String)stringValue, (String)"\"]");
                }
                return stringValue;
            }).toArray(String[]::new);
            this.setPreference((PortletRequest)actionRequest, (String)entry.getKey(), values);
        }
        super.processAction(portletConfig, actionRequest, actionResponse);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String _loadTemplate(String name) {
        try (InputStream inputStream = PortletExtenderConfigurationAction.class.getResourceAsStream("dependencies/" + name);){
            String string = StringUtil.read((InputStream)inputStream);
            return string;
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to read template " + name), (Throwable)exception);
            return "";
        }
    }

    private DDMFormRenderingContext _createDDMFormRenderingContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
        ddmFormRenderingContext.setHttpServletRequest(httpServletRequest);
        ddmFormRenderingContext.setHttpServletResponse(httpServletResponse);
        Set availableLocales = this._ddmForm.getAvailableLocales();
        Locale locale = this._ddmForm.getDefaultLocale();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (availableLocales.contains(themeDisplay.getLocale())) {
            locale = themeDisplay.getLocale();
        }
        ddmFormRenderingContext.setLocale(locale);
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        ddmFormRenderingContext.setPortletNamespace(portletDisplay.getNamespace());
        ddmFormRenderingContext.setReadOnly(false);
        this._setDDMFormValues(ddmFormRenderingContext, themeDisplay);
        return ddmFormRenderingContext;
    }

    private LocalizedValue _createLocalizedValue(String fieldName, String value, Locale locale) {
        LocalizedValue localizedValue = new LocalizedValue(locale);
        DDMFormField ddmFormField = this._ddmFormFieldsMap.get(fieldName);
        String ddmFormFieldType = ddmFormField.getType();
        if (ddmFormFieldType.equals("select")) {
            localizedValue.addString(locale, "[\"" + value + "\"]");
        } else {
            localizedValue.addString(locale, value);
        }
        return localizedValue;
    }

    private String _getActionURL(HttpServletRequest httpServletRequest, PortletDisplay portletDisplay) throws Exception {
        LiferayPortletURL actionURL = PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)portletDisplay.getPortletName(), (String)"ACTION_PHASE");
        actionURL.setParameter("javax.portlet.action", "editConfiguration");
        actionURL.setParameter("mvcPath", "/edit_configuration.jsp");
        actionURL.setParameter("p_auth", AuthTokenUtil.getToken((HttpServletRequest)httpServletRequest));
        actionURL.setParameter("p_p_mode", PortletMode.VIEW.toString());
        actionURL.setParameter("portletConfiguration", Boolean.TRUE.toString());
        actionURL.setParameter("portletResource", portletDisplay.getPortletResource());
        actionURL.setParameter("previewWidth", "");
        actionURL.setParameter("returnToFullPageURL", "/");
        actionURL.setParameter("settingsScope", "portletInstance");
        actionURL.setWindowState(LiferayWindowState.POP_UP);
        return actionURL.toString();
    }

    private void _populateFieldNames() {
        JSONArray fieldsJSONArray = this._preferencesJSONObject.getJSONArray("fields");
        for (int i = 0; i < fieldsJSONArray.length(); ++i) {
            JSONObject fieldJSONObject = fieldsJSONArray.getJSONObject(i);
            this._fieldNames.add(fieldJSONObject.getString("name"));
        }
    }

    private void _setDDMFormValues(DDMFormRenderingContext ddmFormRenderingContext, ThemeDisplay themeDisplay) throws Exception {
        DDMFormValues ddmFormValues = new DDMFormValues(this._ddmForm);
        Locale locale = this._ddmForm.getDefaultLocale();
        ddmFormValues.addAvailableLocale(locale);
        ddmFormValues.setDefaultLocale(locale);
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getExistingPortletSetup((Layout)themeDisplay.getLayout(), (String)portletDisplay.getPortletResource());
        Map portletPreferencesMap = portletPreferences.getMap();
        for (Map.Entry entry : portletPreferencesMap.entrySet()) {
            String fieldName = (String)entry.getKey();
            if (!this._ddmFormFieldsMap.containsKey(fieldName)) continue;
            for (String value : (String[])entry.getValue()) {
                DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
                ddmFormFieldValue.setName(fieldName);
                ddmFormFieldValue.setValue((Value)this._createLocalizedValue(fieldName, value, locale));
                ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
            }
        }
        ddmFormRenderingContext.setDDMFormValues(ddmFormValues);
    }

    static {
        _log = LogFactoryUtil.getLog(PortletExtenderConfigurationAction.class);
        _TPL_CONFIGURATION_FORM = PortletExtenderConfigurationAction._loadTemplate("configuration_form.html.tpl");
    }
}

