/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.portlet.extender;

import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.form.values.factory.DDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.frontend.js.portlet.extender.internal.portlet.JSPortlet;
import com.liferay.frontend.js.portlet.extender.internal.portlet.action.PortletExtenderConfigurationAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.Portlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(immediate=true, service={JSPortletExtender.class})
public class JSPortletExtender {
    private static final Log _log = LogFactoryUtil.getLog(JSPortletExtender.class);
    private BundleTracker<ServiceRegistration<?>> _bundleTracker;
    private BundleTrackerCustomizer<ServiceRegistration<?>> _bundleTrackerCustomizer = new BundleTrackerCustomizer<ServiceRegistration<?>>(){

        public ServiceRegistration<?> addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            if (!JSPortletExtender._optIn(bundle)) {
                return null;
            }
            JSONObject packageJSONObject = JSPortletExtender.this._parse(bundle.getEntry("META-INF/resources/package.json"));
            if (packageJSONObject == null) {
                return null;
            }
            BundleContext bundleContext = bundle.getBundleContext();
            HashSet<String> portletPreferencesFieldNames = new HashSet<String>();
            JSONObject portletPreferencesJSONObject = JSPortletExtender.this._parse(bundle.getEntry("features/portlet_preferences.json"));
            if (portletPreferencesJSONObject != null) {
                JSONArray fieldsJSONArray = portletPreferencesJSONObject.getJSONArray("fields");
                for (int i = 0; i < fieldsJSONArray.length(); ++i) {
                    JSONObject jsonObject = fieldsJSONArray.getJSONObject(i);
                    portletPreferencesFieldNames.add(jsonObject.getString("name"));
                }
            }
            ServiceRegistration serviceRegistration = JSPortletExtender.this._registerJSPortletService(bundleContext, packageJSONObject, portletPreferencesFieldNames);
            if (portletPreferencesJSONObject != null) {
                JSPortletExtender.this._registerConfigurationActionService(bundleContext, packageJSONObject, portletPreferencesJSONObject);
            }
            return serviceRegistration;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, ServiceRegistration<?> serviceRegistration) {
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, ServiceRegistration<?> serviceRegistration) {
            serviceRegistration.unregister();
        }
    };
    @Reference
    private DDM _ddm;
    @Reference
    private DDMFormRenderer _ddmFormRenderer;
    @Reference
    private DDMFormValuesFactory _ddmFormValuesFactory;
    @Reference
    private JSONFactory _jsonFactory;

    @Activate
    protected void activate(BundleContext context) {
        this._bundleTracker = new BundleTracker(context, 32, this._bundleTrackerCustomizer);
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
        this._bundleTracker = null;
    }

    private static boolean _optIn(Bundle bundle) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        List bundleWires = bundleWiring.getRequiredWires("osgi.extender");
        for (BundleWire bundleWire : bundleWires) {
            BundleCapability bundleCapability = bundleWire.getCapability();
            Map attributes = bundleCapability.getAttributes();
            Object value = attributes.get("osgi.extender");
            if (value == null || !value.equals("liferay.frontend.js.portlet")) continue;
            return true;
        }
        return false;
    }

    private void _addServiceProperties(Dictionary<String, Object> properties, JSONObject portletJSONObject) {
        if (portletJSONObject == null) {
            return;
        }
        Iterator keys = portletJSONObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = portletJSONObject.get(key);
            if (value instanceof JSONObject) {
                String stringValue = value.toString();
                properties.put(key, stringValue);
                continue;
            }
            if (value instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)value;
                ArrayList<String> values = new ArrayList<String>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Object object = jsonArray.get(i);
                    values.add(object.toString());
                }
                properties.put(key, values.toArray(new String[0]));
                continue;
            }
            properties.put(key, value);
        }
    }

    private String _getPortletName(JSONObject packageJSONObject) {
        String portletName = packageJSONObject.getString("name");
        JSONObject portletJSONObject = packageJSONObject.getJSONObject("portlet");
        String javaxPortletName = portletJSONObject.getString("javax.portlet.name");
        if (Validator.isNotNull((String)javaxPortletName)) {
            portletName = javaxPortletName;
        }
        return portletName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject _parse(URL url) {
        if (url == null) {
            return null;
        }
        try (InputStream inputStream = url.openStream();){
            JSONObject jSONObject = this._jsonFactory.createJSONObject(StringUtil.read((InputStream)inputStream));
            return jSONObject;
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to parse " + url), (Throwable)exception);
            return null;
        }
    }

    private void _registerConfigurationActionService(BundleContext bundleContext, JSONObject packageJSONObject, JSONObject portletPreferencesJSONObject) {
        String portletName = this._getPortletName(packageJSONObject);
        try {
            PortletExtenderConfigurationAction configurationAction = new PortletExtenderConfigurationAction(this._ddm, this._ddmFormRenderer, this._ddmFormValuesFactory, portletPreferencesJSONObject);
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("javax.portlet.name", portletName);
            bundleContext.registerService(new String[]{ConfigurationAction.class.getName()}, (Object)configurationAction, properties);
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to register configuration action service for portlet" + portletName), (Throwable)portalException);
        }
    }

    private ServiceRegistration<?> _registerJSPortletService(BundleContext bundleContext, JSONObject packageJSONObject, Set<String> portletPreferencesFieldNames) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        this._addServiceProperties(properties, packageJSONObject.getJSONObject("portlet"));
        String packageName = packageJSONObject.getString("name");
        ((Dictionary)properties).put("javax.portlet.name", this._getPortletName(packageJSONObject));
        ((Dictionary)properties).put("service.pid", packageName);
        String packageVersion = packageJSONObject.getString("version");
        return bundleContext.registerService(new String[]{ManagedService.class.getName(), Portlet.class.getName()}, (Object)new JSPortlet(this._jsonFactory, packageName, packageVersion, portletPreferencesFieldNames), properties);
    }
}

