/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.portlet.extender.internal.portlet.action;

import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletExtenderConfigurationAction
extends DefaultConfigurationAction {
    private static final String _TPL_CONFIGURATION_FORM;
    private static final Log _log;
    private final DDMForm _ddmForm;
    private final DDMFormRenderer _ddmFormRenderer;
    private final Set<String> _fieldNames = new HashSet<String>();
    private final JSONObject _preferencesJSONObject;

    public PortletExtenderConfigurationAction(DDM ddm, DDMFormRenderer ddmFormRenderer, JSONObject preferencesJSONObject) throws PortalException {
        this._ddmFormRenderer = ddmFormRenderer;
        this._ddmForm = ddm.getDDMForm(preferencesJSONObject.toJSONString());
        this._preferencesJSONObject = preferencesJSONObject;
        this._populateFieldNames();
    }

    public void include(PortletConfig portletConfig, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        this._setPortletPreferencesToDDMFormValues(themeDisplay, portletDisplay);
        PrintWriter printWriter = httpServletResponse.getWriter();
        JSONArray fieldsJSONArray = this._preferencesJSONObject.getJSONArray("fields");
        printWriter.println(StringUtil.replace((String)_TPL_CONFIGURATION_FORM, (String[])new String[]{"[$ACTION_URL$]", "[$CONSTANTS_CMD$]", "[$CONSTANTS_UPDATE$]", "[$CURRENT_TIME_MILLIS$]", "[$DDM_FORM_HTML$]", "[$FIELDS_JSON_ARRAY$]", "[$PORTLET_NAMESPACE$]", "[$SAVE_LABEL$]"}, (String[])new String[]{this._getActionURL(httpServletRequest, portletDisplay), "cmd", "update", String.valueOf(System.currentTimeMillis()), this._ddmFormRenderer.render(this._ddmForm, this._createDDMFormRenderingContext(httpServletRequest, httpServletResponse)), fieldsJSONArray.toString(), portletDisplay.getNamespace(), LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"save")}));
    }

    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Map parameters = actionRequest.getParameterMap();
        for (Map.Entry entry : parameters.entrySet()) {
            String name;
            String[] names;
            String key = (String)entry.getKey();
            if (!key.startsWith("ddm$$") || (names = key.split("\\$")).length < 3 || !this._fieldNames.contains(name = names[2])) continue;
            String value = ((String[])entry.getValue())[0];
            this.setPreference((PortletRequest)actionRequest, name, value);
        }
        super.processAction(portletConfig, actionRequest, actionResponse);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String _loadTemplate(String name) {
        try (InputStream inputStream = PortletExtenderConfigurationAction.class.getResourceAsStream("dependencies/" + name);){
            String string = StringUtil.read((InputStream)inputStream);
            return string;
        }
        catch (Exception e) {
            _log.error((Object)("Unable to read template " + name), (Throwable)e);
            return "";
        }
    }

    private DDMFormRenderingContext _createDDMFormRenderingContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
        ddmFormRenderingContext.setHttpServletRequest(httpServletRequest);
        ddmFormRenderingContext.setHttpServletResponse(httpServletResponse);
        Set availableLocales = this._ddmForm.getAvailableLocales();
        Locale locale = this._ddmForm.getDefaultLocale();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (availableLocales.contains(themeDisplay.getLocale())) {
            locale = themeDisplay.getLocale();
        }
        ddmFormRenderingContext.setLocale(locale);
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        ddmFormRenderingContext.setPortletNamespace(portletDisplay.getNamespace());
        ddmFormRenderingContext.setReadOnly(false);
        return ddmFormRenderingContext;
    }

    private String _getActionURL(HttpServletRequest httpServletRequest, PortletDisplay portletDisplay) throws Exception {
        LiferayPortletURL actionURL = PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)portletDisplay.getPortletName(), (String)"ACTION_PHASE");
        actionURL.setParameter("javax.portlet.action", "editConfiguration");
        actionURL.setParameter("mvcPath", "/edit_configuration.jsp");
        actionURL.setParameter("p_auth", AuthTokenUtil.getToken((HttpServletRequest)httpServletRequest));
        actionURL.setParameter("p_p_mode", PortletMode.VIEW.toString());
        actionURL.setParameter("portletConfiguration", Boolean.TRUE.toString());
        actionURL.setParameter("portletResource", portletDisplay.getPortletResource());
        actionURL.setParameter("previewWidth", "");
        actionURL.setParameter("returnToFullPageURL", "/");
        actionURL.setParameter("settingsScope", "portletInstance");
        actionURL.setWindowState(LiferayWindowState.POP_UP);
        return actionURL.toString();
    }

    private void _populateFieldNames() {
        JSONArray fieldsJSONArray = this._preferencesJSONObject.getJSONArray("fields");
        for (int i = 0; i < fieldsJSONArray.length(); ++i) {
            JSONObject fieldJSONObject = fieldsJSONArray.getJSONObject(i);
            this._fieldNames.add(fieldJSONObject.getString("name"));
        }
    }

    private void _setPortletPreferencesToDDMFormValues(ThemeDisplay themeDisplay, PortletDisplay portletDisplay) throws PortalException {
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getExistingPortletSetup((Layout)themeDisplay.getLayout(), (String)portletDisplay.getPortletResource());
        Map portletPreferencesMap = portletPreferences.getMap();
        portletPreferencesMap.forEach((key, values) -> {
            for (DDMFormField ddmFormField : this._ddmForm.getDDMFormFields()) {
                LocalizedValue predefinedValue = new LocalizedValue();
                predefinedValue.setDefaultLocale(themeDisplay.getLocale());
                if (!key.contains(ddmFormField.getName())) continue;
                if ("select".equals(ddmFormField.getType())) {
                    JSONArray valuesJSONArray = JSONFactoryUtil.createJSONArray();
                    for (String value : values) {
                        valuesJSONArray.put(value);
                    }
                    predefinedValue.addString(themeDisplay.getLocale(), valuesJSONArray.toString());
                } else {
                    predefinedValue.addString(themeDisplay.getLocale(), values[0]);
                }
                ddmFormField.setPredefinedValue(predefinedValue);
                ddmFormField.setProperty("predefinedValue", (Object)predefinedValue);
            }
        });
    }

    static {
        _log = LogFactoryUtil.getLog(PortletExtenderConfigurationAction.class);
        _TPL_CONFIGURATION_FORM = PortletExtenderConfigurationAction._loadTemplate("configuration_form.html.tpl");
    }
}

