/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.portlet.extender.internal.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class JSPortlet
extends MVCPortlet {
    private static final String _HTML_TPL;
    private static final String _JAVA_SCRIPT_TPL;
    private static final Log _log;
    private final String _name;
    private final String _version;

    public JSPortlet(String name, String version) {
        this._name = name;
        this._version = version;
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) {
        try {
            PrintWriter printWriter = renderResponse.getWriter();
            String portletElementId = "js-portlet-" + renderResponse.getNamespace();
            printWriter.print(StringUtil.replace((String)_HTML_TPL, (String[])new String[]{"[$PORTLET_ELEMENT_ID$]"}, (String[])new String[]{portletElementId}));
            printWriter.print(StringUtil.replace((String)_JAVA_SCRIPT_TPL, (String[])new String[]{"[$CONTEXT_PATH$]", "[$PORTLET_ELEMENT_ID$]", "[$PORTLET_NAMESPACE$]", "[$PACKAGE_NAME$]", "[$PACKAGE_VERSION$]"}, (String[])new String[]{renderRequest.getContextPath(), portletElementId, renderResponse.getNamespace(), this._name, this._version}));
            printWriter.flush();
        }
        catch (IOException ioe) {
            _log.error((Object)"Unable to render HTML output", (Throwable)ioe);
        }
    }

    private static String _loadTemplate(String name) {
        InputStream inputStream = JSPortlet.class.getResourceAsStream("dependencies/" + name);
        try {
            return StringUtil.read((InputStream)inputStream);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to read template " + name), (Throwable)e);
            return "";
        }
    }

    static {
        _log = LogFactoryUtil.getLog(JSPortlet.class);
        _HTML_TPL = JSPortlet._loadTemplate("bootstrap.html.tpl");
        _JAVA_SCRIPT_TPL = JSPortlet._loadTemplate("bootstrap.js.tpl");
    }
}

