/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.portlet.extender;

import com.liferay.frontend.js.portlet.extender.internal.portlet.JSPortlet;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.Portlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(immediate=true, service={JSPortletExtender.class})
public class JSPortletExtender {
    private static final Log _log = LogFactoryUtil.getLog(JSPortletExtender.class);
    private BundleTracker<ServiceRegistration<?>> _bundleTracker;
    private BundleTrackerCustomizer<ServiceRegistration<?>> _bundleTrackerCustomizer = new BundleTrackerCustomizer<ServiceRegistration<?>>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ServiceRegistration<?> addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            if (!JSPortletExtender.this._optIn(bundle)) {
                return null;
            }
            URL jsonURL = bundle.getEntry("META-INF/resources/package.json");
            if (jsonURL == null) {
                return null;
            }
            try (InputStream inputStream = jsonURL.openStream();){
                ServiceRegistration serviceRegistration2;
                BundleContext bundleContext = bundle.getBundleContext();
                String jsonString = StringUtil.read((InputStream)inputStream);
                JSONObject jsonObject = JSPortletExtender.this._jsonFactory.createJSONObject(jsonString);
                String name = jsonObject.getString("name");
                String version = jsonObject.getString("version");
                Hashtable<String, String> properties = new Hashtable<String, String>();
                ((Dictionary)properties).put("javax.portlet.name", name);
                JSPortletExtender.this._addServiceProperties(properties, jsonObject.getJSONObject("portlet"));
                ServiceRegistration serviceRegistration = serviceRegistration2 = bundleContext.registerService(new String[]{Portlet.class.getName()}, (Object)new JSPortlet(name, version), properties);
                return serviceRegistration;
            }
            catch (Exception e) {
                _log.error((Object)("Unable to process package.json of " + bundle.getSymbolicName()), (Throwable)e);
                return null;
            }
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, ServiceRegistration<?> serviceRegistration) {
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, ServiceRegistration<?> serviceRegistration) {
            serviceRegistration.unregister();
        }
    };
    @Reference
    private JSONFactory _jsonFactory;

    @Activate
    public void activate(BundleContext context) {
        this._bundleTracker = new BundleTracker(context, 32, this._bundleTrackerCustomizer);
        this._bundleTracker.open();
    }

    @Deactivate
    public void deactivate() {
        this._bundleTracker.close();
        this._bundleTracker = null;
    }

    private void _addServiceProperties(Dictionary<String, Object> properties, JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = jsonObject.get(key);
            if (value instanceof JSONObject) {
                String stringValue = value.toString();
                properties.put(key, stringValue);
                continue;
            }
            if (value instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)value;
                ArrayList<String> values = new ArrayList<String>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Object object = jsonArray.get(i);
                    values.add(object.toString());
                }
                properties.put(key, values.toArray(new String[0]));
                continue;
            }
            properties.put(key, value);
        }
    }

    private boolean _optIn(Bundle bundle) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        List bundleWires = bundleWiring.getRequiredWires("osgi.extender");
        for (BundleWire bundleWire : bundleWires) {
            BundleCapability bundleCapability = bundleWire.getCapability();
            Map attributes = bundleCapability.getAttributes();
            Object value = attributes.get("osgi.extender");
            if (value == null || !value.equals("liferay.frontend.js.portlet")) continue;
            return true;
        }
        return false;
    }
}

