/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm;

import com.liferay.frontend.js.loader.modules.extender.internal.npm.InvalidNPMResolverImpl;
import com.liferay.frontend.js.loader.modules.extender.internal.npm.NPMResolverImpl;
import com.liferay.frontend.js.loader.modules.extender.internal.npm.UnsupportedNPMResolverImpl;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistry;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.URLUtil;
import java.io.IOException;
import java.net.URL;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class NPMResolverServiceFactory
implements ServiceFactory<NPMResolver> {
    private final JSONFactory _jsonFactory;
    private final NPMRegistry _npmRegistry;

    public NPMResolverServiceFactory(JSONFactory jsonFactory, NPMRegistry npmRegistry) {
        this._jsonFactory = jsonFactory;
        this._npmRegistry = npmRegistry;
    }

    public NPMResolver getService(Bundle bundle, ServiceRegistration<NPMResolver> serviceRegistration) {
        URL packageURL = bundle.getEntry("META-INF/resources/package.json");
        if (packageURL == null) {
            return new InvalidNPMResolverImpl(bundle);
        }
        JSONObject packageJSONObject = this._createJSONObject(packageURL);
        URL manifestURL = bundle.getEntry("META-INF/resources/manifest.json");
        if (manifestURL == null) {
            return new UnsupportedNPMResolverImpl(bundle);
        }
        JSONObject manifestJSONObject = this._createJSONObject(manifestURL);
        JSONObject packagesJSONObject = manifestJSONObject.getJSONObject("packages");
        if (packagesJSONObject == null) {
            return new UnsupportedNPMResolverImpl(bundle);
        }
        return new NPMResolverImpl(bundle, this._npmRegistry, packageJSONObject, packagesJSONObject);
    }

    public void ungetService(Bundle bundle, ServiceRegistration<NPMResolver> serviceRegistration, NPMResolver npmResolver) {
    }

    private JSONObject _createJSONObject(URL url) {
        try {
            return this._jsonFactory.createJSONObject(URLUtil.toString((URL)url));
        }
        catch (JSONException | IOException exception) {
            throw new RuntimeException("Unable to read " + url, exception);
        }
    }
}

