/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm;

import com.liferay.frontend.js.loader.modules.extender.internal.npm.NPMResolvedPackageNameRegistrar;
import com.liferay.frontend.js.loader.modules.extender.internal.npm.NPMResolverImpl;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundle;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundleTracker;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistry;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolverUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={JSBundleTracker.class})
public class NPMResolverJSBundleTracker
implements JSBundleTracker {
    private static final Log _log = LogFactoryUtil.getLog(NPMResolverJSBundleTracker.class);
    private BundleContext _bundleContext;
    @Reference
    private JSONFactory _jsonFactory;
    private final Map<Bundle, NPMResolvedPackageNameRegistrar> _npmResolvedPackageNameRegistrarMap = new ConcurrentHashMap<Bundle, NPMResolvedPackageNameRegistrar>();

    public void addedJSBundle(JSBundle jsBundle, Bundle bundle, NPMRegistry npmRegistry) {
        NPMResolverImpl npmResolver = new NPMResolverImpl(bundle, this._jsonFactory, npmRegistry);
        NPMResolverUtil.set((Bundle)bundle, (NPMResolver)npmResolver);
        String npmResolvedPackageName = this._getNPMResolvedPackageName(bundle, npmResolver);
        if (npmResolvedPackageName == null) {
            return;
        }
        try {
            NPMResolvedPackageNameRegistrar npmResolvedPackageNameRegistrar = new NPMResolvedPackageNameRegistrar(this._bundleContext, bundle, npmResolvedPackageName);
            this._npmResolvedPackageNameRegistrarMap.put(bundle, npmResolvedPackageNameRegistrar);
            npmResolvedPackageNameRegistrar.open();
        }
        catch (InvalidSyntaxException ise) {
            _log.error((Object)("Unable to track servlet context for bundle " + bundle.getBundleId()), (Throwable)ise);
        }
    }

    public void removedJSBundle(JSBundle jsBundle, Bundle bundle, NPMRegistry npmRegistry) {
        NPMResolverUtil.set((Bundle)bundle, null);
        NPMResolvedPackageNameRegistrar npmResolvedPackageNameRegistrar = this._npmResolvedPackageNameRegistrarMap.remove(bundle);
        if (npmResolvedPackageNameRegistrar != null) {
            npmResolvedPackageNameRegistrar.close();
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    private String _getNPMResolvedPackageName(Bundle bundle, NPMResolver npmResolver) {
        try {
            URL url = bundle.getResource("META-INF/resources/package.json");
            String json = StringUtil.read((InputStream)url.openStream());
            JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
            String name = jsonObject.getString("name");
            return npmResolver.resolveModuleName(name);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to read META-INF/resources/package.json in " + bundle.getSymbolicName()), (Throwable)e);
            return null;
        }
    }
}

