/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.importmaps.extender.internal.servlet.taglib;

import com.liferay.frontend.js.importmaps.extender.internal.servlet.taglib.JSImportMapsRegistration;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class JSImportMapsCache {
    public static final long COMPANY_ID_ALL = 0L;
    private static final Log _log = LogFactoryUtil.getLog(JSImportMapsCache.class);
    private final Map<Long, Map<Long, String>> _globalImportMapsValuesMap = new ConcurrentHashMap<Long, Map<Long, String>>();
    private final AtomicLong _nextGlobalId = new AtomicLong();
    private final Map<Long, Map<String, String>> _scopedImportMapsValuesMap = new ConcurrentHashMap<Long, Map<String, String>>();

    public JSImportMapsRegistration register(long companyId, JSONObject jsonObject, String scope) {
        if (scope == null) {
            Map<Long, String> globalImportMapsValues = this._getGlobalImportMapsValues(companyId);
            long globalId = this._nextGlobalId.getAndIncrement();
            String value = jsonObject.toString();
            value = value.substring(1, value.length() - 1);
            globalImportMapsValues.put(globalId, value);
            return () -> globalImportMapsValues.remove(globalId);
        }
        Map<String, String> scopedImportMapsValues = this._getScopedImportMapsValues(companyId);
        String value = scopedImportMapsValues.putIfAbsent(scope, jsonObject.toString());
        if (value != null) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Import map ", jsonObject, " for scope ", scope, " will ", "be ignored because there is already an import map ", "registered under that scope"}));
            return () -> {};
        }
        return () -> scopedImportMapsValues.remove(scope);
    }

    public void writeImportMaps(long companyId, Writer writer) throws IOException {
        if (companyId == 0L) {
            throw new IllegalArgumentException("Company ID cannot be 0");
        }
        writer.write("{\"imports\": {");
        Map<Long, String> globalImportMapsValues1 = this._getGlobalImportMapsValues(0L);
        this._writeImports(globalImportMapsValues1, writer);
        Map<Long, String> globalImportMapsValues2 = this._getGlobalImportMapsValues(companyId);
        if (!globalImportMapsValues1.isEmpty() && !globalImportMapsValues2.isEmpty()) {
            writer.write(",");
        }
        this._writeImports(globalImportMapsValues2, writer);
        writer.write("}, \"scopes\": {");
        Map<String, String> scopedImportMapsValues1 = this._getScopedImportMapsValues(0L);
        this._writeScopes(scopedImportMapsValues1, writer);
        Map<String, String> scopedImportMapsValues2 = this._getScopedImportMapsValues(companyId);
        if (!scopedImportMapsValues1.isEmpty() && !scopedImportMapsValues2.isEmpty()) {
            writer.write(",");
        }
        this._writeScopes(scopedImportMapsValues2, writer);
        writer.write("}}");
    }

    private Map<Long, String> _getGlobalImportMapsValues(Long companyId) {
        Map<Long, String> globalImportMapsValues1 = this._globalImportMapsValuesMap.get(companyId);
        if (globalImportMapsValues1 != null) {
            return globalImportMapsValues1;
        }
        this._globalImportMapsValuesMap.putIfAbsent(companyId, new ConcurrentHashMap());
        return this._globalImportMapsValuesMap.get(companyId);
    }

    private Map<String, String> _getScopedImportMapsValues(Long companyId) {
        Map<String, String> scopedImportMapsValues1 = this._scopedImportMapsValuesMap.get(companyId);
        if (scopedImportMapsValues1 != null) {
            return scopedImportMapsValues1;
        }
        this._scopedImportMapsValuesMap.putIfAbsent(companyId, new ConcurrentHashMap());
        return this._scopedImportMapsValuesMap.get(companyId);
    }

    private void _writeImports(Map<Long, String> globalImportMapsValues, Writer writer) throws IOException {
        boolean first = true;
        for (String value : globalImportMapsValues.values()) {
            if (!first) {
                writer.write(",");
            } else {
                first = false;
            }
            writer.write(value);
        }
    }

    private void _writeScopes(Map<String, String> scopedImportMapsValues, Writer writer) throws IOException {
        boolean first = true;
        for (Map.Entry<String, String> entry : scopedImportMapsValues.entrySet()) {
            if (!first) {
                writer.write(",");
            } else {
                first = false;
            }
            writer.write("\"");
            writer.write(entry.getKey());
            writer.write("\": ");
            writer.write(entry.getValue());
        }
    }
}

