/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.importmaps.extender.internal.servlet.taglib;

import com.liferay.frontend.js.importmaps.extender.internal.servlet.taglib.JSImportmapsRegistration;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.servlet.taglib.BaseDynamicInclude;
import com.liferay.portal.kernel.servlet.taglib.DynamicInclude;
import com.liferay.portal.url.builder.AbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.AbsolutePortalURLBuilderFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DynamicInclude.class, JSImportmapsExtenderTopHeadDynamicInclude.class})
public class JSImportmapsExtenderTopHeadDynamicInclude
extends BaseDynamicInclude {
    @Reference
    private AbsolutePortalURLBuilderFactory _absolutePortalURLBuilderFactory;
    private BundleContext _bundleContext;
    private final ConcurrentMap<Long, JSONObject> _globalImportmaps = new ConcurrentHashMap<Long, JSONObject>();
    private final AtomicReference<String> _importmaps = new AtomicReference();
    @Reference
    private JSONFactory _jsonFactory;
    private final AtomicLong _nextGlobalId = new AtomicLong();
    private final ConcurrentMap<String, JSONObject> _scopedImportmaps = new ConcurrentHashMap<String, JSONObject>();

    public void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String key) throws IOException {
        if (this._globalImportmaps.isEmpty() && this._scopedImportmaps.isEmpty()) {
            return;
        }
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<script type=\"importmap\">");
        printWriter.println(this._importmaps.get());
        printWriter.println("</script>");
        printWriter.print("<script src=\"");
        AbsolutePortalURLBuilder absolutePortalURLBuilder = this._absolutePortalURLBuilderFactory.getAbsolutePortalURLBuilder(httpServletRequest);
        printWriter.print(absolutePortalURLBuilder.forModuleScript(this._bundleContext.getBundle(), "/es-module-shims/es-module-shims.js").build());
        printWriter.println("\"></script>\n");
    }

    public void register(DynamicInclude.DynamicIncludeRegistry dynamicIncludeRegistry) {
        dynamicIncludeRegistry.register("/html/common/themes/top_head.jsp#pre");
    }

    public JSImportmapsRegistration register(final String scope, JSONObject jsonObject) {
        if (scope == null) {
            final long globalId = this._nextGlobalId.getAndIncrement();
            this._globalImportmaps.put(globalId, jsonObject);
            this._rebuildImportmaps();
            return new JSImportmapsRegistration(){

                @Override
                public void unregister() {
                    JSImportmapsExtenderTopHeadDynamicInclude.this._globalImportmaps.remove(globalId);
                }
            };
        }
        this._scopedImportmaps.put(scope, jsonObject);
        this._getScopesJSONObject();
        return new JSImportmapsRegistration(){

            @Override
            public void unregister() {
                JSImportmapsExtenderTopHeadDynamicInclude.this._scopedImportmaps.remove(scope);
            }
        };
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._rebuildImportmaps();
    }

    private JSONObject _getGlobalJSONObject() {
        JSONObject globalJSONObject = this._jsonFactory.createJSONObject();
        for (JSONObject jsonObject : this._globalImportmaps.values()) {
            for (String key : jsonObject.keySet()) {
                globalJSONObject.put(key, jsonObject.getString(key));
            }
        }
        return globalJSONObject;
    }

    private JSONObject _getScopesJSONObject() {
        JSONObject scopesJSONObject = this._jsonFactory.createJSONObject();
        for (Map.Entry entry : this._scopedImportmaps.entrySet()) {
            scopesJSONObject.put((String)entry.getKey(), (JSONObject)entry.getValue());
        }
        return scopesJSONObject;
    }

    private synchronized void _rebuildImportmaps() {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        JSONObject globalJSONObject = this._getGlobalJSONObject();
        globalJSONObject.put("scopes", this._getScopesJSONObject());
        jsonObject.put("imports", globalJSONObject);
        this._importmaps.set(this._jsonFactory.looseSerializeDeep((Object)jsonObject));
    }
}

