/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.frontend.js.importmaps.extender.internal;

import com.liferay.frontend.js.importmaps.extender.JSImportmapsContributor;
import com.liferay.frontend.js.importmaps.extender.internal.servlet.taglib.JSImportmapsExtenderTopHeadDynamicInclude;
import com.liferay.frontend.js.importmaps.extender.internal.servlet.taglib.JSImportmapsRegistration;
import com.liferay.portal.kernel.json.JSONFactory;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/**
 * @author Iván Zaera Avellón
 */
@Component(immediate = true, service = {})
public class JSImportmapsContributorExtender {

	@Activate
	protected void activate(BundleContext bundleContext) {
		_bundleContext = bundleContext;

		_serviceTracker = new ServiceTracker<>(
			bundleContext, JSImportmapsContributor.class,
			_serviceTrackerCustomizer);

		_serviceTracker.open();
	}

	@Deactivate
	protected void deactivate() {
		_serviceTracker.close();

		_serviceTracker = null;

		_bundleContext = null;
	}

	private BundleContext _bundleContext;

	@Reference
	private JSImportmapsExtenderTopHeadDynamicInclude
		_jsImportmapsExtenderTopHeadDynamicInclude;

	@Reference
	private JSONFactory _jsonFactory;

	private ServiceTracker<JSImportmapsContributor, JSImportmapsRegistration>
		_serviceTracker;

	private final ServiceTrackerCustomizer
		<JSImportmapsContributor, JSImportmapsRegistration>
			_serviceTrackerCustomizer =
				new ServiceTrackerCustomizer
					<JSImportmapsContributor, JSImportmapsRegistration>() {

					@Override
					public JSImportmapsRegistration addingService(
						ServiceReference<JSImportmapsContributor>
							serviceReference) {

						JSImportmapsContributor jsImportmapsContributor =
							_bundleContext.getService(serviceReference);

						return _jsImportmapsExtenderTopHeadDynamicInclude.
							register(
								jsImportmapsContributor.getScope(),
								jsImportmapsContributor.
									getImportmapsJSONObject());
					}

					@Override
					public void modifiedService(
						ServiceReference serviceReference,
						JSImportmapsRegistration jsImportmapsRegistration) {
					}

					@Override
					public void removedService(
						ServiceReference serviceReference,
						JSImportmapsRegistration jsImportmapsRegistration) {

						jsImportmapsRegistration.unregister();
					}

				};

}