/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.bundle.config.extender.internal;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import java.net.URL;
import java.util.Collection;
import java.util.Dictionary;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class JSBundleConfigRegistryUtil {
    private static volatile long _lastModified = System.currentTimeMillis();
    private static final ServiceTrackerList<JSConfig> _serviceTrackerList;

    public static Collection<JSConfig> getJSConfigs() {
        return _serviceTrackerList.toList();
    }

    public static long getLastModified() {
        return _lastModified;
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(JSBundleConfigRegistryUtil.class);
        BundleContext bundleContext = bundle.getBundleContext();
        _serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, ServletContext.class, (String)"(osgi.web.contextpath=*)", (ServiceTrackerCustomizer)new JSBundleConfigServiceTrackerCustomizer(bundleContext));
    }

    private static class JSBundleConfigServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ServletContext, JSConfig> {
        private final BundleContext _bundleContext;

        public JSBundleConfigServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        public JSConfig addingService(ServiceReference<ServletContext> serviceReference) {
            URL url;
            Bundle bundle = serviceReference.getBundle();
            Dictionary headers = bundle.getHeaders("");
            String jsConfig = (String)headers.get("Liferay-JS-Config");
            if (jsConfig != null && (url = bundle.getEntry(jsConfig)) != null) {
                ServletContext servletContext = (ServletContext)this._bundleContext.getService(serviceReference);
                _lastModified = System.currentTimeMillis();
                return new JSConfig(servletContext, url);
            }
            return null;
        }

        public void modifiedService(ServiceReference<ServletContext> serviceReference, JSConfig jsConfig) {
        }

        public void removedService(ServiceReference<ServletContext> serviceReference, JSConfig jsConfig) {
            if (jsConfig != null) {
                this._bundleContext.ungetService(serviceReference);
                _lastModified = System.currentTimeMillis();
            }
        }
    }

    public static class JSConfig {
        private final ServletContext _servletContext;
        private final URL _url;

        public ServletContext getServletContext() {
            return this._servletContext;
        }

        public URL getURL() {
            return this._url;
        }

        private JSConfig(ServletContext servletContext, URL url) {
            this._servletContext = servletContext;
            this._url = url;
        }
    }
}

