/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.css.rtl.servlet.internal;

import com.liferay.frontend.css.rtl.servlet.internal.RTLServlet;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={})
public class RTLServletTracker {
    private ServiceTracker<ServletContextHelper, ServiceRegistration<Servlet>> _serviceTracker;

    @Activate
    protected void activate(final BundleContext bundleContext) {
        String filterString = StringBundler.concat((String[])new String[]{"(&(objectClass=", ServletContextHelper.class.getName(), ")", "(rtl.required=true))"});
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, (String)filterString, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ServletContextHelper, ServiceRegistration<Servlet>>(){

            public ServiceRegistration<Servlet> addingService(ServiceReference<ServletContextHelper> serviceReference) {
                ServletContextHelper servletContextHelper = (ServletContextHelper)bundleContext.getService(serviceReference);
                RTLServlet servlet = new RTLServlet(serviceReference.getBundle(), servletContextHelper);
                return bundleContext.registerService(Servlet.class, (Object)servlet, (Dictionary)RTLServletTracker.this._buildProperties((ServiceReference<ServletContextHelper>)serviceReference));
            }

            public void modifiedService(ServiceReference<ServletContextHelper> serviceReference, ServiceRegistration<Servlet> serviceRegistration) {
                serviceRegistration.setProperties((Dictionary)RTLServletTracker.this._buildProperties((ServiceReference<ServletContextHelper>)serviceReference));
            }

            public void removedService(ServiceReference<ServletContextHelper> serviceReference, ServiceRegistration<Servlet> serviceRegistration) {
                serviceRegistration.unregister();
                bundleContext.ungetService(serviceReference);
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private Hashtable<String, Object> _buildProperties(ServiceReference<ServletContextHelper> serviceReference) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        Object contextName = serviceReference.getProperty("osgi.http.whiteboard.context.name");
        properties.put("osgi.http.whiteboard.context.select", contextName);
        properties.put("osgi.http.whiteboard.servlet.name", RTLServlet.class.getName());
        properties.put("osgi.http.whiteboard.servlet.pattern", "*.css");
        Bundle bundle = serviceReference.getBundle();
        Dictionary headers = bundle.getHeaders("");
        int themeContributorWeight = GetterUtil.getInteger((String)((String)headers.get("Liferay-Theme-Contributor-Weight")));
        properties.put("service.ranking", themeContributorWeight);
        return properties;
    }
}

