/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.friendly.url.test.util;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.model.FriendlyURLEntryLocalization;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.friendly.url.service.persistence.FriendlyURLEntryLocalizationPersistence;
import com.liferay.friendly.url.service.persistence.FriendlyURLEntryLocalizationUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.test.rule.Inject;
import java.util.Locale;
import org.junit.Before;

public abstract class BaseFriendlyURLFormatUpgradeProcessTestCase {
    @Inject
    protected static FriendlyURLEntryLocalService friendlyURLEntryLocalService;
    protected static Group group;
    @Inject
    protected CounterLocalService counterLocalService;
    protected String defaultLanguageId;
    private static FriendlyURLEntryLocalizationPersistence _persistence;
    private FriendlyURLEntry _friendlyURLEntry;

    @Before
    public void setUp() throws Exception {
        group = GroupTestUtil.addGroup();
        this.defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
        _persistence = FriendlyURLEntryLocalizationUtil.getPersistence();
    }

    protected void addFriendlyURLEntry(long classPK, long classNameId) {
        long friendlyURLEntryId = RandomTestUtil.randomLong();
        this._friendlyURLEntry = friendlyURLEntryLocalService.createFriendlyURLEntry(friendlyURLEntryId);
        this._friendlyURLEntry.setDefaultLanguageId(this.defaultLanguageId);
        this._friendlyURLEntry.setGroupId(group.getGroupId());
        this._friendlyURLEntry.setClassNameId(classNameId);
        this._friendlyURLEntry.setClassPK(classPK);
        friendlyURLEntryLocalService.addFriendlyURLEntry(this._friendlyURLEntry);
    }

    protected void updateFriendlyURLLocalization(long classNameId, long classPK, String languageId, String urlTitle) {
        FriendlyURLEntryLocalization friendlyURLEntryLocalization = _persistence.create((long)RandomTestUtil.randomInt());
        friendlyURLEntryLocalization.setFriendlyURLEntryId(this._friendlyURLEntry.getFriendlyURLEntryId());
        friendlyURLEntryLocalization.setLanguageId(languageId);
        friendlyURLEntryLocalization.setGroupId(group.getGroupId());
        friendlyURLEntryLocalization.setClassNameId(classNameId);
        friendlyURLEntryLocalization.setClassPK(classPK);
        friendlyURLEntryLocalization.setUrlTitle(urlTitle);
        friendlyURLEntryLocalService.updateFriendlyURLLocalization(friendlyURLEntryLocalization);
    }
}

