/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.friendly.url.service.persistence.impl;

import com.liferay.friendly.url.exception.NoSuchFriendlyURLEntryException;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.model.impl.FriendlyURLEntryImpl;
import com.liferay.friendly.url.model.impl.FriendlyURLEntryModelImpl;
import com.liferay.friendly.url.service.persistence.FriendlyURLEntryPersistence;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={FriendlyURLEntryPersistence.class})
public class FriendlyURLEntryPersistenceImpl
extends BasePersistenceImpl<FriendlyURLEntry>
implements FriendlyURLEntryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = FriendlyURLEntryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "friendlyURLEntry.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(friendlyURLEntry.uuid IS NULL OR friendlyURLEntry.uuid = '')";
    private FinderPath _finderPathFetchByUUID_G;
    private FinderPath _finderPathCountByUUID_G;
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "friendlyURLEntry.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(friendlyURLEntry.uuid IS NULL OR friendlyURLEntry.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "friendlyURLEntry.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "friendlyURLEntry.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(friendlyURLEntry.uuid IS NULL OR friendlyURLEntry.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "friendlyURLEntry.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByG_C_C;
    private FinderPath _finderPathWithoutPaginationFindByG_C_C;
    private FinderPath _finderPathCountByG_C_C;
    private static final String _FINDER_COLUMN_G_C_C_GROUPID_2 = "friendlyURLEntry.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_C_C_CLASSNAMEID_2 = "friendlyURLEntry.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_G_C_C_CLASSPK_2 = "friendlyURLEntry.classPK = ?";
    private boolean _columnBitmaskEnabled;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_FRIENDLYURLENTRY = "SELECT friendlyURLEntry FROM FriendlyURLEntry friendlyURLEntry";
    private static final String _SQL_SELECT_FRIENDLYURLENTRY_WHERE = "SELECT friendlyURLEntry FROM FriendlyURLEntry friendlyURLEntry WHERE ";
    private static final String _SQL_COUNT_FRIENDLYURLENTRY = "SELECT COUNT(friendlyURLEntry) FROM FriendlyURLEntry friendlyURLEntry";
    private static final String _SQL_COUNT_FRIENDLYURLENTRY_WHERE = "SELECT COUNT(friendlyURLEntry) FROM FriendlyURLEntry friendlyURLEntry WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "friendlyURLEntry.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No FriendlyURLEntry exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No FriendlyURLEntry exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(FriendlyURLEntryPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});

    public List<FriendlyURLEntry> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<FriendlyURLEntry> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<FriendlyURLEntry> findByUuid(String uuid, int start, int end, OrderByComparator<FriendlyURLEntry> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<FriendlyURLEntry> findByUuid(String uuid, int start, int end, OrderByComparator<FriendlyURLEntry> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (FriendlyURLEntry friendlyURLEntry : list) {
                if (uuid.equals(friendlyURLEntry.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_FRIENDLYURLENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY friendlyURLEntry.friendlyURLEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public FriendlyURLEntry findByUuid_First(String uuid, OrderByComparator<FriendlyURLEntry> orderByComparator) throws NoSuchFriendlyURLEntryException {
        FriendlyURLEntry friendlyURLEntry = this.fetchByUuid_First(uuid, orderByComparator);
        if (friendlyURLEntry != null) {
            return friendlyURLEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchFriendlyURLEntryException(sb.toString());
    }

    public FriendlyURLEntry fetchByUuid_First(String uuid, OrderByComparator<FriendlyURLEntry> orderByComparator) {
        List<FriendlyURLEntry> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public FriendlyURLEntry findByUuid_Last(String uuid, OrderByComparator<FriendlyURLEntry> orderByComparator) throws NoSuchFriendlyURLEntryException {
        FriendlyURLEntry friendlyURLEntry = this.fetchByUuid_Last(uuid, orderByComparator);
        if (friendlyURLEntry != null) {
            return friendlyURLEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchFriendlyURLEntryException(sb.toString());
    }

    public FriendlyURLEntry fetchByUuid_Last(String uuid, OrderByComparator<FriendlyURLEntry> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<FriendlyURLEntry> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public FriendlyURLEntry[] findByUuid_PrevAndNext(long friendlyURLEntryId, String uuid, OrderByComparator<FriendlyURLEntry> orderByComparator) throws NoSuchFriendlyURLEntryException {
        uuid = Objects.toString(uuid, "");
        FriendlyURLEntry friendlyURLEntry = this.findByPrimaryKey(friendlyURLEntryId);
        Session session = null;
        try {
            session = this.openSession();
            FriendlyURLEntry[] array = new FriendlyURLEntryImpl[]{this.getByUuid_PrevAndNext(session, friendlyURLEntry, uuid, orderByComparator, true), friendlyURLEntry, this.getByUuid_PrevAndNext(session, friendlyURLEntry, uuid, orderByComparator, false)};
            FriendlyURLEntry[] friendlyURLEntryArray = array;
            return friendlyURLEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected FriendlyURLEntry getByUuid_PrevAndNext(Session session, FriendlyURLEntry friendlyURLEntry, String uuid, OrderByComparator<FriendlyURLEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_FRIENDLYURLENTRY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY friendlyURLEntry.friendlyURLEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)friendlyURLEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (FriendlyURLEntry)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (FriendlyURLEntry friendlyURLEntry : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)friendlyURLEntry);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_FRIENDLYURLENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public FriendlyURLEntry findByUUID_G(String uuid, long groupId) throws NoSuchFriendlyURLEntryException {
        FriendlyURLEntry friendlyURLEntry = this.fetchByUUID_G(uuid, groupId);
        if (friendlyURLEntry == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("uuid=");
            sb.append(uuid);
            sb.append(", groupId=");
            sb.append(groupId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchFriendlyURLEntryException(sb.toString());
        }
        return friendlyURLEntry;
    }

    public FriendlyURLEntry fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public FriendlyURLEntry fetchByUUID_G(String uuid, long groupId, boolean useFinderCache) {
        FriendlyURLEntry friendlyURLEntry;
        uuid = Objects.toString(uuid, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{uuid, groupId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByUUID_G, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof FriendlyURLEntry && (!Objects.equals(uuid, (friendlyURLEntry = (FriendlyURLEntry)result).getUuid()) || groupId != friendlyURLEntry.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_FRIENDLYURLENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(friendlyURLEntry.uuid IS NULL OR friendlyURLEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("friendlyURLEntry.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByUUID_G, finderArgs, (Object)list);
                    }
                } else {
                    FriendlyURLEntry friendlyURLEntry2 = (FriendlyURLEntry)list.get(0);
                    result = friendlyURLEntry2;
                    this.cacheResult(friendlyURLEntry2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByUUID_G, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (FriendlyURLEntry)result;
    }

    public FriendlyURLEntry removeByUUID_G(String uuid, long groupId) throws NoSuchFriendlyURLEntryException {
        FriendlyURLEntry friendlyURLEntry = this.findByUUID_G(uuid, groupId);
        return (FriendlyURLEntry)this.remove((BaseModel)friendlyURLEntry);
    }

    public int countByUUID_G(String uuid, long groupId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_FRIENDLYURLENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(friendlyURLEntry.uuid IS NULL OR friendlyURLEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("friendlyURLEntry.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<FriendlyURLEntry> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<FriendlyURLEntry> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<FriendlyURLEntry> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<FriendlyURLEntry> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<FriendlyURLEntry> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<FriendlyURLEntry> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (FriendlyURLEntry friendlyURLEntry : list) {
                if (uuid.equals(friendlyURLEntry.getUuid()) && companyId == friendlyURLEntry.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_FRIENDLYURLENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(friendlyURLEntry.uuid IS NULL OR friendlyURLEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("friendlyURLEntry.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY friendlyURLEntry.friendlyURLEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public FriendlyURLEntry findByUuid_C_First(String uuid, long companyId, OrderByComparator<FriendlyURLEntry> orderByComparator) throws NoSuchFriendlyURLEntryException {
        FriendlyURLEntry friendlyURLEntry = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (friendlyURLEntry != null) {
            return friendlyURLEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchFriendlyURLEntryException(sb.toString());
    }

    public FriendlyURLEntry fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<FriendlyURLEntry> orderByComparator) {
        List<FriendlyURLEntry> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public FriendlyURLEntry findByUuid_C_Last(String uuid, long companyId, OrderByComparator<FriendlyURLEntry> orderByComparator) throws NoSuchFriendlyURLEntryException {
        FriendlyURLEntry friendlyURLEntry = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (friendlyURLEntry != null) {
            return friendlyURLEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchFriendlyURLEntryException(sb.toString());
    }

    public FriendlyURLEntry fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<FriendlyURLEntry> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<FriendlyURLEntry> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public FriendlyURLEntry[] findByUuid_C_PrevAndNext(long friendlyURLEntryId, String uuid, long companyId, OrderByComparator<FriendlyURLEntry> orderByComparator) throws NoSuchFriendlyURLEntryException {
        uuid = Objects.toString(uuid, "");
        FriendlyURLEntry friendlyURLEntry = this.findByPrimaryKey(friendlyURLEntryId);
        Session session = null;
        try {
            session = this.openSession();
            FriendlyURLEntry[] array = new FriendlyURLEntryImpl[]{this.getByUuid_C_PrevAndNext(session, friendlyURLEntry, uuid, companyId, orderByComparator, true), friendlyURLEntry, this.getByUuid_C_PrevAndNext(session, friendlyURLEntry, uuid, companyId, orderByComparator, false)};
            FriendlyURLEntry[] friendlyURLEntryArray = array;
            return friendlyURLEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected FriendlyURLEntry getByUuid_C_PrevAndNext(Session session, FriendlyURLEntry friendlyURLEntry, String uuid, long companyId, OrderByComparator<FriendlyURLEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_FRIENDLYURLENTRY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append("(friendlyURLEntry.uuid IS NULL OR friendlyURLEntry.uuid = '') AND ");
        } else {
            bindUuid = true;
            sb.append("friendlyURLEntry.uuid = ? AND ");
        }
        sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY friendlyURLEntry.friendlyURLEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)friendlyURLEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (FriendlyURLEntry)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (FriendlyURLEntry friendlyURLEntry : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)friendlyURLEntry);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_FRIENDLYURLENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(friendlyURLEntry.uuid IS NULL OR friendlyURLEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("friendlyURLEntry.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<FriendlyURLEntry> findByG_C_C(long groupId, long classNameId, long classPK) {
        return this.findByG_C_C(groupId, classNameId, classPK, -1, -1, null);
    }

    public List<FriendlyURLEntry> findByG_C_C(long groupId, long classNameId, long classPK, int start, int end) {
        return this.findByG_C_C(groupId, classNameId, classPK, start, end, null);
    }

    public List<FriendlyURLEntry> findByG_C_C(long groupId, long classNameId, long classPK, int start, int end, OrderByComparator<FriendlyURLEntry> orderByComparator) {
        return this.findByG_C_C(groupId, classNameId, classPK, start, end, orderByComparator, true);
    }

    public List<FriendlyURLEntry> findByG_C_C(long groupId, long classNameId, long classPK, int start, int end, OrderByComparator<FriendlyURLEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByG_C_C;
                finderArgs = new Object[]{groupId, classNameId, classPK};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByG_C_C;
            finderArgs = new Object[]{groupId, classNameId, classPK, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (FriendlyURLEntry friendlyURLEntry : list) {
                if (groupId == friendlyURLEntry.getGroupId() && classNameId == friendlyURLEntry.getClassNameId() && classPK == friendlyURLEntry.getClassPK()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            sb.append(_SQL_SELECT_FRIENDLYURLENTRY_WHERE);
            sb.append(_FINDER_COLUMN_G_C_C_GROUPID_2);
            sb.append(_FINDER_COLUMN_G_C_C_CLASSNAMEID_2);
            sb.append(_FINDER_COLUMN_G_C_C_CLASSPK_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY friendlyURLEntry.friendlyURLEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(classNameId);
                queryPos.add(classPK);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public FriendlyURLEntry findByG_C_C_First(long groupId, long classNameId, long classPK, OrderByComparator<FriendlyURLEntry> orderByComparator) throws NoSuchFriendlyURLEntryException {
        FriendlyURLEntry friendlyURLEntry = this.fetchByG_C_C_First(groupId, classNameId, classPK, orderByComparator);
        if (friendlyURLEntry != null) {
            return friendlyURLEntry;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", classNameId=");
        sb.append(classNameId);
        sb.append(", classPK=");
        sb.append(classPK);
        sb.append("}");
        throw new NoSuchFriendlyURLEntryException(sb.toString());
    }

    public FriendlyURLEntry fetchByG_C_C_First(long groupId, long classNameId, long classPK, OrderByComparator<FriendlyURLEntry> orderByComparator) {
        List<FriendlyURLEntry> list = this.findByG_C_C(groupId, classNameId, classPK, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public FriendlyURLEntry findByG_C_C_Last(long groupId, long classNameId, long classPK, OrderByComparator<FriendlyURLEntry> orderByComparator) throws NoSuchFriendlyURLEntryException {
        FriendlyURLEntry friendlyURLEntry = this.fetchByG_C_C_Last(groupId, classNameId, classPK, orderByComparator);
        if (friendlyURLEntry != null) {
            return friendlyURLEntry;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", classNameId=");
        sb.append(classNameId);
        sb.append(", classPK=");
        sb.append(classPK);
        sb.append("}");
        throw new NoSuchFriendlyURLEntryException(sb.toString());
    }

    public FriendlyURLEntry fetchByG_C_C_Last(long groupId, long classNameId, long classPK, OrderByComparator<FriendlyURLEntry> orderByComparator) {
        int count = this.countByG_C_C(groupId, classNameId, classPK);
        if (count == 0) {
            return null;
        }
        List<FriendlyURLEntry> list = this.findByG_C_C(groupId, classNameId, classPK, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public FriendlyURLEntry[] findByG_C_C_PrevAndNext(long friendlyURLEntryId, long groupId, long classNameId, long classPK, OrderByComparator<FriendlyURLEntry> orderByComparator) throws NoSuchFriendlyURLEntryException {
        FriendlyURLEntry friendlyURLEntry = this.findByPrimaryKey(friendlyURLEntryId);
        Session session = null;
        try {
            session = this.openSession();
            FriendlyURLEntry[] array = new FriendlyURLEntryImpl[]{this.getByG_C_C_PrevAndNext(session, friendlyURLEntry, groupId, classNameId, classPK, orderByComparator, true), friendlyURLEntry, this.getByG_C_C_PrevAndNext(session, friendlyURLEntry, groupId, classNameId, classPK, orderByComparator, false)};
            FriendlyURLEntry[] friendlyURLEntryArray = array;
            return friendlyURLEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected FriendlyURLEntry getByG_C_C_PrevAndNext(Session session, FriendlyURLEntry friendlyURLEntry, long groupId, long classNameId, long classPK, OrderByComparator<FriendlyURLEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        sb.append(_SQL_SELECT_FRIENDLYURLENTRY_WHERE);
        sb.append(_FINDER_COLUMN_G_C_C_GROUPID_2);
        sb.append(_FINDER_COLUMN_G_C_C_CLASSNAMEID_2);
        sb.append(_FINDER_COLUMN_G_C_C_CLASSPK_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY friendlyURLEntry.friendlyURLEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        queryPos.add(classNameId);
        queryPos.add(classPK);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)friendlyURLEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (FriendlyURLEntry)list.get(1);
        }
        return null;
    }

    public void removeByG_C_C(long groupId, long classNameId, long classPK) {
        for (FriendlyURLEntry friendlyURLEntry : this.findByG_C_C(groupId, classNameId, classPK, -1, -1, null)) {
            this.remove((BaseModel)friendlyURLEntry);
        }
    }

    public int countByG_C_C(long groupId, long classNameId, long classPK) {
        FinderPath finderPath = this._finderPathCountByG_C_C;
        Object[] finderArgs = new Object[]{groupId, classNameId, classPK};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_FRIENDLYURLENTRY_WHERE);
            sb.append(_FINDER_COLUMN_G_C_C_GROUPID_2);
            sb.append(_FINDER_COLUMN_G_C_C_CLASSNAMEID_2);
            sb.append(_FINDER_COLUMN_G_C_C_CLASSPK_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(classNameId);
                queryPos.add(classPK);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public FriendlyURLEntryPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(FriendlyURLEntry.class);
        this.setModelImplClass(FriendlyURLEntryImpl.class);
        this.setModelPKClass(Long.TYPE);
    }

    public void cacheResult(FriendlyURLEntry friendlyURLEntry) {
        this.entityCache.putResult(this.entityCacheEnabled, FriendlyURLEntryImpl.class, (Serializable)Long.valueOf(friendlyURLEntry.getPrimaryKey()), (Serializable)friendlyURLEntry);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, new Object[]{friendlyURLEntry.getUuid(), friendlyURLEntry.getGroupId()}, (Object)friendlyURLEntry);
        friendlyURLEntry.resetOriginalValues();
    }

    public void cacheResult(List<FriendlyURLEntry> friendlyURLEntries) {
        for (FriendlyURLEntry friendlyURLEntry : friendlyURLEntries) {
            if (this.entityCache.getResult(this.entityCacheEnabled, FriendlyURLEntryImpl.class, (Serializable)Long.valueOf(friendlyURLEntry.getPrimaryKey())) == null) {
                this.cacheResult(friendlyURLEntry);
                continue;
            }
            friendlyURLEntry.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(FriendlyURLEntryImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(FriendlyURLEntry friendlyURLEntry) {
        this.entityCache.removeResult(this.entityCacheEnabled, FriendlyURLEntryImpl.class, (Serializable)Long.valueOf(friendlyURLEntry.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((FriendlyURLEntryModelImpl)friendlyURLEntry, true);
    }

    public void clearCache(List<FriendlyURLEntry> friendlyURLEntries) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (FriendlyURLEntry friendlyURLEntry : friendlyURLEntries) {
            this.entityCache.removeResult(this.entityCacheEnabled, FriendlyURLEntryImpl.class, (Serializable)Long.valueOf(friendlyURLEntry.getPrimaryKey()));
            this.clearUniqueFindersCache((FriendlyURLEntryModelImpl)friendlyURLEntry, true);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(this.entityCacheEnabled, FriendlyURLEntryImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(FriendlyURLEntryModelImpl friendlyURLEntryModelImpl) {
        Object[] args = new Object[]{friendlyURLEntryModelImpl.getUuid(), friendlyURLEntryModelImpl.getGroupId()};
        this.finderCache.putResult(this._finderPathCountByUUID_G, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, args, (Object)friendlyURLEntryModelImpl, false);
    }

    protected void clearUniqueFindersCache(FriendlyURLEntryModelImpl friendlyURLEntryModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{friendlyURLEntryModelImpl.getUuid(), friendlyURLEntryModelImpl.getGroupId()};
            this.finderCache.removeResult(this._finderPathCountByUUID_G, args);
            this.finderCache.removeResult(this._finderPathFetchByUUID_G, args);
        }
        if ((friendlyURLEntryModelImpl.getColumnBitmask() & this._finderPathFetchByUUID_G.getColumnBitmask()) != 0L) {
            args = new Object[]{friendlyURLEntryModelImpl.getOriginalUuid(), friendlyURLEntryModelImpl.getOriginalGroupId()};
            this.finderCache.removeResult(this._finderPathCountByUUID_G, args);
            this.finderCache.removeResult(this._finderPathFetchByUUID_G, args);
        }
    }

    public FriendlyURLEntry create(long friendlyURLEntryId) {
        FriendlyURLEntryImpl friendlyURLEntry = new FriendlyURLEntryImpl();
        friendlyURLEntry.setNew(true);
        friendlyURLEntry.setPrimaryKey(friendlyURLEntryId);
        String uuid = PortalUUIDUtil.generate();
        friendlyURLEntry.setUuid(uuid);
        friendlyURLEntry.setCompanyId(CompanyThreadLocal.getCompanyId());
        return friendlyURLEntry;
    }

    public FriendlyURLEntry remove(long friendlyURLEntryId) throws NoSuchFriendlyURLEntryException {
        return this.remove(Long.valueOf(friendlyURLEntryId));
    }

    public FriendlyURLEntry remove(Serializable primaryKey) throws NoSuchFriendlyURLEntryException {
        Session session = null;
        try {
            session = this.openSession();
            FriendlyURLEntry friendlyURLEntry = (FriendlyURLEntry)session.get(FriendlyURLEntryImpl.class, primaryKey);
            if (friendlyURLEntry == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchFriendlyURLEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            FriendlyURLEntry friendlyURLEntry2 = (FriendlyURLEntry)this.remove((BaseModel)friendlyURLEntry);
            return friendlyURLEntry2;
        }
        catch (NoSuchFriendlyURLEntryException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected FriendlyURLEntry removeImpl(FriendlyURLEntry friendlyURLEntry) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)friendlyURLEntry)) {
                friendlyURLEntry = (FriendlyURLEntry)session.get(FriendlyURLEntryImpl.class, friendlyURLEntry.getPrimaryKeyObj());
            }
            if (friendlyURLEntry != null) {
                session.delete((Object)friendlyURLEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (friendlyURLEntry != null) {
            this.clearCache(friendlyURLEntry);
        }
        return friendlyURLEntry;
    }

    public FriendlyURLEntry updateImpl(FriendlyURLEntry friendlyURLEntry) {
        boolean isNew = friendlyURLEntry.isNew();
        if (!(friendlyURLEntry instanceof FriendlyURLEntryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(friendlyURLEntry.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)friendlyURLEntry);
                throw new IllegalArgumentException("Implement ModelWrapper in friendlyURLEntry proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom FriendlyURLEntry implementation " + friendlyURLEntry.getClass());
        }
        FriendlyURLEntryModelImpl friendlyURLEntryModelImpl = (FriendlyURLEntryModelImpl)friendlyURLEntry;
        if (Validator.isNull((String)friendlyURLEntry.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            friendlyURLEntry.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && friendlyURLEntry.getCreateDate() == null) {
            if (serviceContext == null) {
                friendlyURLEntry.setCreateDate(now);
            } else {
                friendlyURLEntry.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!friendlyURLEntryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                friendlyURLEntry.setModifiedDate(now);
            } else {
                friendlyURLEntry.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)friendlyURLEntry);
                friendlyURLEntry.setNew(false);
            } else {
                friendlyURLEntry = (FriendlyURLEntry)session.merge((Object)friendlyURLEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!this._columnBitmaskEnabled) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{friendlyURLEntryModelImpl.getUuid()};
            this.finderCache.removeResult(this._finderPathCountByUuid, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            args = new Object[]{friendlyURLEntryModelImpl.getUuid(), friendlyURLEntryModelImpl.getCompanyId()};
            this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            args = new Object[]{friendlyURLEntryModelImpl.getGroupId(), friendlyURLEntryModelImpl.getClassNameId(), friendlyURLEntryModelImpl.getClassPK()};
            this.finderCache.removeResult(this._finderPathCountByG_C_C, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByG_C_C, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((friendlyURLEntryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid.getColumnBitmask()) != 0L) {
                args = new Object[]{friendlyURLEntryModelImpl.getOriginalUuid()};
                this.finderCache.removeResult(this._finderPathCountByUuid, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
                args = new Object[]{friendlyURLEntryModelImpl.getUuid()};
                this.finderCache.removeResult(this._finderPathCountByUuid, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            }
            if ((friendlyURLEntryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid_C.getColumnBitmask()) != 0L) {
                args = new Object[]{friendlyURLEntryModelImpl.getOriginalUuid(), friendlyURLEntryModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
                args = new Object[]{friendlyURLEntryModelImpl.getUuid(), friendlyURLEntryModelImpl.getCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            }
            if ((friendlyURLEntryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByG_C_C.getColumnBitmask()) != 0L) {
                args = new Object[]{friendlyURLEntryModelImpl.getOriginalGroupId(), friendlyURLEntryModelImpl.getOriginalClassNameId(), friendlyURLEntryModelImpl.getOriginalClassPK()};
                this.finderCache.removeResult(this._finderPathCountByG_C_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByG_C_C, args);
                args = new Object[]{friendlyURLEntryModelImpl.getGroupId(), friendlyURLEntryModelImpl.getClassNameId(), friendlyURLEntryModelImpl.getClassPK()};
                this.finderCache.removeResult(this._finderPathCountByG_C_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByG_C_C, args);
            }
        }
        this.entityCache.putResult(this.entityCacheEnabled, FriendlyURLEntryImpl.class, (Serializable)Long.valueOf(friendlyURLEntry.getPrimaryKey()), (Serializable)friendlyURLEntry, false);
        this.clearUniqueFindersCache(friendlyURLEntryModelImpl, false);
        this.cacheUniqueFindersCache(friendlyURLEntryModelImpl);
        friendlyURLEntry.resetOriginalValues();
        return friendlyURLEntry;
    }

    public FriendlyURLEntry findByPrimaryKey(Serializable primaryKey) throws NoSuchFriendlyURLEntryException {
        FriendlyURLEntry friendlyURLEntry = (FriendlyURLEntry)this.fetchByPrimaryKey(primaryKey);
        if (friendlyURLEntry == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchFriendlyURLEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return friendlyURLEntry;
    }

    public FriendlyURLEntry findByPrimaryKey(long friendlyURLEntryId) throws NoSuchFriendlyURLEntryException {
        return this.findByPrimaryKey(Long.valueOf(friendlyURLEntryId));
    }

    public FriendlyURLEntry fetchByPrimaryKey(long friendlyURLEntryId) {
        return (FriendlyURLEntry)this.fetchByPrimaryKey(Long.valueOf(friendlyURLEntryId));
    }

    public List<FriendlyURLEntry> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<FriendlyURLEntry> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<FriendlyURLEntry> findAll(int start, int end, OrderByComparator<FriendlyURLEntry> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<FriendlyURLEntry> findAll(int start, int end, OrderByComparator<FriendlyURLEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_FRIENDLYURLENTRY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_FRIENDLYURLENTRY;
                sql = sql.concat(" ORDER BY friendlyURLEntry.friendlyURLEntryId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (FriendlyURLEntry friendlyURLEntry : this.findAll()) {
            this.remove((BaseModel)friendlyURLEntry);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_FRIENDLYURLENTRY);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "friendlyURLEntryId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_FRIENDLYURLENTRY;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return FriendlyURLEntryModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        FriendlyURLEntryModelImpl.setEntityCacheEnabled(this.entityCacheEnabled);
        FriendlyURLEntryModelImpl.setFinderCacheEnabled(this.finderCacheEnabled);
        this._finderPathWithPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, FriendlyURLEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, FriendlyURLEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByUuid = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, FriendlyURLEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, FriendlyURLEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, 16L);
        this._finderPathCountByUuid = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
        this._finderPathFetchByUUID_G = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, FriendlyURLEntryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, 24L);
        this._finderPathCountByUUID_G = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, FriendlyURLEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, FriendlyURLEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, 20L);
        this._finderPathCountByUuid_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByG_C_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, FriendlyURLEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_C_C", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByG_C_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, FriendlyURLEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_C_C", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName()}, 11L);
        this._finderPathCountByG_C_C = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_C_C", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName()});
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(FriendlyURLEntryImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.friendly.url.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this._columnBitmaskEnabled = GetterUtil.getBoolean((String)configuration.get("value.object.column.bitmask.enabled.com.liferay.friendly.url.model.FriendlyURLEntry"), (boolean)true);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.friendly.url.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.friendly.url.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }
}

