/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.friendly.url.service.impl;

import com.liferay.friendly.url.exception.DuplicateFriendlyURLEntryException;
import com.liferay.friendly.url.exception.FriendlyURLLengthException;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.model.FriendlyURLEntryLocalization;
import com.liferay.friendly.url.model.FriendlyURLEntryMapping;
import com.liferay.friendly.url.service.base.FriendlyURLEntryLocalServiceBaseImpl;
import com.liferay.friendly.url.util.comparator.FriendlyURLEntryCreateDateComparator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.friendly.url.model.FriendlyURLEntry"}, service={AopService.class})
public class FriendlyURLEntryLocalServiceImpl
extends FriendlyURLEntryLocalServiceBaseImpl {
    @Reference
    private GroupLocalService _groupLocalService;

    public FriendlyURLEntry addFriendlyURLEntry(long groupId, Class<?> clazz, long classPK, String urlTitle, ServiceContext serviceContext) throws PortalException {
        return this.addFriendlyURLEntry(groupId, this.classNameLocalService.getClassNameId(clazz), classPK, urlTitle, serviceContext);
    }

    public FriendlyURLEntry addFriendlyURLEntry(long groupId, long classNameId, long classPK, Map<String, String> urlTitleMap, ServiceContext serviceContext) throws PortalException {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
        return this.addFriendlyURLEntry(groupId, classNameId, classPK, defaultLanguageId, urlTitleMap, serviceContext);
    }

    public FriendlyURLEntry addFriendlyURLEntry(long groupId, long classNameId, long classPK, String defaultLanguageId, Map<String, String> urlTitleMap, ServiceContext serviceContext) throws PortalException {
        this.validate(groupId, classNameId, classPK, urlTitleMap);
        FriendlyURLEntryMapping friendlyURLEntryMapping = this.friendlyURLEntryMappingPersistence.fetchByC_C(classNameId, classPK);
        if (friendlyURLEntryMapping == null) {
            long friendlyURLMappingId = this.counterLocalService.increment();
            friendlyURLEntryMapping = this.friendlyURLEntryMappingPersistence.create(friendlyURLMappingId);
            friendlyURLEntryMapping.setClassNameId(classNameId);
            friendlyURLEntryMapping.setClassPK(classPK);
        } else if (this._containsAllURLTitles(friendlyURLEntryMapping, urlTitleMap)) {
            return this.friendlyURLEntryPersistence.fetchByPrimaryKey(friendlyURLEntryMapping.getFriendlyURLEntryId());
        }
        long friendlyURLEntryId = this.counterLocalService.increment();
        FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryPersistence.create(friendlyURLEntryId);
        friendlyURLEntry.setUuid(serviceContext.getUuid());
        Group group = this._groupLocalService.getGroup(groupId);
        friendlyURLEntry.setCompanyId(group.getCompanyId());
        friendlyURLEntry.setGroupId(groupId);
        friendlyURLEntry.setClassNameId(classNameId);
        friendlyURLEntry.setClassPK(classPK);
        friendlyURLEntry.setDefaultLanguageId(defaultLanguageId);
        friendlyURLEntryMapping.setFriendlyURLEntryId(friendlyURLEntryId);
        this.friendlyURLEntryMappingPersistence.update((BaseModel)friendlyURLEntryMapping);
        friendlyURLEntry = (FriendlyURLEntry)this.friendlyURLEntryPersistence.update((BaseModel)friendlyURLEntry);
        this._updateFriendlyURLEntryLocalizations(friendlyURLEntry, classNameId, classPK, urlTitleMap);
        return friendlyURLEntry;
    }

    public FriendlyURLEntry addFriendlyURLEntry(long groupId, long classNameId, long classPK, String urlTitle, ServiceContext serviceContext) throws PortalException {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
        return this.addFriendlyURLEntry(groupId, classNameId, classPK, defaultLanguageId, Collections.singletonMap(defaultLanguageId, urlTitle), serviceContext);
    }

    @Override
    public FriendlyURLEntry deleteFriendlyURLEntry(FriendlyURLEntry friendlyURLEntry) {
        this.friendlyURLEntryLocalizationPersistence.removeByFriendlyURLEntryId(friendlyURLEntry.getFriendlyURLEntryId());
        FriendlyURLEntry deletedFriendlyURLEntry = (FriendlyURLEntry)this.friendlyURLEntryPersistence.remove((BaseModel)friendlyURLEntry);
        FriendlyURLEntryMapping friendlyURLEntryMapping = this.friendlyURLEntryMappingPersistence.fetchByC_C(friendlyURLEntry.getClassNameId(), friendlyURLEntry.getClassPK());
        if (friendlyURLEntryMapping != null && friendlyURLEntryMapping.getFriendlyURLEntryId() == friendlyURLEntry.getFriendlyURLEntryId()) {
            if ((friendlyURLEntry = this.friendlyURLEntryPersistence.fetchByG_C_C_Last(friendlyURLEntry.getGroupId(), friendlyURLEntry.getClassNameId(), friendlyURLEntry.getClassPK(), (OrderByComparator)new FriendlyURLEntryCreateDateComparator())) == null) {
                this.friendlyURLEntryMappingPersistence.remove((BaseModel)friendlyURLEntryMapping);
            } else {
                friendlyURLEntryMapping.setFriendlyURLEntryId(friendlyURLEntry.getFriendlyURLEntryId());
                this.friendlyURLEntryMappingPersistence.update((BaseModel)friendlyURLEntryMapping);
            }
        }
        return deletedFriendlyURLEntry;
    }

    @Override
    public FriendlyURLEntry deleteFriendlyURLEntry(long friendlyURLEntryId) throws PortalException {
        return this.deleteFriendlyURLEntry(this.friendlyURLEntryPersistence.findByPrimaryKey(friendlyURLEntryId));
    }

    public void deleteFriendlyURLEntry(long groupId, Class<?> clazz, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(clazz);
        List friendlyURLEntries = this.friendlyURLEntryPersistence.findByG_C_C(groupId, classNameId, classPK);
        for (FriendlyURLEntry friendlyURLEntry : friendlyURLEntries) {
            this.friendlyURLEntryLocalizationPersistence.removeByFriendlyURLEntryId(friendlyURLEntry.getFriendlyURLEntryId());
            this.friendlyURLEntryPersistence.remove((BaseModel)friendlyURLEntry);
        }
        this.friendlyURLEntryMappingPersistence.removeByC_C(classNameId, classPK);
    }

    public void deleteGroupFriendlyURLEntries(long groupId, long classNameId) {
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property property = PropertyFactoryUtil.forName((String)"classNameId");
            dynamicQuery.add(property.eq((Object)classNameId));
        });
        actionableDynamicQuery.setGroupId(groupId);
        actionableDynamicQuery.setPerformActionMethod(friendlyURLEntry -> {
            this.friendlyURLEntryLocalizationPersistence.removeByFriendlyURLEntryId(friendlyURLEntry.getFriendlyURLEntryId());
            this.friendlyURLEntryPersistence.remove((BaseModel)friendlyURLEntry);
            FriendlyURLEntryMapping friendlyURLEntryMapping = this.friendlyURLEntryMappingPersistence.fetchByC_C(classNameId, friendlyURLEntry.getClassPK());
            if (friendlyURLEntryMapping != null && friendlyURLEntryMapping.getFriendlyURLEntryId() == friendlyURLEntry.getFriendlyURLEntryId()) {
                this.friendlyURLEntryMappingPersistence.remove((BaseModel)friendlyURLEntryMapping);
            }
        });
        try {
            actionableDynamicQuery.performActions();
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    public FriendlyURLEntry fetchFriendlyURLEntry(long groupId, Class<?> clazz, String urlTitle) {
        return this.fetchFriendlyURLEntry(groupId, this.classNameLocalService.getClassNameId(clazz), urlTitle);
    }

    public FriendlyURLEntry fetchFriendlyURLEntry(long groupId, long classNameId, String urlTitle) {
        FriendlyURLEntryLocalization friendlyURLEntryLocalization = this.friendlyURLEntryLocalizationPersistence.fetchByG_C_U(groupId, classNameId, FriendlyURLNormalizerUtil.normalizeWithEncoding((String)urlTitle));
        if (friendlyURLEntryLocalization != null) {
            return this.friendlyURLEntryPersistence.fetchByPrimaryKey(friendlyURLEntryLocalization.getFriendlyURLEntryId());
        }
        return null;
    }

    public FriendlyURLEntryLocalization fetchFriendlyURLEntryLocalization(long groupId, long classNameId, String urlTitle) {
        return this.friendlyURLEntryLocalizationPersistence.fetchByG_C_U(groupId, classNameId, FriendlyURLNormalizerUtil.normalizeWithEncoding((String)urlTitle));
    }

    public List<FriendlyURLEntry> getFriendlyURLEntries(long groupId, long classNameId, long classPK) {
        return this.friendlyURLEntryPersistence.findByG_C_C(groupId, classNameId, classPK);
    }

    public FriendlyURLEntry getMainFriendlyURLEntry(Class<?> clazz, long classPK) throws PortalException {
        return this.getMainFriendlyURLEntry(this.classNameLocalService.getClassNameId(clazz), classPK);
    }

    public FriendlyURLEntry getMainFriendlyURLEntry(long classNameId, long classPK) throws PortalException {
        FriendlyURLEntryMapping friendlyURLEntryMapping = this.friendlyURLEntryMappingPersistence.findByC_C(classNameId, classPK);
        return this.friendlyURLEntryPersistence.findByPrimaryKey(friendlyURLEntryMapping.getFriendlyURLEntryId());
    }

    public String getUniqueUrlTitle(long groupId, long classNameId, long classPK, String urlTitle) {
        FriendlyURLEntryLocalization friendlyURLEntryLocalization;
        String curUrlTitle;
        String normalizedUrlTitle = FriendlyURLNormalizerUtil.normalizeWithEncoding((String)urlTitle);
        int maxLength = ModelHintsUtil.getMaxLength((String)FriendlyURLEntryLocalization.class.getName(), (String)"urlTitle");
        String prefix = curUrlTitle = this._getURLEncodedSubstring(urlTitle, normalizedUrlTitle, maxLength);
        int i = 1;
        while ((friendlyURLEntryLocalization = this.friendlyURLEntryLocalizationPersistence.fetchByG_C_U(groupId, classNameId, curUrlTitle)) != null && friendlyURLEntryLocalization.getClassPK() != classPK) {
            String suffix = "-" + i;
            prefix = this._getURLEncodedSubstring(urlTitle, prefix, maxLength - suffix.length());
            curUrlTitle = FriendlyURLNormalizerUtil.normalizeWithEncoding((String)(prefix + suffix));
            ++i;
        }
        return curUrlTitle;
    }

    public void setMainFriendlyURLEntry(FriendlyURLEntry friendlyURLEntry) {
        FriendlyURLEntryMapping friendlyURLEntryMapping = this.friendlyURLEntryMappingPersistence.fetchByC_C(friendlyURLEntry.getClassNameId(), friendlyURLEntry.getClassPK());
        if (friendlyURLEntryMapping == null) {
            long friendlyURLEntryMappingId = this.counterLocalService.increment();
            friendlyURLEntryMapping = this.friendlyURLEntryMappingPersistence.create(friendlyURLEntryMappingId);
            friendlyURLEntryMapping.setClassNameId(friendlyURLEntry.getClassNameId());
            friendlyURLEntryMapping.setClassPK(friendlyURLEntry.getClassPK());
        }
        friendlyURLEntryMapping.setFriendlyURLEntryId(friendlyURLEntry.getFriendlyURLEntryId());
        this.friendlyURLEntryMappingPersistence.update((BaseModel)friendlyURLEntryMapping);
    }

    public FriendlyURLEntry updateFriendlyURLEntry(long friendlyURLEntryId, long classNameId, long classPK, String defaultLanguageId, Map<String, String> urlTitleMap) throws PortalException {
        FriendlyURLEntry friendlyURLEntry = this.friendlyURLEntryPersistence.findByPrimaryKey(friendlyURLEntryId);
        this.validate(friendlyURLEntry.getGroupId(), classNameId, classPK, urlTitleMap);
        friendlyURLEntry.setClassNameId(classNameId);
        friendlyURLEntry.setClassPK(classPK);
        friendlyURLEntry.setDefaultLanguageId(defaultLanguageId);
        friendlyURLEntry = (FriendlyURLEntry)this.friendlyURLEntryPersistence.update((BaseModel)friendlyURLEntry);
        this._updateFriendlyURLEntryLocalizations(friendlyURLEntry, classNameId, classPK, urlTitleMap);
        return friendlyURLEntry;
    }

    public FriendlyURLEntryLocalization updateFriendlyURLLocalization(FriendlyURLEntryLocalization friendlyURLEntryLocalization) {
        return (FriendlyURLEntryLocalization)this.friendlyURLEntryLocalizationPersistence.update((BaseModel)friendlyURLEntryLocalization);
    }

    public FriendlyURLEntryLocalization updateFriendlyURLLocalization(long friendlyURLLocalizationId, String urlTitle) throws PortalException {
        FriendlyURLEntryLocalization friendlyURLEntryLocalization = this.friendlyURLEntryLocalizationPersistence.fetchByPrimaryKey(friendlyURLLocalizationId);
        if (friendlyURLEntryLocalization != null) {
            friendlyURLEntryLocalization.setUrlTitle(urlTitle);
            return (FriendlyURLEntryLocalization)this.friendlyURLEntryLocalizationPersistence.update((BaseModel)friendlyURLEntryLocalization);
        }
        return null;
    }

    public void validate(long groupId, long classNameId, long classPK, Map<String, String> urlTitleMap) throws PortalException {
        for (String urlTitle : urlTitleMap.values()) {
            this.validate(groupId, classNameId, classPK, urlTitle);
        }
    }

    public void validate(long groupId, long classNameId, long classPK, String urlTitle) throws PortalException {
        int maxLength = ModelHintsUtil.getMaxLength((String)FriendlyURLEntryLocalization.class.getName(), (String)"urlTitle");
        String normalizedUrlTitle = FriendlyURLNormalizerUtil.normalizeWithEncoding((String)urlTitle);
        if (normalizedUrlTitle.length() > maxLength) {
            throw new FriendlyURLLengthException(urlTitle + " is longer than " + maxLength);
        }
        FriendlyURLEntryLocalization friendlyURLEntryLocalization = this.friendlyURLEntryLocalizationPersistence.fetchByG_C_U(groupId, classNameId, normalizedUrlTitle);
        if (friendlyURLEntryLocalization == null) {
            return;
        }
        if (classPK <= 0L || friendlyURLEntryLocalization.getClassPK() != classPK) {
            throw new DuplicateFriendlyURLEntryException(friendlyURLEntryLocalization.toString());
        }
    }

    public void validate(long groupId, long classNameId, String urlTitle) throws PortalException {
        this.validate(groupId, classNameId, 0L, urlTitle);
    }

    private boolean _containsAllURLTitles(FriendlyURLEntryMapping friendlyURLEntryMapping, Map<String, String> urlTitleMap) {
        HashMap<String, String> existUrlTitleMap = new HashMap<String, String>();
        for (FriendlyURLEntryLocalization friendlyURLEntryLocalization : this.friendlyURLEntryLocalizationPersistence.findByFriendlyURLEntryId(friendlyURLEntryMapping.getFriendlyURLEntryId())) {
            existUrlTitleMap.put(friendlyURLEntryLocalization.getLanguageId(), friendlyURLEntryLocalization.getUrlTitle());
        }
        for (Map.Entry entry : urlTitleMap.entrySet()) {
            String urlTitle = FriendlyURLNormalizerUtil.normalizeWithEncoding((String)((String)entry.getValue()));
            if (urlTitle.equals(existUrlTitleMap.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private String _getURLEncodedSubstring(String decodedString, String encodedString, int maxLength) {
        int endPos = decodedString.length();
        while (encodedString.length() > maxLength) {
            if (--endPos > 0 && Character.isHighSurrogate(decodedString.charAt(endPos - 1))) {
                --endPos;
            }
            encodedString = FriendlyURLNormalizerUtil.normalizeWithEncoding((String)decodedString.substring(0, endPos));
        }
        return encodedString;
    }

    private void _updateFriendlyURLEntryLocalizations(FriendlyURLEntry friendlyURLEntry, long classNameId, long classPK, Map<String, String> urlTitleMap) throws PortalException {
        for (Map.Entry<String, String> entry : urlTitleMap.entrySet()) {
            String normalizedUrlTitle = FriendlyURLNormalizerUtil.normalizeWithEncoding((String)entry.getValue());
            if (Validator.isNull((String)normalizedUrlTitle)) continue;
            FriendlyURLEntryLocalization existingFriendlyURLEntryLocalization = this.friendlyURLEntryLocalizationPersistence.fetchByG_C_U(friendlyURLEntry.getGroupId(), classNameId, normalizedUrlTitle);
            if (existingFriendlyURLEntryLocalization != null && existingFriendlyURLEntryLocalization.getClassPK() == classPK) {
                String existingLanguageId = existingFriendlyURLEntryLocalization.getLanguageId();
                if (!existingLanguageId.equals(entry.getKey())) {
                    String existingUrlTitle = existingFriendlyURLEntryLocalization.getUrlTitle();
                    if (existingUrlTitle.equals(urlTitleMap.get(existingLanguageId))) continue;
                    existingFriendlyURLEntryLocalization.setLanguageId(entry.getKey());
                }
                existingFriendlyURLEntryLocalization.setFriendlyURLEntryId(friendlyURLEntry.getFriendlyURLEntryId());
                this.updateFriendlyURLLocalization(existingFriendlyURLEntryLocalization);
                continue;
            }
            this.updateFriendlyURLEntryLocalization(friendlyURLEntry, entry.getKey(), normalizedUrlTitle);
        }
    }
}

