/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.portlet.internal.model.listener;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.Portal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class FragmentEntryLinkModelListener
extends BaseModelListener<FragmentEntryLink> {
    private static final Log _log = LogFactoryUtil.getLog(FragmentEntryLinkModelListener.class);
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletRegistry _portletRegistry;

    public void onAfterRemove(FragmentEntryLink fragmentEntryLink) throws ModelListenerException {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        for (String portletId : this._portletRegistry.getFragmentEntryLinkPortletIds(fragmentEntryLink)) {
            try {
                this._portletLocalService.deletePortlet(fragmentEntryLink.getCompanyId(), portletId, fragmentEntryLink.getPlid());
                this._layoutClassedModelUsageLocalService.deleteLayoutClassedModelUsages(portletId, this._portal.getClassNameId(Portlet.class), fragmentEntryLink.getPlid());
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)exception);
            }
        }
    }
}

