/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.portlet;

import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.fragment.renderer.FragmentPortletRenderer;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.impl.DefaultLayoutTypeAccessPolicyImpl;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactory;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"fragment.entry.processor.priority:Integer=3"}, service={FragmentEntryProcessor.class})
public class PortletFragmentEntryProcessor
implements FragmentEntryProcessor {
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private FragmentPortletRenderer _fragmentPortletRenderer;
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesFactory _portletPreferencesFactory;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private PortletRegistry _portletRegistry;
    private final ResourceBundle _resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());

    public void deleteFragmentEntryLinkData(FragmentEntryLink fragmentEntryLink) {
        for (String portletId : this._portletRegistry.getFragmentEntryLinkPortletIds(fragmentEntryLink)) {
            try {
                this._portletLocalService.deletePortlet(fragmentEntryLink.getCompanyId(), portletId, fragmentEntryLink.getPlid());
                this._layoutClassedModelUsageLocalService.deleteLayoutClassedModelUsages(portletId, this._portal.getClassNameId(Portlet.class), fragmentEntryLink.getPlid());
            }
            catch (Exception exception) {}
        }
    }

    public JSONArray getAvailableTagsJSONArray() {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (String alias : this._portletRegistry.getPortletAliases()) {
            StringBundler sb = new StringBundler(5);
            sb.append("<lfr-widget-");
            sb.append(alias);
            sb.append("></lfr-widget-");
            sb.append(alias);
            sb.append(">");
            jsonArray.put(JSONUtil.put((String)"content", (Object)sb.toString()).put("name", "lfr-widget-" + alias));
        }
        return jsonArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String html, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        String editableValues;
        JSONObject jsonObject;
        Document document = this._getDocument(html);
        this._validateFragmentEntryHTMLDocument(document);
        HttpServletRequest httpServletRequest = fragmentEntryProcessorContext.getHttpServletRequest();
        if (httpServletRequest != null) {
            httpServletRequest.setAttribute("FRAGMENT_ENTRY_LINK", (Object)fragmentEntryLink);
        }
        if (Validator.isNotNull((String)(jsonObject = JSONFactoryUtil.createJSONObject((String)(editableValues = fragmentEntryLink.getEditableValues()))).getString("portletId"))) {
            return this._renderWidgetHTML(editableValues, fragmentEntryProcessorContext);
        }
        FragmentEntryLink originalFragmentEntryLink = null;
        HashSet<String> processedPortletIds = new HashSet<String>();
        for (Element element : document.select("*")) {
            String tagName = element.tagName();
            String portletName = this._getPortletName(tagName);
            if (Validator.isNull((String)portletName)) continue;
            if (Validator.isNull((String)portletName)) {
                String alias = tagName.substring(11);
                throw new FragmentEntryContentException(LanguageUtil.format((ResourceBundle)this._resourceBundle, (String)"there-is-no-widget-available-for-alias-x", (Object)alias));
            }
            if (originalFragmentEntryLink == null && fragmentEntryLink.getOriginalFragmentEntryLinkId() > 0L) {
                originalFragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLink(fragmentEntryLink.getOriginalFragmentEntryLinkId());
            }
            Portlet portlet = this._portletLocalService.getPortletById(portletName);
            String instanceId = String.valueOf('0');
            String id = element.attr("id");
            if (portlet.isInstanceable()) {
                instanceId = this._getInstanceId(fragmentEntryLink.getNamespace(), id);
            } else if (processedPortletIds.contains(portletName) || this._checkNoninstanceablePortletUsed(fragmentEntryLink, portletName)) {
                throw new FragmentEntryContentException(LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"noninstanceable-widgets-can-be-embedded-only-once-on-the-same-page"));
            }
            String portletHTML = "";
            String defaultPreferences = portlet.getDefaultPreferences();
            if (Objects.equals(fragmentEntryProcessorContext.getMode(), "PREVIEW")) {
                portletHTML = this._fragmentPortletRenderer.renderPortlet(fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getHttpServletResponse(), portletName, instanceId, defaultPreferences);
            } else {
                long plid = ParamUtil.getLong((HttpServletRequest)fragmentEntryProcessorContext.getHttpServletRequest(), (String)"p_l_id");
                boolean stagingAdvicesThreadLocalEnabled = StagingAdvicesThreadLocal.isEnabled();
                try {
                    StagingAdvicesThreadLocal.setEnabled((boolean)false);
                    defaultPreferences = originalFragmentEntryLink != null ? this._getPreferences(plid, portletName, originalFragmentEntryLink, id, "") : this._getPreferences(plid, portletName, fragmentEntryLink, id, portlet.getDefaultPreferences());
                }
                finally {
                    StagingAdvicesThreadLocal.setEnabled((boolean)stagingAdvicesThreadLocalEnabled);
                }
                portletHTML = this._fragmentPortletRenderer.renderPortlet(fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getHttpServletResponse(), portletName, instanceId, this._getPreferences(plid, portletName, fragmentEntryLink, id, defaultPreferences));
            }
            Element portletElement = new Element("div");
            portletElement.attr("class", "portlet");
            portletElement.html(portletHTML);
            element.replaceWith((Node)portletElement);
            processedPortletIds.add(portletName);
        }
        Element bodyElement = document.body();
        return bodyElement.html();
    }

    public void validateFragmentEntryHTML(String html, String configuration) throws PortalException {
        this._validateFragmentEntryHTMLDocument(this._getDocument(html));
    }

    private boolean _checkNoninstanceablePortletUsed(FragmentEntryLink currentFragmentEntryLink, String currentPortletName) {
        List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinksByPlid(currentFragmentEntryLink.getGroupId(), currentFragmentEntryLink.getPlid());
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            List portletIds;
            Stream stream;
            List portletNames;
            if (currentFragmentEntryLink.getFragmentEntryLinkId() == fragmentEntryLink.getFragmentEntryLinkId() || currentFragmentEntryLink.getSegmentsExperienceId() != fragmentEntryLink.getSegmentsExperienceId() || !(portletNames = (stream = (portletIds = this._portletRegistry.getFragmentEntryLinkPortletIds(fragmentEntryLink)).stream()).map(portletId -> PortletIdCodec.decodePortletName((String)portletId)).distinct().collect(Collectors.toList())).contains(currentPortletName)) continue;
            return true;
        }
        return false;
    }

    private Document _getDocument(String html) {
        Document document = Jsoup.parseBodyFragment((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        return document;
    }

    private String _getInstanceId(String namespace, String id) {
        if (Validator.isNull((String)namespace)) {
            namespace = StringUtil.randomId();
        }
        return namespace + id;
    }

    private String _getPortletId(String portletName, String namespace, String id) {
        return PortletIdCodec.encode((String)PortletIdCodec.decodePortletName((String)portletName), (long)PortletIdCodec.decodeUserId((String)portletName), (String)this._getInstanceId(namespace, id));
    }

    private String _getPortletName(String tagName) {
        if (!StringUtil.startsWith((String)tagName, (String)"lfr-widget-")) {
            return "";
        }
        String alias = tagName.substring(11);
        return this._portletRegistry.getPortletName(alias);
    }

    private String _getPreferences(long plid, String portletName, FragmentEntryLink fragmentEntryLink, String id, String defaultPreferences) throws PortalException {
        String defaultPortletId = this._getPortletId(portletName, fragmentEntryLink.getNamespace(), id);
        javax.portlet.PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((long)fragmentEntryLink.getCompanyId(), (long)0L, (int)3, (long)fragmentEntryLink.getPlid(), (String)defaultPortletId, (String)defaultPreferences);
        String portletId = this._getPortletId(portletName, fragmentEntryLink.getNamespace(), id);
        List portletPreferencesList = this._portletPreferencesLocalService.getPortletPreferences(fragmentEntryLink.getCompanyId(), 0L, 3, portletId);
        if (ListUtil.isNotEmpty((List)portletPreferencesList)) {
            jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((long)fragmentEntryLink.getCompanyId(), (long)0L, (int)3, (long)fragmentEntryLink.getPlid(), (String)portletId, (String)PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)jxPortletPreferences));
            this._updateLayoutPortletSetup(plid, portletPreferencesList, jxPortletPreferences);
        }
        Document preferencesDocument = this._getDocument(PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)jxPortletPreferences));
        Element preferencesBody = preferencesDocument.body();
        return preferencesBody.html();
    }

    private String _renderWidgetHTML(String editableValues, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)editableValues);
        String portletId = jsonObject.getString("portletId");
        if (Validator.isNull((String)portletId)) {
            return "";
        }
        String instanceId = jsonObject.getString("instanceId");
        String encodePortletId = PortletIdCodec.encode((String)portletId, (String)instanceId);
        javax.portlet.PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getPortletPreferences((HttpServletRequest)fragmentEntryProcessorContext.getHttpServletRequest(), (String)encodePortletId);
        String html = this._fragmentPortletRenderer.renderPortlet(fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getHttpServletResponse(), portletId, instanceId, PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)portletPreferences));
        HttpServletRequest httpServletRequest = fragmentEntryProcessorContext.getHttpServletRequest();
        FragmentEntryLink fragmentEntryLink = (FragmentEntryLink)httpServletRequest.getAttribute("FRAGMENT_ENTRY_LINK");
        if (fragmentEntryLink != null) {
            String checkAccessAllowedToPortletCacheKey = StringBundler.concat((Object[])new Object[]{"LIFERAY_SHARED_", DefaultLayoutTypeAccessPolicyImpl.class.getName(), "#", ParamUtil.getLong((HttpServletRequest)fragmentEntryProcessorContext.getHttpServletRequest(), (String)"p_l_id"), "#", encodePortletId});
            httpServletRequest.setAttribute("ACCESS_ALLOWED_TO_FRAGMENT_ENTRY_LINK_ID_" + fragmentEntryLink.getFragmentEntryLinkId(), (Object)GetterUtil.getBoolean((Object)httpServletRequest.getAttribute(checkAccessAllowedToPortletCacheKey), (boolean)true));
        }
        return html;
    }

    private void _updateLayoutPortletSetup(long layoutPlid, List<PortletPreferences> portletPreferencesList, javax.portlet.PortletPreferences jxPortletPreferences) {
        String portletPreferencesXml = PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)jxPortletPreferences);
        long plid = 0L;
        if (jxPortletPreferences instanceof PortletPreferencesImpl) {
            plid = layoutPlid;
        }
        for (PortletPreferences portletPreferencesImpl : portletPreferencesList) {
            if (plid != portletPreferencesImpl.getPlid() || Objects.equals(portletPreferencesImpl.getPreferences(), portletPreferencesXml)) continue;
            portletPreferencesImpl.setPreferences(portletPreferencesXml);
            this._portletPreferencesLocalService.updatePortletPreferences(portletPreferencesImpl);
        }
    }

    private void _validateFragmentEntryHTMLDocument(Document document) throws PortalException {
        for (Element element : document.select("*")) {
            Portlet portlet;
            Elements elements;
            String htmlTagName = element.tagName();
            if (!StringUtil.startsWith((String)htmlTagName, (String)"lfr-widget-")) continue;
            String alias = StringUtil.removeSubstring((String)htmlTagName, (String)"lfr-widget-");
            if (Validator.isNull((String)this._portletRegistry.getPortletName(alias))) {
                throw new FragmentEntryContentException(LanguageUtil.format((ResourceBundle)this._resourceBundle, (String)"there-is-no-widget-available-for-alias-x", (Object)alias));
            }
            String id = element.id();
            if (Validator.isNotNull((String)id) && !Validator.isAlphanumericName((String)id)) {
                throw new FragmentEntryContentException(LanguageUtil.format((ResourceBundle)this._resourceBundle, (String)"widget-id-must-contain-only-alphanumeric-characters", (Object)alias));
            }
            if (Validator.isNotNull((String)id)) {
                elements = document.select("#" + id);
                if (elements.size() > 1) {
                    throw new FragmentEntryContentException(LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"widget-id-must-be-unique"));
                }
                if (id.length() > GetterUtil.getInteger((String)"75")) {
                    throw new FragmentEntryContentException(LanguageUtil.format((ResourceBundle)this._resourceBundle, (String)"widget-id-cannot-exceed-x-characters", (Object)"75"));
                }
            }
            if ((elements = document.select(htmlTagName)).size() > 1 && Validator.isNull((String)id)) {
                throw new FragmentEntryContentException(LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"duplicate-widgets-within-the-same-fragment-must-have-an-id"));
            }
            if (elements.size() <= 1 || (portlet = this._portletLocalService.getPortletById(this._portletRegistry.getPortletName(alias))).isInstanceable()) continue;
            throw new FragmentEntryContentException(LanguageUtil.format((ResourceBundle)this._resourceBundle, (String)"you-cannot-add-the-widget-x-more-than-once", (Object)alias));
        }
    }
}

