/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.freemarker;

import com.liferay.fragment.entry.processor.freemarker.internal.configuration.FreeMarkerFragmentEntryProcessorConfiguration;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.input.template.parser.InputTemplateNode;
import com.liferay.fragment.processor.FragmentEntryValidator;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.petra.io.DummyWriter;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.servlet.DummyHttpServletResponse;
import com.liferay.portal.kernel.servlet.taglib.aui.ScriptData;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"fragment.entry.processor.priority:Integer=1"}, service={FragmentEntryValidator.class})
public class FreeMarkerFragmentEntryValidator
implements FragmentEntryValidator {
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;
    @Reference
    private Language _language;

    public void validateFragmentEntryHTML(String html, String configuration, Locale locale) throws PortalException {
        FreeMarkerFragmentEntryProcessorConfiguration freeMarkerFragmentEntryProcessorConfiguration = (FreeMarkerFragmentEntryProcessorConfiguration)this._configurationProvider.getCompanyConfiguration(FreeMarkerFragmentEntryProcessorConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
        if (!freeMarkerFragmentEntryProcessorConfiguration.enable() || !this._isFreeMarkerTemplate(html)) {
            return;
        }
        HttpServletRequest httpServletRequest = null;
        HttpServletResponse httpServletResponse = null;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null) {
            httpServletRequest = serviceContext.getRequest();
            httpServletResponse = serviceContext.getResponse();
        }
        if (httpServletRequest == null || httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY") == null) {
            return;
        }
        if (httpServletResponse == null) {
            httpServletResponse = new DummyHttpServletResponse();
        }
        ScriptData scriptData = (ScriptData)httpServletRequest.getAttribute("LIFERAY_SHARED_AUI_SCRIPT_DATA");
        try {
            httpServletRequest.setAttribute("LIFERAY_SHARED_AUI_SCRIPT_DATA", (Object)new ScriptData());
            JSONObject configurationDefaultValuesJSONObject = this._fragmentEntryConfigurationParser.getConfigurationDefaultValuesJSONObject(configuration);
            Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)new StringTemplateResource("template_id", "[#ftl] " + html), (boolean)true);
            template.putAll((Map)HashMapBuilder.put((Object)"configuration", (Object)configurationDefaultValuesJSONObject).put((Object)"fragmentElementId", (Object)"").put((Object)"fragmentEntryLinkNamespace", (Object)"").put((Object)"input", (Object)new InputTemplateNode("", "", "", "name", false, false, false, false, "type", "value")).put((Object)"layoutMode", (Object)"view").putAll(this._fragmentEntryConfigurationParser.getContextObjects(configurationDefaultValuesJSONObject, configuration, null, new long[0])).build());
            template.prepareTaglib(httpServletRequest, httpServletResponse);
            template.prepare(httpServletRequest);
            template.processTemplate((Writer)new DummyWriter());
        }
        catch (TemplateException templateException) {
            throw new FragmentEntryContentException(this._getMessage(templateException, locale), (Throwable)templateException);
        }
        finally {
            httpServletRequest.setAttribute("LIFERAY_SHARED_AUI_SCRIPT_DATA", (Object)scriptData);
        }
    }

    private String _getMessage(TemplateException templateException, Locale locale) {
        String message = this._language.get(locale, "freemarker-syntax-is-invalid");
        Throwable causeThrowable = templateException.getCause();
        String causeThrowableMessage = causeThrowable.getLocalizedMessage();
        if (Validator.isNotNull((String)causeThrowableMessage)) {
            message = message + "\n\n" + causeThrowableMessage;
        }
        return message;
    }

    private boolean _isFreeMarkerTemplate(String html) {
        return html.contains("${") || html.contains("[#") || html.contains("[@");
    }
}

