/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable.internal.mapper;

import com.liferay.fragment.entry.processor.editable.mapper.EditableElementMapper;
import com.liferay.fragment.entry.processor.helper.LayoutReferenceResolver;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.info.localized.bundle.FunctionInfoLocalizedValue;
import com.liferay.info.type.WebURL;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import org.jsoup.nodes.Element;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"type=action"}, service={EditableElementMapper.class})
public class ActionEditableElementMapper
implements EditableElementMapper {
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private LayoutReferenceResolver _layoutReferenceResolver;
    @Reference
    private Portal _portal;

    public void map(Element element, JSONObject configJSONObject, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        JSONObject mappedActionJSONObject = configJSONObject.getJSONObject("mappedAction");
        if (mappedActionJSONObject == null) {
            return;
        }
        String fieldId = mappedActionJSONObject.getString("fieldId");
        if (Validator.isNull((String)fieldId)) {
            fieldId = mappedActionJSONObject.getString("collectionFieldId");
        }
        if (Validator.isNull((String)fieldId)) {
            fieldId = mappedActionJSONObject.getString("mappedField");
        }
        if (Validator.isNull((String)fieldId)) {
            return;
        }
        long classNameId = mappedActionJSONObject.getLong("classNameId");
        long classPK = mappedActionJSONObject.getLong("classPK");
        if (classNameId == 0L || classPK == 0L) {
            InfoItemReference infoItemReference = fragmentEntryProcessorContext.getContextInfoItemReference();
            if (infoItemReference == null) {
                return;
            }
            classNameId = this._portal.getClassNameId(infoItemReference.getClassName());
            InfoItemIdentifier infoItemIdentifier = infoItemReference.getInfoItemIdentifier();
            if (infoItemIdentifier instanceof ClassPKInfoItemIdentifier) {
                ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)infoItemIdentifier;
                classPK = classPKInfoItemIdentifier.getClassPK();
            }
            if (classNameId == 0L || classPK == 0L) {
                return;
            }
        }
        element.attr("data-lfr-class-name-id", String.valueOf(classNameId));
        element.attr("data-lfr-class-pk", String.valueOf(classPK));
        element.attr("data-lfr-field-id", fieldId);
        this._addDataAtributes(classNameId, classPK, element, configJSONObject.getJSONObject("onError"), "error");
        this._addDataAtributes(classNameId, classPK, element, configJSONObject.getJSONObject("onSuccess"), "success");
    }

    private void _addDataAtributes(long classNameId, long classPK, Element element, JSONObject jsonObject, String resultType) throws PortalException {
        ServiceContext serviceContext;
        if (jsonObject == null) {
            return;
        }
        String interaction = jsonObject.getString("interaction");
        if (Validator.isNull((String)interaction)) {
            interaction = "none";
        }
        element.attr("data-lfr-on-" + resultType + "-interaction", interaction);
        if ((interaction.equals("none") || interaction.equals("notification")) && jsonObject.getBoolean("reload")) {
            element.attr("data-lfr-on-" + resultType + "-reload", "true");
        }
        if ((serviceContext = ServiceContextThreadLocal.getServiceContext()) == null) {
            return;
        }
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        if (themeDisplay == null) {
            return;
        }
        if (interaction.equals("displayPage")) {
            if (!resultType.equals("success")) {
                return;
            }
            String className = this._portal.fetchClassName(classNameId);
            InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemObjectProvider.class, className, ClassPKInfoItemIdentifier.INFO_ITEM_SERVICE_FILTER);
            if (infoItemObjectProvider == null) {
                return;
            }
            InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemFieldValuesProvider.class, className);
            if (infoItemFieldValuesProvider == null) {
                return;
            }
            Object infoItem = infoItemObjectProvider.getInfoItem((InfoItemIdentifier)new ClassPKInfoItemIdentifier(classPK));
            if (infoItem == null) {
                return;
            }
            InfoFieldValue infoFieldValue = infoItemFieldValuesProvider.getInfoFieldValue(infoItem, jsonObject.getString("displayPageUniqueFieldId"));
            if (infoFieldValue == null) {
                return;
            }
            String url = null;
            Object infoFieldValueValue = infoFieldValue.getValue();
            if (infoFieldValueValue instanceof FunctionInfoLocalizedValue) {
                FunctionInfoLocalizedValue functionInfoLocalizedValue = (FunctionInfoLocalizedValue)infoFieldValueValue;
                Object value = functionInfoLocalizedValue.getValue();
                if (!(value instanceof WebURL)) {
                    return;
                }
                WebURL webURL = (WebURL)value;
                url = webURL.getURL();
            } else if (infoFieldValueValue instanceof String) {
                url = (String)infoFieldValueValue;
            }
            if (Validator.isNull(url)) {
                return;
            }
            element.attr("data-lfr-on-" + resultType + "-page-url", url);
        }
        if (interaction.equals("notification")) {
            JSONObject textJSONObject = jsonObject.getJSONObject("text");
            if (textJSONObject == null) {
                return;
            }
            String text = textJSONObject.getString(themeDisplay.getLanguageId());
            if (Validator.isNull((String)text)) {
                return;
            }
            element.attr("data-lfr-on-" + resultType + "-text", text);
        } else if (interaction.equals("page")) {
            JSONObject pageJSONObject = jsonObject.getJSONObject("page");
            if (pageJSONObject == null) {
                return;
            }
            Layout layout = this._layoutReferenceResolver.resolve(themeDisplay.getCompanyId(), pageJSONObject, themeDisplay.getScopeGroupId());
            if (layout == null) {
                return;
            }
            element.attr("data-lfr-on-" + resultType + "-page-url", this._portal.getLayoutURL(layout, themeDisplay));
        } else if (interaction.equals("url")) {
            JSONObject urlJSONObject = jsonObject.getJSONObject("url");
            if (urlJSONObject == null) {
                return;
            }
            String url = urlJSONObject.getString(themeDisplay.getLanguageId());
            if (Validator.isNull((String)url)) {
                Locale locale = LocaleUtil.getSiteDefault();
                url = urlJSONObject.getString(locale.getLanguage());
            }
            if (Validator.isNull((String)url)) {
                return;
            }
            element.attr("data-lfr-on-" + resultType + "-page-url", url);
        }
    }
}

