/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable;

import com.liferay.fragment.entry.processor.editable.parser.EditableElementParser;
import com.liferay.fragment.entry.processor.util.EditableFragmentEntryProcessorUtil;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.processor.DocumentFragmentEntryValidator;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashSet;
import java.util.Locale;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"fragment.entry.processor.priority:Integer=2"}, service={DocumentFragmentEntryValidator.class})
public class EditableFragmentEntryValidator
implements DocumentFragmentEntryValidator {
    @Reference
    private Language _language;
    private ServiceTrackerMap<String, EditableElementParser> _serviceTrackerMap;

    public void validateFragmentEntryHTML(Document document, String configuration, Locale locale) throws PortalException {
        HashSet<String> ids = new HashSet<String>();
        for (Element element : document.select("lfr-editable,*[data-lfr-editable-id]")) {
            String id = EditableFragmentEntryProcessorUtil.getElementId((Element)element);
            if (Validator.isNull((String)id) || !ids.add(id)) {
                throw new FragmentEntryContentException(this._language.get(locale, "you-must-define-a-unique-id-for-each-editable-element"));
            }
            String type = EditableFragmentEntryProcessorUtil.getElementType((Element)element);
            EditableElementParser editableElementParser = (EditableElementParser)this._serviceTrackerMap.getService((Object)type);
            if (editableElementParser == null) {
                throw new FragmentEntryContentException(this._language.get(locale, "you-must-define-a-valid-type-for-each-editable-element"));
            }
            editableElementParser.validate(element);
        }
        for (Element element : document.getElementsByAttribute("data-lfr-editable-type")) {
            if (!Validator.isNull((String)element.attr("data-lfr-editable-id"))) continue;
            throw new FragmentEntryContentException(this._language.get(locale, "you-must-define-a-unique-id-for-each-editable-element"));
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, EditableElementParser.class, (String)"type");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

