/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable.internal.mapper;

import com.liferay.fragment.entry.processor.editable.mapper.EditableElementMapper;
import com.liferay.fragment.entry.processor.editable.parser.util.EditableElementParserUtil;
import com.liferay.fragment.entry.processor.helper.FragmentEntryProcessorHelper;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"type=link"}, service={EditableElementMapper.class})
public class LinkEditableElementMapper
implements EditableElementMapper {
    @Reference
    private FragmentEntryProcessorHelper _fragmentEntryProcessorHelper;

    @Override
    public void map(Element element, JSONObject configJSONObject, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        String href = configJSONObject.getString("href");
        boolean assetDisplayPage = this._fragmentEntryProcessorHelper.isAssetDisplayPage(fragmentEntryProcessorContext.getMode());
        boolean collectionMapped = this._fragmentEntryProcessorHelper.isMappedCollection(configJSONObject);
        boolean mapped = this._fragmentEntryProcessorHelper.isMapped(configJSONObject);
        if (Validator.isNull((String)href) && !assetDisplayPage && !collectionMapped && !mapped) {
            return;
        }
        if (collectionMapped) {
            href = GetterUtil.getString((Object)this._fragmentEntryProcessorHelper.getMappedCollectionValue(configJSONObject, fragmentEntryProcessorContext));
        } else if (mapped) {
            href = GetterUtil.getString((Object)this._fragmentEntryProcessorHelper.getMappedInfoItemFieldValue(configJSONObject, new HashMap(), fragmentEntryProcessorContext));
        }
        Element linkElement = new Element("a");
        Elements elements = element.children();
        Element firstChildElement = elements.first();
        boolean processEditableTag = false;
        if (StringUtil.equalsIgnoreCase((String)element.tagName(), (String)"a")) {
            linkElement = element;
        } else if (StringUtil.equalsIgnoreCase((String)element.tagName(), (String)"lfr-editable")) {
            processEditableTag = true;
        }
        boolean replaceLink = false;
        if (firstChildElement != null && processEditableTag && StringUtil.equalsIgnoreCase((String)firstChildElement.tagName(), (String)"a")) {
            linkElement = firstChildElement;
            replaceLink = true;
        }
        if (configJSONObject.has("target")) {
            linkElement.attr("target", configJSONObject.getString("target"));
        }
        String mappedField = configJSONObject.getString("mappedField");
        if (Validator.isNotNull((String)href)) {
            linkElement.attr("href", href);
            this._replaceLinkContent(element, firstChildElement, linkElement, replaceLink);
            if ((linkElement != element || processEditableTag) && Validator.isNotNull((String)element.html())) {
                element.html(linkElement.outerHtml());
            } else if (linkElement != element && Validator.isNull((String)element.html())) {
                element.replaceWith((Node)linkElement);
            }
        } else if (assetDisplayPage && Validator.isNotNull((String)mappedField)) {
            linkElement.attr("href", "${" + mappedField + "}");
            this._replaceLinkContent(element, firstChildElement, linkElement, replaceLink);
            if (processEditableTag) {
                element.html(this._fragmentEntryProcessorHelper.processTemplate(linkElement.outerHtml(), fragmentEntryProcessorContext));
            } else {
                element.replaceWith((Node)EditableElementParserUtil.getDocumentBody(this._fragmentEntryProcessorHelper.processTemplate(linkElement.outerHtml(), fragmentEntryProcessorContext)));
            }
        }
    }

    private void _replaceLinkContent(Element element, Element firstChildElement, Element linkElement, boolean replaceLink) {
        if (replaceLink && Validator.isNull((String)firstChildElement.html())) {
            linkElement.html(firstChildElement.outerHtml());
        } else if (replaceLink && Validator.isNotNull((String)firstChildElement.html())) {
            linkElement.html(firstChildElement.html());
        } else if (Validator.isNull((String)element.html())) {
            linkElement.html(element.outerHtml());
        } else {
            linkElement.html(element.html());
        }
    }
}

