/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable.internal.parser;

import com.liferay.fragment.entry.processor.editable.EditableFragmentEntryProcessor;
import com.liferay.fragment.entry.processor.editable.parser.EditableElementParser;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"type=image"}, service={EditableElementParser.class})
public class ImageEditableElementParser
implements EditableElementParser {
    private static final String _TMPL_IMAGE_FIELD_ALT_TEMPLATE = StringUtil.read(EditableFragmentEntryProcessor.class, (String)"/META-INF/resources/fragment/entry/processor/editable/image_field_alt_template.tmpl");
    private static final String _TMPL_IMAGE_FIELD_TEMPLATE = StringUtil.read(EditableFragmentEntryProcessor.class, (String)"/META-INF/resources/fragment/entry/processor/editable/image_field_template.tmpl");
    private static final Log _log = LogFactoryUtil.getLog(ImageEditableElementParser.class);
    @Reference
    private Html _html;

    @Override
    public String getFieldTemplate() {
        return _TMPL_IMAGE_FIELD_TEMPLATE;
    }

    @Override
    public JSONObject getFieldTemplateConfigJSONObject(String fieldName, Locale locale, Object fieldValue) {
        String alt = "";
        if (fieldValue == null) {
            alt = StringUtil.replace((String)_TMPL_IMAGE_FIELD_ALT_TEMPLATE, (String)"field_name", (String)fieldName);
        } else if (fieldValue instanceof JSONObject) {
            JSONObject fieldValueJSONObject = (JSONObject)fieldValue;
            alt = fieldValueJSONObject.getString("alt");
        }
        return JSONUtil.put((String)"alt", (Object)alt);
    }

    @Override
    public String getValue(Element element) {
        Elements elements = element.getElementsByTag("img");
        if (ListUtil.isEmpty((List)elements)) {
            return "";
        }
        Element replaceableElement = (Element)elements.get(0);
        return replaceableElement.attr("src");
    }

    @Override
    public String parseFieldValue(Object fieldValue) {
        if (!(fieldValue instanceof JSONObject)) {
            return "";
        }
        JSONObject jsonObject = (JSONObject)fieldValue;
        return GetterUtil.getString((String)jsonObject.getString("url"));
    }

    @Override
    public void replace(Element element, String value) {
        this.replace(element, value, null);
    }

    @Override
    public void replace(Element element, String value, JSONObject configJSONObject) {
        String imageLink;
        Elements elements = element.getElementsByTag("img");
        if (ListUtil.isEmpty((List)elements)) {
            return;
        }
        Element replaceableElement = (Element)elements.get(0);
        if (value.startsWith("{")) {
            try {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)value);
                value = jsonObject.getString("url");
            }
            catch (JSONException jsonException) {
                _log.error((Object)("Unable to parse JSON value " + value));
                value = "";
            }
        }
        if (Validator.isNotNull((String)(value = value.trim()))) {
            replaceableElement.attr("src", this._html.unescape(value));
        }
        if (configJSONObject == null) {
            return;
        }
        String alt = configJSONObject.getString("alt");
        if (Validator.isNotNull((String)alt)) {
            replaceableElement.attr("alt", StringUtil.trim((String)this._html.unescape(alt)));
        }
        if (Validator.isNull((String)(imageLink = configJSONObject.getString("imageLink")))) {
            return;
        }
        String imageTarget = configJSONObject.getString("imageTarget");
        Element linkElement = new Element("a");
        linkElement.attr("href", imageLink);
        if (Validator.isNotNull((String)imageTarget)) {
            linkElement.attr("target", imageTarget);
        }
        linkElement.html(element.html());
        element.html(linkElement.outerHtml());
    }

    @Override
    public void validate(Element element) throws FragmentEntryContentException {
        Elements elements = element.getElementsByTag("img");
        if (elements.size() != 1) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            throw new FragmentEntryContentException(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"each-editable-image-element-must-contain-an-img-tag", (Object[])new Object[]{"<em>", "</em>"}, (boolean)false));
        }
    }
}

