/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

const slide = fragmentElement.querySelector('.slide');
const indicators = Array.from(
	fragmentElement.querySelectorAll('.carousel-indicators > li')
);
const carouselControls = Array.from(
	fragmentElement.querySelectorAll(
		'.carousel-control-prev, .carousel-control-next'
	)
);
const carouselId = fragmentElement.id + '-carousel';

slide.id = carouselId;
indicators.forEach(function(indicator) {
	indicator.dataset.target = '#' + carouselId;
});
carouselControls.forEach(function(control) {
	control.href = '#' + carouselId;
});

slide.classList.add('carousel');

if (document.querySelector('.has-edit-mode-menu')) {
	$(slide).carousel('pause');
	$('.carousel').off('keydown.bs.carousel');
} else {
	$(slide).carousel({ride: 'carousel'});
}
