/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.flags.internal.messaging;

import com.liferay.flags.configuration.FlagsGroupServiceConfiguration;
import com.liferay.flags.internal.messaging.FlagsRequest;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SubscriptionSender;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/flags"}, service={MessageListener.class})
public class FlagsRequestMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(FlagsRequestMessageListener.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private DestinationFactory _destinationFactory;
    private ServiceRegistration<Destination> _destinationServiceRegistration;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserGroupGroupRoleLocalService _userGroupGroupRoleLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("parallel", "liferay/flags");
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        this._destinationServiceRegistration = bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName()));
    }

    @Deactivate
    protected void deactivate() {
        this._destinationServiceRegistration.unregister();
    }

    protected void doReceive(Message message) throws Exception {
        FlagsRequest flagsRequest = (FlagsRequest)message.getPayload();
        ServiceContext serviceContext = flagsRequest.getServiceContext();
        long companyId = serviceContext.getCompanyId();
        Layout layout = this._layoutLocalService.getLayout(serviceContext.getPlid());
        Group group = layout.getGroup();
        String reporterUserName = null;
        String reporterEmailAddress = null;
        User reporterUser = this._userLocalService.getUserById(serviceContext.getUserId());
        Locale locale = LocaleUtil.getDefault();
        if (reporterUser.isGuestUser()) {
            reporterUserName = this._language.get(locale, "anonymous");
        } else {
            reporterUserName = reporterUser.getFullName();
            reporterEmailAddress = reporterUser.getEmailAddress();
        }
        String reportedUserName = "";
        String reportedEmailAddress = "";
        String reportedURL = "";
        User reportedUser = this._userLocalService.getUserById(flagsRequest.getReportedUserId());
        if (reportedUser.isGuestUser()) {
            reportedUserName = group.getDescriptiveName();
        } else {
            reportedUserName = reportedUser.getFullName();
            reportedEmailAddress = reportedUser.getEmailAddress();
            reportedURL = reportedUser.getDisplayURL(serviceContext.getThemeDisplay());
        }
        String contentType = ResourceActionsUtil.getModelResource((Locale)locale, (String)flagsRequest.getClassName());
        String reason = this._language.get(locale, flagsRequest.getReason());
        FlagsGroupServiceConfiguration flagsGroupServiceConfiguration = (FlagsGroupServiceConfiguration)this._configurationProvider.getCompanyConfiguration(FlagsGroupServiceConfiguration.class, companyId);
        String fromName = flagsGroupServiceConfiguration.emailFromName();
        String fromAddress = flagsGroupServiceConfiguration.emailFromAddress();
        String subject = StringUtil.read((ClassLoader)FlagsRequestMessageListener.class.getClassLoader(), (String)flagsGroupServiceConfiguration.emailSubject());
        String body = StringUtil.read((ClassLoader)FlagsRequestMessageListener.class.getClassLoader(), (String)flagsGroupServiceConfiguration.emailBody());
        Set<User> users = this._getRecipients(companyId, serviceContext.getScopeGroupId());
        for (User user : users) {
            try {
                this._notify(reporterUser.getUserId(), group, reporterEmailAddress, reporterUserName, reportedEmailAddress, reportedUserName, reportedURL, flagsRequest.getClassPK(), flagsRequest.getContentTitle(), contentType, flagsRequest.getContentURL(), reason, fromName, fromAddress, user.getFullName(), user.getEmailAddress(), subject, body, serviceContext);
            }
            catch (IOException ioException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Throwable)ioException);
            }
        }
    }

    private String _getGroupDescriptiveName(Group group, Locale locale) {
        try {
            return group.getDescriptiveName(locale);
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to get descriptive name for group " + group.getGroupId()), (Throwable)portalException);
            return "";
        }
    }

    private Set<User> _getRecipients(long companyId, long groupId) throws Exception {
        LinkedHashSet<User> users = new LinkedHashSet<User>();
        ArrayList<String> roleNames = new ArrayList<String>();
        Group group = this._groupLocalService.getGroup(groupId);
        if (group.isSite()) {
            roleNames.add("Site Administrator");
            roleNames.add("Site Owner");
        }
        if (group.isCompany()) {
            roleNames.add("Administrator");
        } else if (group.isOrganization()) {
            roleNames.add("Organization Administrator");
            roleNames.add("Organization Owner");
        }
        for (String roleName : roleNames) {
            Role role = this._roleLocalService.getRole(companyId, roleName);
            List userGroupRoles = this._userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(groupId, role.getRoleId());
            for (UserGroupRole userGroupRole : userGroupRoles) {
                users.add(userGroupRole.getUser());
            }
            List userGroupGroupRoles = this._userGroupGroupRoleLocalService.getUserGroupGroupRolesByGroupAndRole(groupId, role.getRoleId());
            for (UserGroupGroupRole userGroupGroupRole : userGroupGroupRoles) {
                users.addAll(this._userLocalService.getUserGroupUsers(userGroupGroupRole.getUserGroupId()));
            }
        }
        if (users.isEmpty()) {
            Role role = this._roleLocalService.getRole(companyId, "Administrator");
            users.addAll(this._userLocalService.getRoleUsers(role.getRoleId()));
        }
        return users;
    }

    private void _notify(long reporterUserId, Group group, String reporterEmailAddress, String reporterUserName, String reportedEmailAddress, String reportedUserName, String reportedUserURL, long contentId, String contentTitle, String contentType, String contentURL, String reason, String fromName, String fromAddress, String toName, String toAddress, String subject, String body, ServiceContext serviceContext) throws Exception {
        Date date = new Date();
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setBody(body);
        subscriptionSender.setContextAttributes(new Object[]{"[$CONTENT_ID$]", contentId, "[$CONTENT_TITLE$]", contentTitle, "[$CONTENT_TYPE$]", contentType, "[$CONTENT_URL$]", contentURL, "[$DATE$]", date.toString(), "[$REASON$]", reason, "[$REPORTED_USER_ADDRESS$]", reportedEmailAddress, "[$REPORTED_USER_NAME$]", reportedUserName, "[$REPORTED_USER_URL$]", reportedUserURL, "[$REPORTER_USER_ADDRESS$]", reporterEmailAddress, "[$REPORTER_USER_NAME$]", reporterUserName});
        subscriptionSender.setCreatorUserId(reporterUserId);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedContextAttributeWithFunction("[$SITE_NAME$]", locale -> this._getGroupDescriptiveName(group, (Locale)locale));
        subscriptionSender.setMailId("flags_request", new Object[]{contentId});
        subscriptionSender.setPortletId("com_liferay_flags_web_portlet_FlagsPortlet");
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setSubject(subject);
        subscriptionSender.addRuntimeSubscribers(toAddress, toName);
        subscriptionSender.flushNotificationsAsync();
    }
}

