/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.data.handler;

import com.liferay.batch.engine.constants.CreateStrategy;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.vulcan.batch.engine.ExportImportVulcanBatchEngineTaskItemDelegate;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.staging.StagingGroupHelper;
import java.io.Serializable;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchEnginePortletDataHandlerUtil {
    private static final Format _format = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");

    public static Map<String, Serializable> buildDeleteParameters(ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor exportImportDescriptor, GroupLocalService groupLocalService, PortletDataContext portletDataContext, StagingGroupHelper stagingGroupHelper) {
        HashMap deleteParameters = HashMapBuilder.putAll((Map)exportImportDescriptor.getParameters(portletDataContext)).build();
        Group group = groupLocalService.fetchGroup(portletDataContext.getScopeGroupId());
        if (!BatchEnginePortletDataHandlerUtil._isCompanyScoped(group, stagingGroupHelper)) {
            deleteParameters.put("siteExternalReferenceCode", group.getExternalReferenceCode());
            deleteParameters.put("siteId", group.getGroupId());
        }
        return deleteParameters;
    }

    public static Map<String, Serializable> buildExportParameters(ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor exportImportDescriptor, GroupLocalService groupLocalService, PortletDataContext portletDataContext, StagingGroupHelper stagingGroupHelper) {
        HashMap exportParameters = HashMapBuilder.put((Object)"batchNestedFields", () -> {
            ArrayList<String> batchNestedFields = new ArrayList<String>();
            batchNestedFields.add("customFields.attributeType");
            if (MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"COMMENTS")) {
                batchNestedFields.add("comments");
            }
            if (MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"PERMISSIONS")) {
                batchNestedFields.add("permissions");
            }
            if (ListUtil.isNotEmpty((List)exportImportDescriptor.getNestedFields())) {
                batchNestedFields.addAll(exportImportDescriptor.getNestedFields());
            }
            if (batchNestedFields.isEmpty()) {
                return null;
            }
            return StringUtil.merge(batchNestedFields, (String)",");
        }).put((Object)"filter", () -> {
            if (portletDataContext.getEndDate() == null && portletDataContext.getStartDate() == null) {
                return null;
            }
            StringBundler sb = new StringBundler(5);
            if (portletDataContext.getEndDate() != null) {
                sb.append("dateModified le ");
                sb.append(_format.format(portletDataContext.getEndDate()));
            }
            if (portletDataContext.getStartDate() != null) {
                if (sb.length() > 0) {
                    sb.append(" and ");
                }
                sb.append("dateModified ge ");
                sb.append(_format.format(portletDataContext.getStartDate()));
            }
            return sb.toString();
        }).put((Object)"modelClassName", (Object)exportImportDescriptor.getModelClassName()).put((Object)"modelNameLanguageKey", (Object)exportImportDescriptor.getLabelLanguageKey()).putAll(exportImportDescriptor.getParameters(portletDataContext)).build();
        Group group = groupLocalService.fetchGroup(portletDataContext.getScopeGroupId());
        if (!BatchEnginePortletDataHandlerUtil._isCompanyScoped(group, stagingGroupHelper)) {
            exportParameters.put("siteExternalReferenceCode", group.getExternalReferenceCode());
            Map map = portletDataContext.getParameterMap();
            Object[] siteIds = GetterUtil.getStringValues((String[])((String[])map.get("siteId")));
            if (ArrayUtil.isNotEmpty((Object[])siteIds)) {
                exportParameters.put("siteId", siteIds[0]);
            } else {
                exportParameters.put("siteId", group.getGroupId());
            }
        }
        return exportParameters;
    }

    public static Map<String, Serializable> buildImportParameters(ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor exportImportDescriptor, GroupLocalService groupLocalService, PortletDataContext portletDataContext, StagingGroupHelper stagingGroupHelper) {
        HashMap importParameters = HashMapBuilder.put((Object)"batchRestrictFields", () -> {
            ArrayList<String> batchRestrictFields = new ArrayList<String>();
            if (!MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"COMMENTS")) {
                batchRestrictFields.add("comments");
            }
            if (!MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"PERMISSIONS")) {
                batchRestrictFields.add("permissions");
            }
            if (batchRestrictFields.isEmpty()) {
                return null;
            }
            return StringUtil.merge(batchRestrictFields, (String)",");
        }).put((Object)"createStrategy", (Object)CreateStrategy.UPSERT.getDBOperation()).put((Object)"importCreatorStrategy", () -> {
            if (!"CURRENT_USER_ID".equals(MapUtil.getString((Map)portletDataContext.getParameterMap(), (Object)"USER_ID_STRATEGY"))) {
                return null;
            }
            return "KEEP_CREATOR";
        }).put((Object)"modelClassName", (Object)exportImportDescriptor.getModelClassName()).put((Object)"modelNameLanguageKey", (Object)exportImportDescriptor.getLabelLanguageKey()).putAll(exportImportDescriptor.getParameters(portletDataContext)).build();
        Group group = groupLocalService.fetchGroup(portletDataContext.getScopeGroupId());
        if (!BatchEnginePortletDataHandlerUtil._isCompanyScoped(group, stagingGroupHelper)) {
            importParameters.put("siteExternalReferenceCode", group.getExternalReferenceCode());
            importParameters.put("siteId", group.getGroupId());
        }
        return importParameters;
    }

    private static boolean _isCompanyScoped(Group group, StagingGroupHelper stagingGroupHelper) {
        return group == null || stagingGroupHelper.isCompanyGroup(group);
    }
}

