/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.data.handler;

import com.liferay.exportimport.internal.data.handler.BatchEnginePortletDataHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BatchEnginePortletDataHandlerRegistryUtil {
    private static final Map<Long, Map<String, BatchEnginePortletDataHandler>> _batchEnginePortletDataHandlersMap = new ConcurrentHashMap<Long, Map<String, BatchEnginePortletDataHandler>>();
    private static final Map<Long, Map<String, String>> _portletIdsMap = new ConcurrentHashMap<Long, Map<String, String>>();

    public static BatchEnginePortletDataHandler getByClassName(long companyId, String className) {
        return BatchEnginePortletDataHandlerRegistryUtil.getByPortletId(companyId, BatchEnginePortletDataHandlerRegistryUtil._getPortletId(companyId, className));
    }

    public static BatchEnginePortletDataHandler getByPortletId(long companyId, String portletId) {
        Map<String, BatchEnginePortletDataHandler> batchEnginePortletDataHandlers = _batchEnginePortletDataHandlersMap.get(companyId);
        if (batchEnginePortletDataHandlers == null) {
            return null;
        }
        return batchEnginePortletDataHandlers.get(portletId);
    }

    public static boolean hasByClassName(String className, long companyId) {
        Map<String, String> portletIds = _portletIdsMap.get(companyId);
        if (portletIds == null) {
            return false;
        }
        return portletIds.containsKey(className);
    }

    protected static void put(BatchEnginePortletDataHandler batchEnginePortletDataHandler, long companyId, String portletId) {
        Map batchEnginePortletDataHandlers = _batchEnginePortletDataHandlersMap.computeIfAbsent(companyId, key -> new ConcurrentHashMap());
        batchEnginePortletDataHandlers.put(portletId, batchEnginePortletDataHandler);
        Map portletIds = _portletIdsMap.computeIfAbsent(companyId, key -> new ConcurrentHashMap());
        for (String className : batchEnginePortletDataHandler.getClassNames()) {
            portletIds.put(className, portletId);
        }
    }

    protected static void remove(long companyId, String portletId) {
        _batchEnginePortletDataHandlersMap.computeIfPresent(companyId, (key, batchEnginePortletDataHandlers) -> {
            BatchEnginePortletDataHandler batchEnginePortletDataHandler = (BatchEnginePortletDataHandler)((Object)((Object)batchEnginePortletDataHandlers.remove(portletId)));
            if (batchEnginePortletDataHandler != null) {
                BatchEnginePortletDataHandlerRegistryUtil._removePortletIds(batchEnginePortletDataHandler, companyId, portletId);
            }
            return batchEnginePortletDataHandlers.isEmpty() ? null : batchEnginePortletDataHandlers;
        });
    }

    private static String _getPortletId(long companyId, String className) {
        Map<String, String> portletIds = _portletIdsMap.get(companyId);
        if (portletIds == null) {
            return null;
        }
        return portletIds.get(className);
    }

    private static void _removePortletIds(BatchEnginePortletDataHandler batchEnginePortletDataHandler, long companyId, String portletId) {
        _portletIdsMap.computeIfPresent(companyId, (key, portletIds) -> {
            for (String className : batchEnginePortletDataHandler.getClassNames()) {
                portletIds.remove(className, portletId);
            }
            return portletIds.isEmpty() ? null : portletIds;
        });
    }
}

