/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.data.handler;

import com.liferay.batch.engine.BatchEngineExportTaskExecutor;
import com.liferay.batch.engine.BatchEngineImportTaskExecutor;
import com.liferay.batch.engine.service.BatchEngineExportTaskLocalService;
import com.liferay.batch.engine.service.BatchEngineImportTaskService;
import com.liferay.exportimport.internal.data.handler.BatchEnginePortletDataHandler;
import com.liferay.exportimport.internal.data.handler.BatchEnginePortletDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.vulcan.batch.engine.ExportImportVulcanBatchEngineTaskItemDelegate;
import com.liferay.osgi.service.tracker.collections.EagerServiceTrackerCustomizer;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.feature.flag.FeatureFlagListener;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.staging.StagingGroupHelper;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={})
public class BatchEnginePortletDataHandlerRegistrar {
    @Reference
    private BatchEngineExportTaskExecutor _batchEngineExportTaskExecutor;
    @Reference
    private BatchEngineExportTaskLocalService _batchEngineExportTaskLocalService;
    @Reference
    private BatchEngineImportTaskExecutor _batchEngineImportTaskExecutor;
    @Reference
    private BatchEngineImportTaskService _batchEngineImportTaskService;
    private final Set<Long> _enabledCompanyIds = new CopyOnWriteArraySet<Long>();
    @Reference
    private GroupLocalService _groupLocalService;
    private ServiceRegistration<PortalInstanceLifecycleListener> _portalInstanceLifecycleListenerServiceRegistration;
    private volatile ServiceRegistration<FeatureFlagListener> _serviceRegistration;
    private final Map<String, ServiceRegistration<PortletDataHandler>> _serviceRegistrations = new HashMap<String, ServiceRegistration<PortletDataHandler>>();
    private final DCLSingleton<ServiceTrackerList<ServiceRegistration<PortletDataHandler>>> _serviceTrackerListDCLSingleton = new DCLSingleton();
    @Reference
    private StagingGroupHelper _stagingGroupHelper;

    @Activate
    protected void activate(final BundleContext bundleContext) {
        this._portalInstanceLifecycleListenerServiceRegistration = bundleContext.registerService(PortalInstanceLifecycleListener.class, (Object)new BasePortalInstanceLifecycleListener(){

            public void portalInstanceRegistered(Company company) {
                if (FeatureFlagManagerUtil.isEnabled((long)company.getCompanyId(), (String)"LPD-35914")) {
                    BatchEnginePortletDataHandlerRegistrar.this._registerCompany(bundleContext, company.getCompanyId(), true);
                }
            }

            public void portalInstanceUnregistered(Company company) {
                BatchEnginePortletDataHandlerRegistrar.this._registerCompany(bundleContext, company.getCompanyId(), false);
            }
        }, null);
        this._serviceRegistration = bundleContext.registerService(FeatureFlagListener.class, (companyId, featureFlagKey, enabled) -> this._registerCompany(bundleContext, companyId, enabled), MapUtil.singletonDictionary((Object)"feature.flag.key", (Object)"LPD-35914"));
    }

    @Deactivate
    protected void deactivate() {
        this._portalInstanceLifecycleListenerServiceRegistration.unregister();
        this._serviceRegistration.unregister();
        this._serviceTrackerListDCLSingleton.destroy(ServiceTrackerList::close);
    }

    private void _registerCompany(BundleContext bundleContext, long companyId, boolean enabled) {
        if (enabled) {
            if (this._enabledCompanyIds.contains(companyId)) {
                return;
            }
            this._enabledCompanyIds.add(companyId);
        } else {
            this._enabledCompanyIds.remove(companyId);
        }
        if (this._enabledCompanyIds.isEmpty()) {
            this._serviceTrackerListDCLSingleton.destroy(ServiceTrackerList::close);
            return;
        }
        AtomicBoolean newOpen = new AtomicBoolean();
        this._serviceTrackerListDCLSingleton.getSingleton(() -> {
            newOpen.set(true);
            return ServiceTrackerListFactory.open((BundleContext)bundleContext, null, (String)"(export.import.vulcan.batch.engine.task.item.delegate=true)", (ServiceTrackerCustomizer)new VulcanBatchEngineTaskItemDelegateServiceTrackerCustomizer(bundleContext, companyId));
        });
        if (newOpen.get()) {
            return;
        }
        for (ServiceRegistration<PortletDataHandler> serviceRegistration : this._serviceRegistrations.values()) {
            Dictionary<String, Object> properties = this._toProperties(serviceRegistration.getReference());
            serviceRegistration.setProperties(this._setEnabledCompanyIds(properties));
        }
    }

    private Dictionary<String, Object> _setEnabledCompanyIds(Dictionary<String, Object> properties) {
        return HashMapDictionaryBuilder.putAll(properties).put((Object)"companyId", (Object)ArrayUtil.toStringArray(this._enabledCompanyIds)).build();
    }

    private Dictionary<String, Object> _toProperties(ServiceReference<?> serviceReference) {
        HashMapDictionary properties = new HashMapDictionary();
        for (String key : serviceReference.getPropertyKeys()) {
            Object value = serviceReference.getProperty(key);
            properties.put(key, value);
        }
        return properties;
    }

    private class VulcanBatchEngineTaskItemDelegateServiceTrackerCustomizer
    implements EagerServiceTrackerCustomizer<VulcanBatchEngineTaskItemDelegate, ServiceRegistration<PortletDataHandler>> {
        private final BundleContext _bundleContext;
        private final long _companyId;

        public VulcanBatchEngineTaskItemDelegateServiceTrackerCustomizer(BundleContext bundleContext, long companyId) {
            this._bundleContext = bundleContext;
            this._companyId = companyId;
        }

        public ServiceRegistration<PortletDataHandler> addingService(ServiceReference<VulcanBatchEngineTaskItemDelegate> serviceReference) {
            BatchEnginePortletDataHandler previousBatchEnginePortletDataHandler;
            ExportImportVulcanBatchEngineTaskItemDelegate exportImportVulcanBatchEngineTaskItemDelegate = (ExportImportVulcanBatchEngineTaskItemDelegate)this._bundleContext.getService(serviceReference);
            ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor exportImportDescriptor = exportImportVulcanBatchEngineTaskItemDelegate.getExportImportDescriptor();
            String portletId = exportImportDescriptor.getPortletId();
            BatchEnginePortletDataHandler batchEnginePortletDataHandler = previousBatchEnginePortletDataHandler = BatchEnginePortletDataHandlerRegistryUtil.getByPortletId(this._companyId, portletId);
            if (previousBatchEnginePortletDataHandler == null) {
                batchEnginePortletDataHandler = new BatchEnginePortletDataHandler(BatchEnginePortletDataHandlerRegistrar.this._batchEngineExportTaskExecutor, BatchEnginePortletDataHandlerRegistrar.this._batchEngineExportTaskLocalService, BatchEnginePortletDataHandlerRegistrar.this._batchEngineImportTaskExecutor, BatchEnginePortletDataHandlerRegistrar.this._batchEngineImportTaskService, BatchEnginePortletDataHandlerRegistrar.this._groupLocalService, BatchEnginePortletDataHandlerRegistrar.this._stagingGroupHelper);
                batchEnginePortletDataHandler.setPortletId(exportImportDescriptor.getPortletId());
            }
            batchEnginePortletDataHandler.registerExportImportVulcanBatchEngineTaskItemDelegate((String)GetterUtil.getObject((Object)((String)serviceReference.getProperty("batch.engine.task.item.delegate.class.name")), () -> (String)serviceReference.getProperty("batch.engine.entity.class.name")), exportImportDescriptor, (String)serviceReference.getProperty("batch.engine.task.item.delegate.name"));
            BatchEnginePortletDataHandlerRegistryUtil.put(batchEnginePortletDataHandler, this._companyId, portletId);
            if (previousBatchEnginePortletDataHandler != null) {
                return BatchEnginePortletDataHandlerRegistrar.this._serviceRegistrations.get(portletId);
            }
            ServiceRegistration serviceRegistration = this._bundleContext.registerService(PortletDataHandler.class, (Object)batchEnginePortletDataHandler, BatchEnginePortletDataHandlerRegistrar.this._setEnabledCompanyIds((Dictionary<String, Object>)HashMapDictionaryBuilder.put((Object)"jakarta.portlet.name", (Object)portletId).put((Object)"service.ranking", (Object)Integer.MAX_VALUE).build()));
            BatchEnginePortletDataHandlerRegistrar.this._serviceRegistrations.put(portletId, (ServiceRegistration<PortletDataHandler>)serviceRegistration);
            return serviceRegistration;
        }

        public void modifiedService(ServiceReference<VulcanBatchEngineTaskItemDelegate> serviceReference, ServiceRegistration<PortletDataHandler> serviceRegistration) {
        }

        public void removedService(ServiceReference<VulcanBatchEngineTaskItemDelegate> serviceReference, ServiceRegistration<PortletDataHandler> serviceRegistration) {
            ExportImportVulcanBatchEngineTaskItemDelegate exportImportVulcanBatchEngineTaskItemDelegate = (ExportImportVulcanBatchEngineTaskItemDelegate)this._bundleContext.getService(serviceReference);
            ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor exportImportDescriptor = exportImportVulcanBatchEngineTaskItemDelegate.getExportImportDescriptor();
            String portletId = exportImportDescriptor.getPortletId();
            BatchEnginePortletDataHandler batchEnginePortletDataHandler = BatchEnginePortletDataHandlerRegistryUtil.getByPortletId(this._companyId, portletId);
            if (batchEnginePortletDataHandler == null) {
                return;
            }
            batchEnginePortletDataHandler.unregisterExportImportVulcanBatchEngineTaskItemDelegate((String)GetterUtil.getObject((Object)((String)serviceReference.getProperty("batch.engine.task.item.delegate.class.name")), () -> (String)serviceReference.getProperty("batch.engine.entity.class.name")), (String)serviceReference.getProperty("batch.engine.task.item.delegate.name"));
            String[] classNames = batchEnginePortletDataHandler.getClassNames();
            if (classNames.length == 0) {
                serviceRegistration.unregister();
                BatchEnginePortletDataHandlerRegistryUtil.remove(this._companyId, portletId);
                BatchEnginePortletDataHandlerRegistrar.this._serviceRegistrations.remove(portletId);
            }
        }
    }
}

