/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.background.task;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatus;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageTranslator;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LongWrapper;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DefaultExportImportBackgroundTaskStatusMessageTranslator
implements BackgroundTaskStatusMessageTranslator {
    public void translate(BackgroundTaskStatus backgroundTaskStatus, Message message) {
        String messageType = message.getString("messageType");
        if (messageType.equals("batchProgress")) {
            this._translateBatchProgressMessage(backgroundTaskStatus, message);
        } else if (messageType.equals("layout")) {
            this.translateLayoutMessage(backgroundTaskStatus, message);
        } else if (messageType.equals("portlet")) {
            this.translatePortletMessage(backgroundTaskStatus, message);
        } else if (messageType.equals("stagedModel")) {
            this._translateStagedModelMessage(backgroundTaskStatus, message);
        }
    }

    protected void clearBackgroundTaskStatus(BackgroundTaskStatus backgroundTaskStatus) {
        backgroundTaskStatus.clearAttributes();
        backgroundTaskStatus.setAttribute("allModelAdditionCountersTotal", (Serializable)Long.valueOf(0L));
        backgroundTaskStatus.setAttribute("allPortletAdditionCounter", (Serializable)Long.valueOf(0L));
        backgroundTaskStatus.setAttribute("allPortletModelAdditionCounters", new HashMap());
        backgroundTaskStatus.setAttribute("currentModelAdditionCountersTotal", (Serializable)Long.valueOf(0L));
        backgroundTaskStatus.setAttribute("currentPortletAdditionCounter", (Serializable)Long.valueOf(0L));
        backgroundTaskStatus.setAttribute("currentPortletModelAdditionCounters", new HashMap());
        backgroundTaskStatus.setAttribute("percentage", (Serializable)Integer.valueOf(0));
        backgroundTaskStatus.setAttribute("previousPortletsModelAdditionCountersTotal", (Serializable)Long.valueOf(0L));
    }

    protected synchronized void translateLayoutMessage(BackgroundTaskStatus backgroundTaskStatus, Message message) {
        Map modelAdditionCounters = (Map)message.get("modelAdditionCounters");
        backgroundTaskStatus.setAttribute("allModelAdditionCountersTotal", (Serializable)Long.valueOf(this._getTotal(modelAdditionCounters)));
        long allPortletAdditionCounter = 0L;
        String[] portletIds = (String[])message.get("portletIds");
        if (portletIds != null) {
            allPortletAdditionCounter = portletIds.length;
        }
        backgroundTaskStatus.setAttribute("allPortletAdditionCounter", (Serializable)Long.valueOf(allPortletAdditionCounter));
        this._updatePercentage(backgroundTaskStatus);
    }

    protected synchronized void translatePortletMessage(BackgroundTaskStatus backgroundTaskStatus, Message message) {
        String portletId = message.getString("portletId");
        HashMap allPortletModelAdditionCounters = (HashMap)backgroundTaskStatus.getAttribute("allPortletModelAdditionCounters");
        String previousPortletId = (String)((Object)backgroundTaskStatus.getAttribute("portletId"));
        if (previousPortletId != null && !previousPortletId.equals(portletId)) {
            long previousPortletTotal = GetterUtil.getLong(allPortletModelAdditionCounters.get(previousPortletId));
            long previousPortletsModelAdditionCountersTotal = GetterUtil.getLong((Object)backgroundTaskStatus.getAttribute("previousPortletsModelAdditionCountersTotal"));
            backgroundTaskStatus.setAttribute("previousPortletsModelAdditionCountersTotal", (Serializable)Long.valueOf(previousPortletsModelAdditionCountersTotal + previousPortletTotal));
        }
        long portletModelAdditionCountersTotal = GetterUtil.getLong((Object)message.get("portletModelAdditionCountersTotal"));
        allPortletModelAdditionCounters.put(portletId, portletModelAdditionCountersTotal);
        backgroundTaskStatus.setAttribute("allPortletModelAdditionCounters", (Serializable)allPortletModelAdditionCounters);
        long allPortletAdditionCounter = GetterUtil.getLong((Object)backgroundTaskStatus.getAttribute("allPortletAdditionCounter"));
        long currentPortletAdditionCounter = GetterUtil.getLong((Object)backgroundTaskStatus.getAttribute("currentPortletAdditionCounter"));
        if (currentPortletAdditionCounter < allPortletAdditionCounter) {
            backgroundTaskStatus.setAttribute("currentPortletAdditionCounter", (Serializable)Long.valueOf(++currentPortletAdditionCounter));
        }
        HashMap currentPortletModelAdditionCounters = (HashMap)backgroundTaskStatus.getAttribute("currentPortletModelAdditionCounters");
        currentPortletModelAdditionCounters.put(portletId, 0L);
        backgroundTaskStatus.setAttribute("currentPortletModelAdditionCounters", (Serializable)currentPortletModelAdditionCounters);
        backgroundTaskStatus.setAttribute("portletId", (Serializable)((Object)portletId));
        backgroundTaskStatus.setAttribute("stagedModelName", (Serializable)((Object)""));
        backgroundTaskStatus.setAttribute("stagedModelType", (Serializable)((Object)""));
        backgroundTaskStatus.setAttribute("uuid", (Serializable)((Object)""));
        this._updatePercentage(backgroundTaskStatus);
    }

    private long _getTotal(Map<String, LongWrapper> modelCounters) {
        if (modelCounters == null) {
            return 0L;
        }
        long total = 0L;
        for (Map.Entry<String, LongWrapper> entry : modelCounters.entrySet()) {
            LongWrapper longWrapper = entry.getValue();
            total += longWrapper.getValue();
        }
        return total;
    }

    private synchronized void _translateBatchProgressMessage(BackgroundTaskStatus backgroundTaskStatus, Message message) {
        long allModelAdditionCountersTotal = GetterUtil.getLong((Object)backgroundTaskStatus.getAttribute("allModelAdditionCountersTotal"));
        int batchEngineProcessedItemsCount = GetterUtil.getInteger((Object)message.get("batchEngineProcessedItemsCount"));
        long currentModelAdditionCountersTotal = GetterUtil.getLong((Object)backgroundTaskStatus.getAttribute("currentModelAdditionCountersTotal"));
        long previousPortletsModelAdditionCountersTotal = GetterUtil.getLong((Object)backgroundTaskStatus.getAttribute("previousPortletsModelAdditionCountersTotal"));
        backgroundTaskStatus.setAttribute("currentModelAdditionCountersTotal", (Serializable)Long.valueOf(Math.max(currentModelAdditionCountersTotal, Math.min((long)batchEngineProcessedItemsCount + previousPortletsModelAdditionCountersTotal, allModelAdditionCountersTotal))));
        this._updatePercentage(backgroundTaskStatus);
    }

    private synchronized void _translateStagedModelMessage(BackgroundTaskStatus backgroundTaskStatus, Message message) {
        String portletId = (String)((Object)backgroundTaskStatus.getAttribute("portletId"));
        if (Validator.isNull((String)portletId)) {
            return;
        }
        long allModelAdditionCountersTotal = GetterUtil.getLong((Object)backgroundTaskStatus.getAttribute("allModelAdditionCountersTotal"));
        long currentModelAdditionCountersTotal = GetterUtil.getLong((Object)backgroundTaskStatus.getAttribute("currentModelAdditionCountersTotal"));
        HashMap allPortletModelAdditionCounters = (HashMap)backgroundTaskStatus.getAttribute("allPortletModelAdditionCounters");
        long allPortletModelAdditionCounter = MapUtil.getLong((Map)allPortletModelAdditionCounters, (String)portletId);
        HashMap currentPortletModelAdditionCounters = (HashMap)backgroundTaskStatus.getAttribute("currentPortletModelAdditionCounters");
        long currentPortletModelAdditionCounter = MapUtil.getLong((Map)currentPortletModelAdditionCounters, (String)portletId);
        if (allModelAdditionCountersTotal > currentModelAdditionCountersTotal && allPortletModelAdditionCounter > currentPortletModelAdditionCounter) {
            backgroundTaskStatus.setAttribute("currentModelAdditionCountersTotal", (Serializable)Long.valueOf(++currentModelAdditionCountersTotal));
            currentPortletModelAdditionCounters.put(portletId, ++currentPortletModelAdditionCounter);
            backgroundTaskStatus.setAttribute("currentPortletModelAdditionCounters", (Serializable)currentPortletModelAdditionCounters);
        }
        backgroundTaskStatus.setAttribute("stagedModelName", (Serializable)((Object)message.getString("stagedModelName")));
        backgroundTaskStatus.setAttribute("stagedModelType", (Serializable)((Object)message.getString("stagedModelType")));
        backgroundTaskStatus.setAttribute("uuid", (Serializable)((Object)message.getString("uuid")));
        this._updatePercentage(backgroundTaskStatus);
    }

    private void _updatePercentage(BackgroundTaskStatus backgroundTaskStatus) {
        int percentage = 100;
        long allModelAdditionCountersTotal = GetterUtil.getLong((Object)backgroundTaskStatus.getAttribute("allModelAdditionCountersTotal"));
        long allPortletAdditionCounter = GetterUtil.getLong((Object)backgroundTaskStatus.getAttribute("allPortletAdditionCounter"));
        long currentModelAdditionCountersTotal = GetterUtil.getLong((Object)backgroundTaskStatus.getAttribute("currentModelAdditionCountersTotal"));
        long currentPortletAdditionCounter = GetterUtil.getLong((Object)backgroundTaskStatus.getAttribute("currentPortletAdditionCounter"));
        long allProgressBarCountersTotal = allModelAdditionCountersTotal + allPortletAdditionCounter;
        if (allProgressBarCountersTotal > 0L) {
            long currentProgressBarCountersTotal = currentModelAdditionCountersTotal + currentPortletAdditionCounter;
            percentage = Math.round((float)currentProgressBarCountersTotal / (float)allProgressBarCountersTotal * 100.0f);
        }
        backgroundTaskStatus.setAttribute("percentage", (Serializable)Integer.valueOf(percentage));
    }
}

