/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.attachment;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.exportimport.attachment.ExportImportAttachmentManager;
import com.liferay.exportimport.internal.lar.PortletDataContextThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsUtil;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ExportImportAttachmentManager.class})
public class ExportImportAttachmentManagerImpl
implements ExportImportAttachmentManager {
    private static final String _PROTOCOL = "lar";
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLURLHelper _dlurlHelper;
    @Reference
    private Portal _portal;

    public String getFileURL(DLFileEntry dlFileEntry) throws Exception {
        PortletDataContext portletDataContext = PortletDataContextThreadLocal.getPortletDataContext();
        if (portletDataContext == null || portletDataContext.getZipWriter() == null) {
            FileEntry fileEntry = this._dlAppLocalService.getFileEntry(dlFileEntry.getFileEntryId());
            Company company = this._companyLocalService.getCompany(fileEntry.getCompanyId());
            boolean secure = this._isSecure();
            String portalURL = this._portal.getPortalURL(company.getVirtualHostname(), this._portal.getPortalServerPort(secure), secure);
            return portalURL + this._dlurlHelper.getThumbnailSrc(fileEntry, null);
        }
        try (InputStream inputStream = dlFileEntry.getContentStream();){
            String fileKey = String.valueOf(dlFileEntry.getFileEntryId());
            portletDataContext.addZipEntry(this._getZipPath(fileKey), inputStream);
            String string = "lar:" + fileKey;
            return string;
        }
    }

    public URL getURL(String urlString) throws MalformedURLException {
        final PortletDataContext portletDataContext = PortletDataContextThreadLocal.getPortletDataContext();
        if (!urlString.startsWith("lar:") || portletDataContext == null) {
            return new URL(urlString);
        }
        return new URL(null, urlString, new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL url) {
                return new URLConnection(url){

                    @Override
                    public void connect() {
                    }

                    @Override
                    public InputStream getInputStream() {
                        return portletDataContext.getZipEntryAsInputStream(ExportImportAttachmentManagerImpl.this._getZipPath(this.url.getPath()));
                    }
                };
            }
        });
    }

    private String _getZipPath(String key) {
        return "batch-binaries/" + key;
    }

    private boolean _isSecure() {
        return Objects.equals("https", PropsUtil.get((String)"portal.instance.protocol")) || Objects.equals("https", PropsUtil.get((String)"web.server.protocol"));
    }
}

