/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.upgrade.v1_0_1;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.SystemEventLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

public class SystemEventsUpgradeProcess
extends UpgradeProcess {
    private final GroupLocalService _groupLocalService;
    private final SystemEventLocalService _systemEventLocalService;

    public SystemEventsUpgradeProcess(GroupLocalService groupLocalService, SystemEventLocalService systemEventLocalService) {
        this._groupLocalService = groupLocalService;
        this._systemEventLocalService = systemEventLocalService;
    }

    protected void doUpgrade() throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._groupLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property liveGroupIdProperty = PropertyFactoryUtil.forName((String)"liveGroupId");
            Property remoteStagingGroupCountProperty = PropertyFactoryUtil.forName((String)"remoteStagingGroupCount");
            dynamicQuery.add(RestrictionsFactoryUtil.or((Criterion)liveGroupIdProperty.ne((Object)0L), (Criterion)remoteStagingGroupCountProperty.gt((Object)0)));
        });
        actionableDynamicQuery.setPerformActionMethod(group -> {
            long liveGroupId = group.getLiveGroupId();
            if (liveGroupId == 0L) {
                liveGroupId = group.getGroupId();
            }
            if (!this._systemEventLocalService.validateGroup(liveGroupId)) {
                this._systemEventLocalService.deleteSystemEvents(liveGroupId);
            }
        });
        actionableDynamicQuery.performActions();
    }
}

